/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.helpers.wrappers;

import alma.archive.database.helpers.ArchiveConfigurationOld;
import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.helpers.wrappers.DbConfigException;
import java.util.logging.Logger;

public abstract class AbstractDbConfig {
    public static final String HSQLDB_DRIVER = "org.hsqldb.jdbcDriver";
    public static final String ORACLE_DRIVER = "oracle.jdbc.driver.OracleDriver";
    public static final String MYSQL_DRIVER = "oracle.jdbc.driver.OracleDriver";
    private static final String JDBC_HSQLDB = "jdbc:hsqldb";
    private static final String HSQLDB_DIALECT = "org.hibernate.dialect.HSQLDialect";
    private static final String JDBC_ORACLE = "jdbc:oracle";
    private static final String ORACLE_DIALECT = "org.hibernate.dialect.Oracle10gDialect";
    private static final String JDBC_MYSQL = "jdbc:mysql";
    private static final String MYSQL_DIALECT = "org.hibernate.dialect.MySQLDialect";
    private Logger logger;
    private DBConfiguration dbConfiguration;
    private String connectionUrl;
    private String user;
    private String password;
    private String driver;
    private String dialect;

    public AbstractDbConfig(Logger logger) throws DbConfigException {
        if (logger == null) {
            throw new IllegalArgumentException("Null logger passed to AbstractDbConfig");
        }
        this.logger = logger;
        try {
            this.dbConfiguration = DBConfiguration.instance(logger);
            if (this.dbConfiguration instanceof ArchiveConfigurationOld) {
                String archiveConfigFileSysProp = System.getProperty("archive.configFile");
                String acsDataSysProp = System.getProperty("ACS.data");
                throw new DbConfigException("Could not find archiveConfig.properties. \nJava System property 'archive.configFile' = " + archiveConfigFileSysProp + "\nJava System property 'ACS.data' = " + acsDataSysProp + "\nEither point to archiveConfig.properties directly with the Java system property: 'archive.configFile' \nor define the Java system property 'ACS.data' and put archiveConfig.properties in ACS.data/config.");
            }
            this.extractParams();
        }
        catch (Exception e) {
            throw new DbConfigException(e.getMessage(), e);
        }
    }

    protected abstract void extractParams() throws DbConfigException;

    protected final void configureConnectionUrl(String connUrl) throws DbConfigException {
        this.setConnectionUrl(connUrl);
        if (this.getConnectionUrl().contains(JDBC_ORACLE)) {
            this.setDriver("oracle.jdbc.driver.OracleDriver");
            this.setDialect(ORACLE_DIALECT);
        } else if (this.getConnectionUrl().contains(JDBC_HSQLDB)) {
            this.setDriver(HSQLDB_DRIVER);
            this.setDialect(HSQLDB_DIALECT);
        } else if (this.getConnectionUrl().contains(JDBC_MYSQL)) {
            this.setDriver("oracle.jdbc.driver.OracleDriver");
            this.setDialect(MYSQL_DIALECT);
        } else {
            String msg = "Unsupported db url: " + connUrl;
            this.logger.severe(msg);
            throw new RuntimeException(msg);
        }
    }

    protected final String extractParam(String paramName) throws DbConfigException {
        String paramValue = this.dbConfiguration.get(paramName);
        if (paramValue == null) {
            throw new DbConfigException("Error in archiveConfig.properties: " + paramName + " is not defined");
        }
        this.logger.finer(paramName + " = " + paramValue);
        return paramValue;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.user;
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String getDriver() {
        return this.driver;
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    protected void setUser(String user) {
        this.user = user;
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    protected void setDriver(String driver) {
        this.driver = driver;
    }

    protected void setDialect(String dialect) {
        this.dialect = dialect;
    }
}

