/*
 * Decompiled with CFR 0.152.
 */
package jsky.navigator;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import jsky.image.gui.ImageDisplayMenuBar;
import jsky.interop.PlasticHelper;
import jsky.interop.SampHelper;
import jsky.navigator.NavigatorCatalogMenu;
import jsky.navigator.NavigatorImageDisplay;
import jsky.navigator.NavigatorImageDisplayToolBar;
import jsky.util.I18N;

public class NavigatorImageDisplayMenuBar
extends ImageDisplayMenuBar {
    private static final I18N _I18N = I18N.getInstance(NavigatorImageDisplayMenuBar.class);
    private JMenu _catalogMenu;
    private JMenu _interopMenu;

    public NavigatorImageDisplayMenuBar(NavigatorImageDisplay imageDisplay, NavigatorImageDisplayToolBar toolBar) {
        super(imageDisplay, toolBar);
        this._catalogMenu = new NavigatorCatalogMenu(imageDisplay, true);
        this.add(this._catalogMenu);
        JMenuItem pickObjectMenuItem = this.getPickObjectMenuItem();
        this.getViewMenu().remove(pickObjectMenuItem);
        this._catalogMenu.add(pickObjectMenuItem);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NavigatorImageDisplayMenuBar.this._interopMenu = NavigatorImageDisplayMenuBar.this.createInteropMenu();
                if (NavigatorImageDisplayMenuBar.this._interopMenu != null) {
                    NavigatorImageDisplayMenuBar.this.add(NavigatorImageDisplayMenuBar.this._interopMenu);
                }
            }
        });
    }

    protected JMenu createInteropMenu() {
        SampHelper sh = SampHelper.getInstance();
        PlasticHelper ph = PlasticHelper.getInstance();
        if (sh == null && ph == null) {
            return null;
        }
        JMenu menu = new JMenu(_I18N.getString("interop"));
        if (sh != null && ph != null) {
            JMenu sampMenu = new JMenu("SAMP");
            menu.add(sampMenu);
            sh.initImageMenu(sampMenu);
            JMenu plasticMenu = new JMenu("PLASTIC");
            menu.add(plasticMenu);
            ph.initImageMenu(plasticMenu);
        } else {
            if (sh != null) {
                sh.initImageMenu(menu);
            }
            if (ph != null) {
                ph.initImageMenu(menu);
            }
        }
        return menu;
    }

    public JMenu getCatalogMenu() {
        return this._catalogMenu;
    }

    public JMenu getInteropMenu() {
        return this._interopMenu;
    }
}

