/*
 * Decompiled with CFR 0.152.
 */
package alma.ssr.observingmodes;

import alma.ssr.observingmodes.CalibrationType;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Calibrations
implements Serializable {
    private List<CalibrationType> calibrationTypeList = new ArrayList<CalibrationType>();

    public void addCalibrationType(CalibrationType calibrationType) throws IndexOutOfBoundsException {
        this.calibrationTypeList.add(calibrationType);
    }

    public void addCalibrationType(int n, CalibrationType calibrationType) throws IndexOutOfBoundsException {
        this.calibrationTypeList.add(n, calibrationType);
    }

    public Enumeration<? extends CalibrationType> enumerateCalibrationType() {
        return Collections.enumeration(this.calibrationTypeList);
    }

    public CalibrationType getCalibrationType(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.calibrationTypeList.size()) {
            throw new IndexOutOfBoundsException("getCalibrationType: Index value '" + n + "' not in range [0.." + (this.calibrationTypeList.size() - 1) + "]");
        }
        return this.calibrationTypeList.get(n);
    }

    public CalibrationType[] getCalibrationType() {
        CalibrationType[] calibrationTypeArray = new CalibrationType[]{};
        return this.calibrationTypeList.toArray(calibrationTypeArray);
    }

    public int getCalibrationTypeCount() {
        return this.calibrationTypeList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException validationException) {
            return false;
        }
        return true;
    }

    public Iterator<? extends CalibrationType> iterateCalibrationType() {
        return this.calibrationTypeList.iterator();
    }

    public void marshal(Writer writer) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)writer);
    }

    public void marshal(ContentHandler contentHandler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)contentHandler);
    }

    public void removeAllCalibrationType() {
        this.calibrationTypeList.clear();
    }

    public boolean removeCalibrationType(CalibrationType calibrationType) {
        boolean bl = this.calibrationTypeList.remove(calibrationType);
        return bl;
    }

    public CalibrationType removeCalibrationTypeAt(int n) {
        CalibrationType calibrationType = this.calibrationTypeList.remove(n);
        return calibrationType;
    }

    public void setCalibrationType(int n, CalibrationType calibrationType) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.calibrationTypeList.size()) {
            throw new IndexOutOfBoundsException("setCalibrationType: Index value '" + n + "' not in range [0.." + (this.calibrationTypeList.size() - 1) + "]");
        }
        this.calibrationTypeList.set(n, calibrationType);
    }

    public void setCalibrationType(CalibrationType[] calibrationTypeArray) {
        this.calibrationTypeList.clear();
        for (int i = 0; i < calibrationTypeArray.length; ++i) {
            this.calibrationTypeList.add(calibrationTypeArray[i]);
        }
    }

    public static Calibrations unmarshalCalibrations(Reader reader) throws MarshalException, ValidationException {
        return (Calibrations)Unmarshaller.unmarshal(Calibrations.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

