/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.test;

import java.util.Collection;
import java.util.Iterator;
import nom.tam.util.HashedList;
import org.junit.Assert;
import org.junit.Test;

public class HashedListTester {
    @Test
    public void testCollection() {
        HashedList h1 = new HashedList();
        HashedList h2 = new HashedList();
        HashedList.HashedListIterator i = h1.iterator(0);
        h1.add("Row 1");
        h1.add("Row 2");
        h1.add("Row 3");
        Assert.assertEquals((String)"Adding unkeyed rows", (Object)3, (Object)h1.size());
        Assert.assertEquals((String)"Has row 1", (Object)true, (Object)h1.contains("Row 1"));
        Assert.assertEquals((String)"Has row 2", (Object)true, (Object)h1.contains("Row 2"));
        h1.remove("Row 2");
        Assert.assertEquals((String)"Has row 1", (Object)true, (Object)h1.contains("Row 1"));
        Assert.assertEquals((String)"Has row 2", (Object)false, (Object)h1.contains("Row 2"));
        Assert.assertEquals((String)"Delete unkeyed rows", (Object)2, (Object)h1.size());
        h1.clear();
        Assert.assertEquals((String)"Cleared unkeyed rows", (Object)0, (Object)h1.size());
        h1.add("key 1", "Row 1");
        h1.add("key 2", "Row 2");
        h1.add("key 3", "Row 3");
        Assert.assertEquals((String)"Adding keyed rows", (Object)3, (Object)h1.size());
        Assert.assertEquals((String)"Has Row 1", (Object)true, (Object)h1.contains("Row 1"));
        Assert.assertEquals((String)"Has key 1", (Object)true, (Object)h1.containsKey("key 1"));
        Assert.assertEquals((String)"Has Row 2", (Object)true, (Object)h1.contains("Row 2"));
        Assert.assertEquals((String)"Has key 2", (Object)true, (Object)h1.containsKey("key 2"));
        Assert.assertEquals((String)"Has Row 3", (Object)true, (Object)h1.contains("Row 3"));
        Assert.assertEquals((String)"Has key 3", (Object)true, (Object)h1.containsKey("key 3"));
        h1.removeKey("key 2");
        Assert.assertEquals((String)"Delete keyed row", (Object)2, (Object)h1.size());
        Assert.assertEquals((String)"Has Row 1", (Object)true, (Object)h1.contains("Row 1"));
        Assert.assertEquals((String)"Has key 1", (Object)true, (Object)h1.containsKey("key 1"));
        Assert.assertEquals((String)"Has Row 2", (Object)false, (Object)h1.contains("Row 2"));
        Assert.assertEquals((String)"Has key 2", (Object)false, (Object)h1.containsKey("key 2"));
        Assert.assertEquals((String)"Has Row 3", (Object)true, (Object)h1.contains("Row 3"));
        Assert.assertEquals((String)"Has key 3", (Object)true, (Object)h1.containsKey("key 3"));
        h1.clear();
        Assert.assertEquals((String)"Clear keyed rows", (Object)0, (Object)h1.size());
        h1.add("key 1", "Row 1");
        h1.add("key 2", "Row 2");
        h1.add("key 3", "Row 3");
        Assert.assertEquals((String)"Re-Adding keyed rows", (Object)3, (Object)h1.size());
        Assert.assertEquals((String)"Has Row 2", (Object)true, (Object)h1.contains("Row 2"));
        Assert.assertEquals((String)"Has key 2", (Object)true, (Object)h1.containsKey("key 2"));
        h2.add("key 4", "Row 4");
        h2.add("key 5", "Row 5");
        Assert.assertEquals((String)"containsAll(beforeAdd)", (Object)false, (Object)h1.containsAll((Collection)h2));
        h1.addAll((Collection)h2);
        Assert.assertEquals((String)"addAll()", (Object)5, (Object)h1.size());
        Assert.assertEquals((String)"containsAll(afterAdd)", (Object)true, (Object)h1.containsAll((Collection)h2));
        Assert.assertEquals((String)"has row 4", (Object)true, (Object)h1.contains("Row 4"));
        h1.remove("Row 4");
        Assert.assertEquals((String)"dropped row 4", (Object)false, (Object)h1.contains("Row 4"));
        Assert.assertEquals((String)"containsAll(afterDrop)", (Object)false, (Object)h1.containsAll((Collection)h2));
        Assert.assertEquals((String)"isEmpty(false)", (Object)false, (Object)h1.isEmpty());
        h1.remove("Row 1");
        h1.remove("Row 2");
        h1.remove("Row 3");
        h1.remove("Row 5");
        Assert.assertEquals((String)"isEmpty(true)", (Object)true, (Object)h1.isEmpty());
        h1.add("Row 1");
        h1.add("Row 2");
        h1.add("Row 3");
        h1.addAll((Collection)h2);
        Assert.assertEquals((String)"Adding back", (Object)5, (Object)h1.size());
        h1.removeAll((Collection)h2);
        Assert.assertEquals((String)"removeAll()", (Object)3, (Object)h1.size());
        h1.addAll((Collection)h2);
        Assert.assertEquals((String)"Adding back again", (Object)5, (Object)h1.size());
        h1.retainAll((Collection)h2);
        Assert.assertEquals((String)"retainAll()", (Object)2, (Object)h1.size());
    }

    @Test
    public void testIterator() {
        HashedList h1 = new HashedList();
        h1.add("key 4", "Row 4");
        h1.add("key 5", "Row 5");
        Iterator j = h1.iterator();
        Assert.assertEquals((String)"next1", (Object)true, (Object)j.hasNext());
        Assert.assertEquals((String)"TestIter1", (Object)"Row 4", (Object)((String)j.next()));
        Assert.assertEquals((String)"next2", (Object)true, (Object)j.hasNext());
        Assert.assertEquals((String)"TestIter2", (Object)"Row 5", (Object)((String)j.next()));
        Assert.assertEquals((String)"next3", (Object)false, (Object)j.hasNext());
        h1.clear();
        h1.add("key 1", "Row 1");
        h1.add("key 2", "Row 2");
        h1.add("Row 3");
        h1.add("key 4", "Row 4");
        h1.add("Row 5");
        Assert.assertEquals((String)"Before remove", (Object)true, (Object)h1.contains("Row 2"));
        j = h1.iterator();
        j.next();
        j.next();
        j.remove();
        Assert.assertEquals((String)"After remove", (Object)false, (Object)h1.contains("Row 2"));
        Assert.assertEquals((String)"n3", (Object)true, (Object)j.hasNext());
        Assert.assertEquals((String)"n3v", (Object)"Row 3", (Object)((String)j.next()));
        Assert.assertEquals((String)"n4", (Object)true, (Object)j.hasNext());
        Assert.assertEquals((String)"n4v", (Object)"Row 4", (Object)((String)j.next()));
        Assert.assertEquals((String)"n5", (Object)true, (Object)j.hasNext());
        Assert.assertEquals((String)"n5v", (Object)"Row 5", (Object)((String)j.next()));
        Assert.assertEquals((String)"n6", (Object)false, (Object)j.hasNext());
    }

    @Test
    public void TestCursor() {
        HashedList h1 = new HashedList();
        h1.add("key 1", "Row 1");
        h1.add("Row 3");
        h1.add("key 4", "Row 4");
        h1.add("Row 5");
        HashedList.HashedListIterator j = h1.iterator(0);
        Assert.assertEquals((String)"n1x", (Object)true, (Object)j.hasNext());
        Assert.assertEquals((String)"n1xv", (Object)"Row 1", (Object)((String)j.next()));
        Assert.assertEquals((String)"n1xv", (Object)"Row 3", (Object)((String)j.next()));
        Assert.assertEquals((String)"No Row 2", (Object)false, (Object)h1.containsKey("key 2"));
        Assert.assertEquals((String)"No Row 2", (Object)false, (Object)h1.contains("Row 2"));
        j.setKey("key 1");
        Assert.assertEquals((String)"setKey()", (Object)"Row 1", (Object)((String)j.next()));
        j.add("key 2", "Row 2");
        Assert.assertEquals((String)"has Row 2", (Object)true, (Object)h1.contains("Row 2"));
        Assert.assertEquals((String)"after add", (Object)"Row 3", (Object)((String)j.next()));
        j.setKey("key 4");
        Assert.assertEquals((String)"setKey(1)", (Object)"Row 4", (Object)((String)j.next()));
        Assert.assertEquals((String)"setKey(2)", (Object)"Row 5", (Object)((String)j.next()));
        Assert.assertEquals((String)"setKey(3)", (Object)false, (Object)j.hasNext());
        j.setKey("key 2");
        Assert.assertEquals((String)"setKey(4)", (Object)"Row 2", (Object)((String)j.next()));
        Assert.assertEquals((String)"setKey(5)", (Object)"Row 3", (Object)((String)j.next()));
        j.add("Row 3.5");
        j.add("Row 3.6");
        Assert.assertEquals((String)"After add", (Object)7, (Object)h1.size());
        j = h1.iterator("key 2");
        j.add("Row 1.5");
        j.add("key 1.7", "Row 1.7");
        j.add("Row 1.9");
        Assert.assertEquals((String)"next() after adds", (Object)"Row 2", (Object)((String)j.next()));
        j.setKey("key 1.7");
        Assert.assertEquals((String)"next() after adds", (Object)"Row 1.7", (Object)((String)j.next()));
        Assert.assertEquals((String)"prev(1)", (Object)"Row 1.7", (Object)((String)j.prev()));
        Assert.assertEquals((String)"prev(2)", (Object)"Row 1.5", (Object)((String)j.prev()));
        Assert.assertEquals((String)"prev(3)", (Object)true, (Object)j.hasPrev());
        Assert.assertEquals((String)"prev(4)", (Object)"Row 1", (Object)((String)j.prev()));
        Assert.assertEquals((String)"prev(5)", (Object)false, (Object)j.hasPrev());
    }

    void show(HashedList h, String msg) {
        Iterator t = h.iterator();
        System.out.println("\n Looking at list:" + msg);
        while (t.hasNext()) {
            System.out.println("Has element:" + t.next());
        }
    }
}

