/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.client.cache;

import com.cosylab.logging.client.cache.ILogMap;
import com.cosylab.logging.client.cache.LogCacheException;
import com.cosylab.logging.engine.log.ILogEntry;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LogIterator
implements Iterator<ILogEntry> {
    private ILogMap logs = null;
    private Integer lastReadKey = null;
    private Integer firstKey = null;
    private Integer lastKey = null;

    public LogIterator(ILogMap logs) {
        if (logs == null) {
            throw new IllegalArgumentException("The map of logs can't be null");
        }
        this.logs = logs;
    }

    @Override
    public boolean hasNext() {
        if (this.logs.getSize() == 0) {
            return false;
        }
        if (this.lastReadKey == null) {
            return true;
        }
        this.lastKey = this.logs.getLastLog();
        return this.lastReadKey < this.lastKey;
    }

    @Override
    public ILogEntry next() {
        if (this.lastReadKey == null) {
            this.firstKey = this.logs.getFirstLog();
            try {
                this.lastReadKey = this.firstKey;
                return this.logs.getLog(this.firstKey);
            }
            catch (LogCacheException e) {
                throw new NoSuchElementException("Log not found");
            }
        }
        Integer t = this.lastReadKey + 1;
        while (t <= this.logs.getLastLog()) {
            if (this.logs.keySet().contains(t)) {
                this.lastReadKey = t;
                try {
                    return this.logs.getLog(this.lastReadKey);
                }
                catch (LogCacheException e) {
                    throw new NoSuchElementException("Log not found");
                }
            }
            Integer n = t;
            Integer n2 = t = Integer.valueOf(t + 1);
        }
        throw new NoSuchElementException("No more elements");
    }

    @Override
    public void remove() {
        if (this.lastReadKey == null) {
            throw new IllegalStateException("No log to remove (call next before remove)");
        }
        try {
            this.logs.deleteLog(this.lastReadKey);
        }
        catch (LogCacheException e) {
            throw new IllegalStateException("Log with key " + this.lastReadKey + " already deleted");
        }
    }
}

