/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.errorbrowser;

import alma.acs.logging.errorbrowser.Engine;
import alma.acs.logging.table.LogEntryTableModelBase;
import alma.acs.logging.table.renderer.DateRenderer;
import alma.acs.logging.table.renderer.EntryTypeRenderer;
import alma.acs.logging.table.renderer.InfoRenderer;
import com.cosylab.logging.LoggingClient;
import com.cosylab.logging.client.DetailedLogTable;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogField;
import com.cosylab.logging.settings.FieldChooserDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ErrorTab
extends JSplitPane
implements ActionListener {
    private Engine engine;
    private DetailedLogTable detailedLogTable = new DetailedLogTable();
    private FieldChooserDialog fieldChooser = null;
    private JTable table = new JTable();
    private LogEntryTableModelBase model;
    private JPopupMenu popmenu;
    private TableColumn[] columns = new TableColumn[LogField.values().length];

    public ErrorTab(LogEntryTableModelBase sourceModel, String stackID, LoggingClient client) throws Exception {
        super(1);
        this.model = new LogEntryTableModelBase(client);
        this.table.setModel(this.model);
        this.model.start();
        this.initialize();
        this.engine = new Engine(sourceModel, stackID, this.model);
    }

    private void initialize() {
        this.table.createDefaultColumnsFromModel();
        this.table.setAutoResizeMode(0);
        this.table.setAutoCreateRowSorter(true);
        TableColumnModel tcm = this.table.getColumnModel();
        TableColumn tc = tcm.getColumn(0);
        tc.setCellRenderer(new InfoRenderer());
        tc.setWidth(18);
        tc.setMaxWidth(18);
        tc.setResizable(false);
        tc = tcm.getColumn(LogField.ENTRYTYPE.ordinal() + 1);
        tc.setCellRenderer(new EntryTypeRenderer(false));
        tc = tcm.getColumn(LogField.TIMESTAMP.ordinal() + 1);
        tc.setCellRenderer(new DateRenderer(true));
        for (int t = 1; t < tcm.getColumnCount(); ++t) {
            tc = tcm.getColumn(t);
            tc.setMinWidth(50);
            tc.setPreferredWidth(100);
            tc.setResizable(true);
            tc.setIdentifier(LogField.values()[t - 1]);
            this.columns[t - 1] = tc;
        }
        boolean[] visCols = new boolean[LogField.values().length];
        for (int t = 0; t < visCols.length; ++t) {
            visCols[t] = false;
        }
        visCols[LogField.TIMESTAMP.ordinal()] = true;
        visCols[LogField.ENTRYTYPE.ordinal()] = true;
        visCols[LogField.SOURCEOBJECT.ordinal()] = true;
        visCols[LogField.LOGMESSAGE.ordinal()] = true;
        visCols[LogField.STACKLEVEL.ordinal()] = true;
        this.setupTableCols(visCols);
        this.setRightComponent(new JScrollPane(this.detailedLogTable));
        this.setLeftComponent(new JScrollPane(this.table));
        this.setDividerLocation(this.table.getPreferredSize().width);
        JMenuItem menuItem = new JMenuItem("Select columns...");
        menuItem.addActionListener(this);
        this.popmenu = new JPopupMenu();
        this.popmenu.add(menuItem);
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ErrorTab.this.popmenu.show(ErrorTab.this.table, e.getX(), e.getY());
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    int row = ErrorTab.this.table.rowAtPoint(e.getPoint());
                    ILogEntry log = ErrorTab.this.model.getVisibleLogEntry(ErrorTab.this.table.convertRowIndexToModel(row));
                    ErrorTab.this.detailedLogTable.setupContent(log);
                }
            }
        });
    }

    public void close() {
        this.setVisible(false);
        if (this.engine != null) {
            this.engine.close();
            this.model.close(false);
        }
        if (this.fieldChooser != null) {
            this.fieldChooser.dispose();
            this.fieldChooser = null;
        }
    }

    private void showFieldChooser() {
        if (this.fieldChooser == null) {
            this.fieldChooser = new FieldChooserDialog(this);
        }
        String[] colNames = new String[LogField.values().length];
        boolean[] colVisible = new boolean[colNames.length];
        for (int t = 0; t < colNames.length; ++t) {
            colNames[t] = LogField.values()[t].getName();
            try {
                TableColumn tc = this.table.getColumn(LogField.values()[t]);
                colVisible[t] = true;
                continue;
            }
            catch (IllegalArgumentException e) {
                colVisible[t] = false;
            }
        }
        this.fieldChooser.setupFields(colNames, colVisible);
        this.fieldChooser.setVisible(true);
        if (this.fieldChooser.getModalResult() == FieldChooserDialog.DialogExitAction.OK) {
            this.setupTableCols(this.fieldChooser.getFields());
        }
    }

    private void setupTableCols(boolean[] cols) {
        if (cols == null || cols.length != LogField.values().length) {
            throw new IllegalArgumentException("(nvalid parameter");
        }
        for (int t = 0; t < cols.length; ++t) {
            TableColumn tc = null;
            try {
                tc = this.table.getColumn(LogField.values()[t]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (cols[t]) {
                if (tc != null) continue;
                this.table.getColumnModel().addColumn(this.columns[t]);
                continue;
            }
            if (tc == null) continue;
            this.table.getColumnModel().removeColumn(tc);
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (!b && this.fieldChooser != null) {
            this.fieldChooser.setVisible(b);
        }
        super.setVisible(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showFieldChooser();
    }
}

