/*
 * Decompiled with CFR 0.152.
 */
package jsky.app.jskycat;

import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.app.jskycat.JSkyCat;
import jsky.coords.WorldCoordinateConverter;
import jsky.coords.WorldCoords;
import jsky.image.ImageChangeEvent;
import jsky.image.gui.BasicImageDisplay;
import jsky.image.gui.ImageGraphicsHandler;
import jsky.image.gui.MainImageDisplay;

public class JSkyCatRemoteControl
extends Thread
implements ImageGraphicsHandler,
ChangeListener {
    private ServerSocket _serverSocket;
    private MainImageDisplay _imageDisplay;
    private String _line;
    private String _reply;
    private int _status = 0;
    private boolean _waitForImageDisplay = false;

    public JSkyCatRemoteControl(int portNum, JSkyCat jskycat) throws IOException {
        this._serverSocket = new ServerSocket(portNum);
        this._imageDisplay = jskycat.getImageDisplay();
        this._imageDisplay.addImageGraphicsHandler(this);
        this._imageDisplay.getImageProcessor().addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ImageChangeEvent ice = (ImageChangeEvent)e;
        if (ice.isNewCutLevels()) {
            this._imageDisplay.getImageProcessor().setUserSetCutLevels(true);
        }
    }

    @Override
    public void drawImageGraphics(BasicImageDisplay imageDisplay, Graphics2D g) {
        this._waitForImageDisplay = false;
    }

    @Override
    public void run() {
        try {
            while (true) {
                Socket connection = this._serverSocket.accept();
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                PrintWriter out = new PrintWriter(connection.getOutputStream());
                while ((this._line = in.readLine()) != null) {
                    this._waitForImageDisplay = false;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    JSkyCatRemoteControl.this._reply = JSkyCatRemoteControl.this._evalCommand(JSkyCatRemoteControl.this._line);
                                    JSkyCatRemoteControl.this._status = 0;
                                }
                                catch (Exception e) {
                                    JSkyCatRemoteControl.this._reply = e.toString();
                                    JSkyCatRemoteControl.this._status = 1;
                                }
                            }
                        });
                        while (this._waitForImageDisplay) {
                            Thread.yield();
                        }
                    }
                    catch (Exception e) {
                        this._reply = e.toString();
                        this._status = 1;
                    }
                    int n = this._reply.length();
                    out.println(this._status + " " + n);
                    if (n != 0) {
                        out.print(this._reply);
                    }
                    out.flush();
                }
                connection.close();
                in.close();
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private String _evalCommand(String cmd) {
        if (cmd.equals("update")) {
            return this._updateImage();
        }
        if (cmd.startsWith("config -file ")) {
            return this._showImage(cmd.substring(13));
        }
        if (cmd.equals("wcscenter")) {
            return this._wcsCenter();
        }
        throw new IllegalArgumentException("Unknown remote command: " + cmd);
    }

    private String _updateImage() {
        this._imageDisplay.updateImageData();
        this._waitForImageDisplay = true;
        return "";
    }

    private String _showImage(String fileOrURL) {
        this._imageDisplay.setFilename(fileOrURL);
        this._waitForImageDisplay = true;
        return "";
    }

    private String _wcsCenter() {
        if (!this._imageDisplay.isWCS()) {
            throw new IllegalArgumentException("Image does not support WCS");
        }
        WorldCoordinateConverter wcc = this._imageDisplay.getWCS();
        WorldCoords pos = new WorldCoords(wcc.getWCSCenter(), wcc.getEquinox());
        return pos.toString();
    }
}

