/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.MatchEngine;

public abstract class SkyMatchEngine
implements MatchEngine {
    private double separation_;
    private boolean useErrors_;
    private DescribedValue sepValue_ = new SkySeparationValue();
    private static final double ARC_SECOND = 4.84813681109536E-6;
    private static final DefaultValueInfo SEP_INFO = new DefaultValueInfo("Max Error", Number.class, "Maximum separation along a great circle - additional constraint to per-object errors");
    private static final DefaultValueInfo ERR_INFO = new DefaultValueInfo("Error", Number.class, "Per-object error radius along a great circle");
    private static final DefaultValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Distance between matched objects along a great circle");

    public SkyMatchEngine(double separation, boolean useErrors) {
        this.setSeparation(separation);
        this.setUseErrors(useErrors);
    }

    public void setSeparation(double separation) {
        this.separation_ = separation;
    }

    public double getSeparation() {
        return this.separation_;
    }

    public boolean getUseErrors() {
        return this.useErrors_;
    }

    public void setUseErrors(boolean use) {
        this.useErrors_ = use;
    }

    public double matchScore(Object[] tuple1, Object[] tuple2) {
        double ra2;
        double dec2;
        double dec1;
        double err = this.getSeparation();
        if (this.useErrors_) {
            Number err1 = (Number)tuple1[2];
            Number err2 = (Number)tuple2[2];
            if (!Tables.isBlank(err1) && !Tables.isBlank(err2)) {
                err = Math.min(err, err1.doubleValue() + err2.doubleValue());
            }
        }
        if (Math.abs((dec1 = ((Number)tuple1[1]).doubleValue()) - (dec2 = ((Number)tuple2[1]).doubleValue())) > err) {
            return -1.0;
        }
        double ra1 = ((Number)tuple1[0]).doubleValue();
        double sep = SkyMatchEngine.calculateSeparation(ra1, dec1, ra2 = ((Number)tuple2[0]).doubleValue(), dec2);
        return sep <= err ? sep / 4.84813681109536E-6 : -1.0;
    }

    public Object[] getBins(Object[] tuple) {
        if (tuple[0] instanceof Number && tuple[1] instanceof Number) {
            Number rowErr;
            double ra = ((Number)tuple[0]).doubleValue();
            double dec = ((Number)tuple[1]).doubleValue();
            double err = this.getSeparation();
            if (this.useErrors_ && !Tables.isBlank(rowErr = (Number)tuple[2])) {
                err = Math.min(err, rowErr.doubleValue());
            }
            return this.getBins(ra, dec, err);
        }
        return NO_BINS;
    }

    protected abstract Object[] getBins(double var1, double var3, double var5);

    public ValueInfo getMatchScoreInfo() {
        return new DefaultValueInfo(SCORE_INFO);
    }

    public ValueInfo[] getTupleInfos() {
        ValueInfo[] valueInfoArray;
        if (this.getUseErrors()) {
            ValueInfo[] valueInfoArray2 = new ValueInfo[3];
            valueInfoArray2[0] = new DefaultValueInfo(Tables.RA_INFO);
            valueInfoArray2[1] = new DefaultValueInfo(Tables.DEC_INFO);
            valueInfoArray = valueInfoArray2;
            valueInfoArray2[2] = new DefaultValueInfo(ERR_INFO);
        } else {
            ValueInfo[] valueInfoArray3 = new ValueInfo[2];
            valueInfoArray3[0] = new DefaultValueInfo(Tables.RA_INFO);
            valueInfoArray = valueInfoArray3;
            valueInfoArray3[1] = new DefaultValueInfo(Tables.DEC_INFO);
        }
        return valueInfoArray;
    }

    public DescribedValue[] getMatchParameters() {
        return new DescribedValue[]{this.sepValue_};
    }

    public String toString() {
        return this.getUseErrors() ? "Sky with Errors" : "Sky";
    }

    public boolean canBoundMatch() {
        return true;
    }

    public Comparable[][] getMatchBounds(Comparable[] radecMinIn, Comparable[] radecMaxIn) {
        double rMaxOut;
        double rMinOut;
        double rMinIn = radecMinIn[0] == null ? Double.NaN : ((Number)((Object)radecMinIn[0])).doubleValue();
        double dMinIn = radecMinIn[1] == null ? Double.NaN : ((Number)((Object)radecMinIn[1])).doubleValue();
        double rMaxIn = radecMaxIn[0] == null ? Double.NaN : ((Number)((Object)radecMaxIn[0])).doubleValue();
        double dMaxIn = radecMaxIn[1] == null ? Double.NaN : ((Number)((Object)radecMaxIn[1])).doubleValue();
        double dMinOut = dMinIn - this.separation_;
        double dMaxOut = dMaxIn + this.separation_;
        if (!Double.isNaN(dMinOut) && !Double.isNaN(dMaxOut)) {
            double rDiffMax = Math.max(Math.abs(this.separation_ / Math.cos(dMinOut)), Math.abs(this.separation_ / Math.cos(dMaxOut)));
            rMinOut = rMinIn - rDiffMax;
            rMaxOut = rMaxIn + rDiffMax;
        } else {
            rMinOut = Double.NaN;
            rMaxOut = Double.NaN;
        }
        Comparable[] radecMinOut = new Comparable[this.getUseErrors() ? 3 : 2];
        Comparable[] radecMaxOut = new Comparable[this.getUseErrors() ? 3 : 2];
        if (!Double.isNaN(rMinOut)) {
            if (radecMinIn[0] instanceof Float) {
                radecMinOut[0] = new Float((float)rMinOut);
            } else if (radecMinIn[0] instanceof Double) {
                radecMinOut[0] = new Double(rMinOut);
            }
        }
        if (!Double.isNaN(dMinOut)) {
            if (radecMinIn[1] instanceof Float) {
                radecMinOut[1] = new Float((float)dMinOut);
            } else if (radecMinIn[1] instanceof Double) {
                radecMinOut[1] = new Double(dMinOut);
            }
        }
        if (!Double.isNaN(rMaxOut)) {
            if (radecMaxIn[0] instanceof Float) {
                radecMaxOut[0] = new Float((float)rMaxOut);
            } else if (radecMaxIn[0] instanceof Double) {
                radecMaxOut[0] = new Double(rMaxOut);
            }
        }
        if (!Double.isNaN(dMaxOut)) {
            if (radecMaxIn[1] instanceof Float) {
                radecMaxOut[1] = new Float((float)dMaxOut);
            } else if (radecMaxIn[1] instanceof Double) {
                radecMaxOut[1] = new Double(dMaxOut);
            }
        }
        return new Comparable[][]{radecMinOut, radecMaxOut};
    }

    public static double calculateSeparation(double ra1, double dec1, double ra2, double dec2) {
        return SkyMatchEngine.haversineSeparationFormula(ra1, dec1, ra2, dec2);
    }

    private static double cosineSeparationFormula(double ra1, double dec1, double ra2, double dec2) {
        return Math.acos(Math.sin(dec1) * Math.sin(dec2) + Math.cos(dec1) * Math.cos(dec2) * Math.cos(ra1 - ra2));
    }

    private static double haversineSeparationFormula(double ra1, double dec1, double ra2, double dec2) {
        double sr2;
        double sd2 = Math.sin(0.5 * (dec2 - dec1));
        double a = sd2 * sd2 + (sr2 = Math.sin(0.5 * (ra2 - ra1))) * sr2 * Math.cos(dec1) * Math.cos(dec2);
        return a < 1.0 ? 2.0 * Math.asin(Math.sqrt(a)) : Math.PI;
    }

    static {
        SEP_INFO.setUnitString("radians");
        SEP_INFO.setNullable(false);
        ERR_INFO.setUnitString("radians");
        ERR_INFO.setNullable(true);
        SCORE_INFO.setUnitString("arcsec");
        SCORE_INFO.setUCD("pos.angDistance");
    }

    private class SkySeparationValue
    extends DescribedValue {
        SkySeparationValue() {
            super(SEP_INFO);
        }

        public Object getValue() {
            return new Double(SkyMatchEngine.this.getSeparation());
        }

        public void setValue(Object value) {
            SkyMatchEngine.this.setSeparation((Double)value);
        }
    }
}

