/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.io.IOException;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class ProgressBarStarTable
extends WrapperStarTable {
    private JProgressBar progBar_;

    public ProgressBarStarTable(StarTable baseTable) {
        this(baseTable, new JProgressBar());
    }

    public ProgressBarStarTable(StarTable baseTable, JProgressBar progBar) {
        super(baseTable);
        this.setProgressBar(progBar);
        this.setZero();
    }

    public void setProgressBar(JProgressBar progBar) {
        this.progBar_ = progBar;
    }

    public JProgressBar getProgressBar() {
        return this.progBar_;
    }

    public RowSequence getRowSequence() throws IOException {
        long nrow = this.getRowCount();
        final long every = nrow > 0L ? nrow / 200L : 256L;
        return new WrapperRowSequence(this.baseTable.getRowSequence()){
            long counter;
            int irow;
            Runnable updater;
            {
                super(x0);
                this.updater = new Runnable(){

                    public void run() {
                        ProgressBarStarTable.this.progBar_.setValue(irow);
                    }
                };
            }

            public boolean next() throws IOException {
                ++this.irow;
                if (--this.counter < 0L) {
                    SwingUtilities.invokeLater(this.updater);
                    this.counter = every;
                }
                if (Thread.interrupted()) {
                    throw new IOException("Operation interrupted");
                }
                return super.next();
            }

            public void close() throws IOException {
                ProgressBarStarTable.this.setZero();
                super.close();
            }
        };
    }

    private void setZero() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressBarStarTable.this.progBar_.setMinimum(0);
                ProgressBarStarTable.this.progBar_.setValue(0);
                long nrow = ProgressBarStarTable.this.getRowCount();
                boolean determinate = nrow > 0L && nrow < Integer.MAX_VALUE;
                ProgressBarStarTable.this.progBar_.setIndeterminate(!determinate);
                if (determinate) {
                    ProgressBarStarTable.this.progBar_.setMaximum((int)nrow);
                }
            }
        });
    }
}

