/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.OutputStream;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.StreamStarTableWriter;
import uk.ac.starlink.table.Tables;

public class LatexTableWriter
extends StreamStarTableWriter {
    private boolean standalone;
    static /* synthetic */ Class class$java$lang$Number;

    public LatexTableWriter() {
        this(false);
    }

    public LatexTableWriter(boolean standalone) {
        this.setStandalone(standalone);
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public String getFormatName() {
        return this.standalone ? "LaTeX-document" : "LaTeX";
    }

    public String getMimeType() {
        return "text/plain";
    }

    public boolean looksLikeFile(String location) {
        return location.endsWith(".tex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStarTable(StarTable startab, OutputStream ostrm) throws IOException {
        StringBuffer tfmt = new StringBuffer("|");
        ColumnInfo[] colinfos = Tables.getColumnInfos(startab);
        int ncol = colinfos.length;
        int[] maxWidths = new int[ncol];
        for (int i = 0; i < ncol; ++i) {
            ColumnInfo colinfo;
            Class clazz;
            if ((class$java$lang$Number == null ? LatexTableWriter.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(clazz = (colinfo = colinfos[i]).getContentClass())) {
                tfmt.append('r');
                maxWidths[i] = 16;
            } else {
                tfmt.append('l');
                maxWidths[i] = 66;
            }
            tfmt.append('|');
        }
        RowSequence rseq = startab.getRowSequence();
        try {
            if (this.standalone) {
                this.printHeader(ostrm, startab);
            }
            this.printLine(ostrm, "\\begin{tabular}{" + tfmt + "}");
            this.printLine(ostrm, "\\hline");
            for (int i = 0; i < ncol; ++i) {
                boolean first = i == 0;
                boolean last = i == ncol - 1;
                ColumnInfo colinfo = colinfos[i];
                String line = "  \\multicolumn{1}{" + (first ? "|" : "") + 'c' + "|" + "}{" + this.escape(colinfo.getName()) + "} " + (last ? "\\\\" : "&");
                this.printLine(ostrm, line);
            }
            this.printLine(ostrm, "\\hline");
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                this.print(ostrm, "  ");
                for (int i = 0; i < ncol; ++i) {
                    String datum = colinfos[i].formatValue(row[i], maxWidths[i]);
                    if (i > 0) {
                        this.print(ostrm, " & ");
                    }
                    this.print(ostrm, this.escape(datum));
                }
                this.printLine(ostrm, "\\\\");
            }
            this.print(ostrm, "\\hline");
            this.printLine(ostrm, "\\end{tabular}");
            if (this.standalone) {
                this.printFooter(ostrm, startab);
            }
        }
        finally {
            rseq.close();
        }
    }

    public static StarTableWriter[] getStarTableWriters() {
        return new LatexTableWriter[]{new LatexTableWriter(false), new LatexTableWriter(true)};
    }

    protected void printHeader(OutputStream ostrm, StarTable startab) throws IOException {
        this.printLine(ostrm, "\\documentclass{article}");
        this.printLine(ostrm, "\\begin{document}");
        this.printLine(ostrm, "\\begin{table}");
    }

    protected void printFooter(OutputStream ostrm, StarTable startab) throws IOException {
        String tname = startab.getName();
        if (tname != null && tname.trim().length() > 0) {
            this.printLine(ostrm, "\\caption{" + this.escape(tname) + "}");
        }
        this.printLine(ostrm, "\\end{table}");
        this.printLine(ostrm, "\\end{document}");
    }

    private void printLine(OutputStream ostrm, String line) throws IOException {
        this.print(ostrm, line);
        ostrm.write(10);
    }

    private void print(OutputStream ostrm, String str) throws IOException {
        ostrm.write(str.getBytes());
    }

    private String escape(String line) {
        StringBuffer sbuf = new StringBuffer();
        block4: for (int i = 0; i < line.length(); ++i) {
            char chr = line.charAt(i);
            switch (chr) {
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '_': 
                case '{': 
                case '}': {
                    sbuf.append('\\').append(chr);
                    continue block4;
                }
                case '\\': 
                case '^': 
                case '~': {
                    sbuf.append("\\verb+").append(chr).append('+');
                    continue block4;
                }
                default: {
                    sbuf.append(chr > '\u0000' && chr < '\u007f' ? chr : (char)'?');
                }
            }
        }
        return sbuf.toString();
    }
}

