/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.net.URL;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RandomRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.WrapperStarTable;

public abstract class RandomWrapperStarTable
extends WrapperStarTable {
    private long rowsStored = 0L;
    private ColumnInfo[] colinfos;
    private RowSequence baseSeq;
    private IOException savedError;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RandomWrapperStarTable(StarTable baseTable) throws IOException {
        super(baseTable);
        this.colinfos = Tables.getColumnInfos(baseTable);
        this.baseSeq = baseTable.getRowSequence();
    }

    protected abstract void storeNextRow(Object[] var1);

    protected abstract Object[] retrieveStoredRow(long var1);

    public boolean isRandom() {
        return true;
    }

    public int getColumnCount() {
        return this.colinfos.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRowCount() {
        if (this.baseSeq == null) {
            return this.rowsStored;
        }
        long nr = super.getRowCount();
        if (nr >= 0L) {
            return nr;
        }
        try {
            RandomWrapperStarTable randomWrapperStarTable = this;
            synchronized (randomWrapperStarTable) {
                while (this.baseSeq.next()) {
                    this.storeNextRow(this.baseSeq.getRow());
                    ++this.rowsStored;
                }
                this.baseSeq.close();
                this.baseSeq = null;
            }
        }
        catch (IOException e) {
            this.savedError = e;
        }
        return this.rowsStored;
    }

    public URL getURL() {
        return this.baseTable.getURL();
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colinfos[icol];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getRow(long lrow) throws IOException {
        this.checkSavedError();
        RandomWrapperStarTable randomWrapperStarTable = this;
        synchronized (randomWrapperStarTable) {
            while (lrow >= this.rowsStored) {
                if (this.baseSeq != null) {
                    if (this.baseSeq.next()) {
                        this.storeNextRow(this.baseSeq.getRow());
                        ++this.rowsStored;
                        continue;
                    }
                    this.baseSeq.close();
                    this.baseSeq = null;
                    continue;
                }
                throw new IllegalArgumentException("Attempted read beyond end of table");
            }
        }
        if (!$assertionsDisabled && lrow >= this.rowsStored) {
            throw new AssertionError();
        }
        return this.retrieveStoredRow(lrow);
    }

    public Object getCell(long lrow, int icol) throws IOException {
        this.checkSavedError();
        return this.getRow(lrow)[icol];
    }

    public RowSequence getRowSequence() throws IOException {
        this.checkSavedError();
        return new RandomRowSequence(this);
    }

    private void checkSavedError() throws IOException {
        if (this.savedError != null) {
            IOException e = this.savedError;
            this.savedError = null;
            throw e;
        }
    }

    static {
        $assertionsDisabled = !RandomWrapperStarTable.class.desiredAssertionStatus();
    }
}

