/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.arch.io.hcompress;

import ca.nrc.cadc.arch.io.BadMagicNumberException;
import ca.nrc.cadc.arch.io.BulkDataInput;
import ca.nrc.cadc.arch.io.hcompress.HCompressDecoder;
import ca.nrc.cadc.arch.io.hcompress.HCompressProcessor;
import ca.nrc.cadc.arch.io.hcompress.HCompressUtil;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class HCompressInputStream
implements BulkDataInput {
    private boolean eos;
    private int smooth = 0;
    private boolean waitingForHeader;
    private boolean use_direct;
    private boolean first_read;
    private int nx = -1;
    private int ny = -1;
    private int scale = 0;
    private int num_bytes = 0;
    private int header_bytes = 0;
    private int ibuf_data_len;
    private int ipos;
    private byte[] byte_singleton = new byte[1];
    private short[] short_singleton = new short[1];
    private int[] singleton = new int[1];
    private int[] ibuf;
    private InputStream istream;
    private DataInputStream datastream;

    public HCompressInputStream(DataInputStream dataInputStream, InputStream inputStream) throws BadMagicNumberException, IOException {
        this.datastream = dataInputStream;
        this.istream = inputStream;
        this.init();
    }

    public HCompressInputStream(InputStream inputStream) throws BadMagicNumberException, IOException {
        if (inputStream instanceof DataInputStream) {
            this.datastream = (DataInputStream)inputStream;
            this.istream = inputStream;
        } else {
            this.datastream = new DataInputStream(inputStream);
            this.istream = inputStream;
        }
        this.init();
    }

    public void cleanup() {
        this.ibuf = null;
        System.gc();
    }

    public void close() throws IOException, EOFException {
        this.datastream.close();
        this.eos = true;
        this.cleanup();
    }

    private int decompress() throws IOException, EOFException {
        HCompressDecoder hCompressDecoder = new HCompressDecoder();
        int n = this.datastream.readInt();
        this.num_bytes = hCompressDecoder.decode(this.istream, this.ibuf, this.nx, this.ny, n);
        HCompressProcessor.undigitize(this.ibuf, this.nx, this.ny, this.scale);
        HCompressProcessor.hinv(this.ibuf, this.nx, this.ny, this.smooth, this.scale);
        return this.nx * this.ny;
    }

    public int getByteCount() {
        return this.header_bytes + this.num_bytes;
    }

    public int getHeight() {
        return this.ny;
    }

    public int getScale() {
        return this.scale;
    }

    public int getWidth() {
        return this.nx;
    }

    private void init() throws BadMagicNumberException, IOException {
        this.waitingForHeader = true;
        this.first_read = true;
        this.readHeader();
    }

    public byte readByte() throws EOFException, IOException {
        int n = this.readByte(this.byte_singleton, 0, 1);
        if (n == -1) {
            throw new EOFException();
        }
        return this.byte_singleton[0];
    }

    public int readByte(byte[] byArray) throws IOException, EOFException {
        return this.readByte(byArray, 0, byArray.length);
    }

    public int readByte(byte[] byArray, int n, int n2) throws IOException, EOFException {
        if (this.waitingForHeader) {
            throw new IOException("HCompressInputStream.setDimensions must be called before reading");
        }
        if (this.eos) {
            return -1;
        }
        if (this.first_read) {
            this.ibuf = new int[this.nx * this.ny];
            this.use_direct = false;
            this.ibuf_data_len = this.decompress();
            this.first_read = false;
        }
        if (this.use_direct) {
            this.eos = true;
            return this.ibuf_data_len;
        }
        int n3 = n2;
        if (this.ipos + n2 > this.ibuf.length) {
            n3 = this.ibuf.length - this.ipos;
        }
        if (!this.use_direct) {
            int n4 = 0;
            while (n4 < n3) {
                byArray[n4 + n] = (byte)this.ibuf[n4 + this.ipos];
                ++n4;
            }
            this.ipos += n3;
        }
        if (this.ipos == this.ibuf.length) {
            this.eos = true;
        }
        return n3;
    }

    public int readChar(char[] cArray) {
        return this.readChar(cArray, 0, cArray.length);
    }

    public int readChar(char[] cArray, int n, int n2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int readDouble(double[] dArray) {
        return this.readDouble(dArray, 0, dArray.length);
    }

    public int readDouble(double[] dArray, int n, int n2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int readFloat(float[] fArray) {
        return this.readFloat(fArray, 0, fArray.length);
    }

    public int readFloat(float[] fArray, int n, int n2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private void readHeader() throws BadMagicNumberException, IOException, EOFException {
        int n = this.datastream.readUnsignedShort();
        if (!HCompressUtil.isMagic(n)) {
            throw new BadMagicNumberException();
        }
        this.nx = this.datastream.readInt();
        this.ny = this.datastream.readInt();
        this.scale = this.datastream.readInt();
        this.header_bytes = 14;
        this.ibuf = null;
        this.ibuf_data_len = 0;
        this.ipos = 0;
        this.waitingForHeader = false;
        this.eos = false;
    }

    public int readInt() throws EOFException, IOException {
        int n = this.readInt(this.singleton, 0, 1);
        if (n == -1) {
            throw new EOFException();
        }
        return this.singleton[0];
    }

    public int readInt(int[] nArray) throws IOException, EOFException {
        return this.readInt(nArray, 0, nArray.length);
    }

    public int readInt(int[] nArray, int n, int n2) throws IOException, EOFException {
        if (this.waitingForHeader) {
            throw new IOException("HCompressInputStream.setDimensions must be called before reading");
        }
        if (this.eos) {
            return -1;
        }
        if (this.first_read) {
            if (nArray.length == this.nx * this.ny && this.ibuf == null) {
                this.ibuf = nArray;
                this.use_direct = true;
            } else {
                this.ibuf = new int[this.nx * this.ny];
                this.use_direct = false;
            }
            this.ibuf_data_len = this.decompress();
            this.first_read = false;
        }
        if (this.use_direct) {
            this.eos = true;
            return this.ibuf_data_len;
        }
        int n3 = n2;
        if (this.ipos + n2 > this.ibuf.length) {
            n3 = this.ibuf.length - this.ipos;
        }
        if (!this.use_direct) {
            System.arraycopy(this.ibuf, this.ipos, nArray, n, n3);
            this.ipos += n3;
        }
        if (this.ipos == this.ibuf.length) {
            this.eos = true;
        }
        return n3;
    }

    public int readLong(long[] lArray) {
        return this.readLong(lArray, 0, lArray.length);
    }

    public int readLong(long[] lArray, int n, int n2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public short readShort() throws EOFException, IOException {
        int n = this.readShort(this.short_singleton, 0, 1);
        if (n == -1) {
            throw new EOFException();
        }
        return this.short_singleton[0];
    }

    public int readShort(short[] sArray) throws IOException, EOFException {
        return this.readShort(sArray, 0, sArray.length);
    }

    public int readShort(short[] sArray, int n, int n2) throws IOException, EOFException {
        if (this.waitingForHeader) {
            throw new IOException("HCompressInputStream.setDimensions must be called before reading");
        }
        if (this.eos) {
            return -1;
        }
        if (this.first_read) {
            this.ibuf = new int[this.nx * this.ny];
            this.use_direct = false;
            this.ibuf_data_len = this.decompress();
            this.first_read = false;
        }
        if (this.use_direct) {
            this.eos = true;
            return this.ibuf_data_len;
        }
        int n3 = n2;
        if (this.ipos + n2 > this.ibuf.length) {
            n3 = this.ibuf.length - this.ipos;
        }
        if (!this.use_direct) {
            int n4 = 0;
            while (n4 < n3) {
                sArray[n4 + n] = (short)this.ibuf[n4 + this.ipos];
                ++n4;
            }
            this.ipos += n3;
        }
        if (this.ipos == this.ibuf.length) {
            this.eos = true;
        }
        return n3;
    }

    public int readUnsignedByte(short[] sArray) {
        return this.readUnsignedByte(sArray, 0, sArray.length);
    }

    public int readUnsignedByte(short[] sArray, int n, int n2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int readUnsignedShort(int[] nArray) {
        return this.readUnsignedShort(nArray, 0, nArray.length);
    }

    public int readUnsignedShort(int[] nArray, int n, int n2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setSmoothing(boolean bl) {
        this.smooth = bl ? 1 : 0;
    }
}

