/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.arch.io.hcompress;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class HCompressDecoder {
    private int bytes_read = 0;
    private StringBuffer error_msg = new StringBuffer();
    private int PR_SUCCESS = 0;
    private int PR_E_IO = -1;
    private int PR_E_CODE = -2;
    private int PR_E_BITPLANE = -3;
    private int buffer;
    private int bits_to_go;

    public int decode(InputStream inputStream, int[] nArray, int n, int n2, int n3) throws IOException, EOFException {
        boolean bl = false;
        byte[] byArray = new byte[3];
        int n4 = n * n2;
        int n5 = 0;
        while (n5 < 3) {
            byArray[n5] = (byte)inputStream.read();
            ++n5;
        }
        int n6 = this.dodecode(inputStream, nArray, n, n2, byArray);
        if (n6 != this.PR_SUCCESS) {
            throw new IOException("hcompress decoding failed (" + n6 + ")");
        }
        nArray[0] = n3;
        return this.bytes_read;
    }

    private int dodecode(InputStream inputStream, int[] nArray, int n, int n2, byte[] byArray) {
        int n3 = n * n2;
        int n4 = (n + 1) / 2;
        int n5 = (n2 + 1) / 2;
        int n6 = 0;
        while (n6 < n3) {
            nArray[n6] = 0;
            ++n6;
        }
        this.start_inputing_bits();
        int n7 = this.qtree_decode(inputStream, nArray, 0, n2, n4, n5, byArray[0]);
        if (n7 != this.PR_SUCCESS) {
            return n7;
        }
        n7 = this.qtree_decode(inputStream, nArray, n5, n2, n4, n2 / 2, byArray[1]);
        if (n7 != this.PR_SUCCESS) {
            return n7;
        }
        n7 = this.qtree_decode(inputStream, nArray, n2 * n4, n2, n / 2, n5, byArray[1]);
        if (n7 != this.PR_SUCCESS) {
            return n7;
        }
        n7 = this.qtree_decode(inputStream, nArray, n2 * n4 + n5, n2, n / 2, n2 / 2, byArray[2]);
        if (n7 != this.PR_SUCCESS) {
            return n7;
        }
        try {
            int n8 = this.input_nybble(inputStream);
            if (n8 != 0) {
                return this.PR_E_BITPLANE;
            }
        }
        catch (IOException iOException) {
            return this.PR_E_IO;
        }
        this.start_inputing_bits();
        n6 = 0;
        while (n6 < n3) {
            if (nArray[n6] != 0) {
                byte by;
                try {
                    by = (byte)this.input_bit(inputStream);
                }
                catch (IOException iOException) {
                    return this.PR_E_IO;
                }
                if (by != 0) {
                    nArray[n6] = -nArray[n6];
                }
            }
            ++n6;
        }
        return this.PR_SUCCESS;
    }

    private int input_bit(InputStream inputStream) throws IOException, EOFException {
        return this.input_nbits(inputStream, 1);
    }

    private int input_huffman(InputStream inputStream) throws IOException, EOFException {
        int n = this.input_nbits(inputStream, 3);
        if (n < 4) {
            return 1 << n;
        }
        int n2 = this.input_bit(inputStream);
        n = n2 | n << 1;
        if (n < 13) {
            switch (n) {
                case 8: {
                    return 3;
                }
                case 9: {
                    return 5;
                }
                case 10: {
                    return 10;
                }
                case 11: {
                    return 12;
                }
                case 12: {
                    return 15;
                }
            }
        }
        if ((n = (n2 = this.input_bit(inputStream)) | n << 1) < 31) {
            switch (n) {
                case 26: {
                    return 6;
                }
                case 27: {
                    return 7;
                }
                case 28: {
                    return 9;
                }
                case 29: {
                    return 11;
                }
                case 30: {
                    return 13;
                }
            }
        }
        if ((n = (n2 = this.input_bit(inputStream)) | n << 1) == 62) {
            return 0;
        }
        return 14;
    }

    private int input_nbits(InputStream inputStream, int n) throws IOException, EOFException {
        if (this.bits_to_go < n) {
            this.buffer <<= 8;
            int n2 = inputStream.read();
            if (n2 == -1) {
                throw new IOException("unexpected end-of-stream");
            }
            ++this.bytes_read;
            this.buffer |= n2;
            this.bits_to_go += 8;
        }
        this.bits_to_go -= n;
        return this.buffer >> this.bits_to_go & (1 << n) - 1;
    }

    private int input_nybble(InputStream inputStream) throws IOException, EOFException {
        return this.input_nbits(inputStream, 4);
    }

    private void qtree_bitins(byte[] byArray, int n, int n2, int[] nArray, int n3, int n4, int n5) {
        int n6;
        int n7 = 1 << n5;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n - 1) {
            n6 = n3 + n4 * n9;
            int n10 = n6 + n4;
            while (n6 < n3 + n4 * n9 + n2 - 1) {
                int n11 = byArray[n8] << n5;
                int n12 = n10 + 1;
                nArray[n12] = nArray[n12] | n11 & n7;
                int n13 = n10;
                nArray[n13] = nArray[n13] | n11 >> 1 & n7;
                int n14 = n6 + 1;
                nArray[n14] = nArray[n14] | n11 >> 2 & n7;
                int n15 = n6;
                nArray[n15] = nArray[n15] | n11 >> 3 & n7;
                ++n8;
                n6 += 2;
                n10 += 2;
            }
            if (n6 < n3 + n4 * n9 + n2) {
                int n16 = n10;
                nArray[n16] = nArray[n16] | (byArray[n8] >> 1 & 1) << n5;
                int n17 = n6;
                nArray[n17] = nArray[n17] | (byArray[n8] >> 3 & 1) << n5;
                ++n8;
            }
            n9 += 2;
        }
        if (n9 < n) {
            n6 = n3 + n4 * n9;
            int n18 = 0;
            while (n18 < n2 - 1) {
                int n19 = n6 + 1;
                nArray[n19] = nArray[n19] | (byArray[n8] >> 2 & 1) << n5;
                int n20 = n6;
                nArray[n20] = nArray[n20] | (byArray[n8] >> 3 & 1) << n5;
                n6 += 2;
                ++n8;
                n18 += 2;
            }
            if (n18 < n2) {
                int n21 = n6;
                nArray[n21] = nArray[n21] | (byArray[n8] >> 3 & 1) << n5;
                int n22 = n8;
                byArray[n22] = (byte)(byArray[n22] + 1);
            }
        }
    }

    private void qtree_copy(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4;
        int n5;
        int n6 = (n + 1) / 2;
        int n7 = (n2 + 1) / 2;
        int n8 = n7 * (n6 - 1) + n7 - 1;
        int n9 = n6 - 1;
        while (n9 >= 0) {
            n5 = 2 * (n3 * n9 + n7 - 1);
            n4 = n7 - 1;
            while (n4 >= 0) {
                byArray2[n5] = byArray[n8];
                --n8;
                n5 -= 2;
                --n4;
            }
            --n9;
        }
        n9 = 0;
        while (n9 < n - 1) {
            n5 = n3 * n9;
            int n10 = n5 + n3;
            n4 = 0;
            while (n4 < n2 - 1) {
                byArray2[n10 + 1] = (byte)(byArray2[n5] & 1);
                byArray2[n10] = (byte)(byArray2[n5] >> 1 & 1);
                byArray2[n5 + 1] = (byte)(byArray2[n5] >> 2 & 1);
                byArray2[n5] = (byte)(byArray2[n5] >> 3 & 1);
                n5 += 2;
                n10 += 2;
                n4 += 2;
            }
            if (n4 < n2) {
                byArray2[n10] = (byte)(byArray2[n5] >> 1 & 1);
                byArray2[n5] = (byte)(byArray2[n5] >> 3 & 1);
            }
            n9 += 2;
        }
        if (n9 < n) {
            n5 = n3 * n9;
            n4 = 0;
            while (n4 < n2 - 1) {
                byArray2[n5 + 1] = (byte)(byArray2[n5] >> 2 & 1);
                byArray2[n5] = (byte)(byArray2[n5] >> 3 & 1);
                n5 += 2;
                n4 += 2;
            }
            if (n4 < n2) {
                byArray2[n5] = (byte)(byArray2[n5] >> 3 & 1);
            }
        }
    }

    private int qtree_decode(InputStream inputStream, int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n3 > n4 ? n3 : n4;
        if (n7 > 1 << (n6 = (int)(Math.log(n7) / Math.log(2.0) + 0.5))) {
            ++n6;
        }
        int n8 = (n3 + 1) / 2;
        int n9 = (n4 + 1) / 2;
        byte[] byArray = new byte[n8 * n9];
        int n10 = n5 - 1;
        while (n10 >= 0) {
            int n11;
            int n12;
            try {
                n12 = this.input_nybble(inputStream);
            }
            catch (IOException iOException) {
                return this.PR_E_IO;
            }
            if (n12 == 0) {
                n11 = this.read_bdirect(inputStream, nArray, n, n2, n3, n4, byArray, n10);
                if (n11 != this.PR_SUCCESS) {
                    return n11;
                }
            } else {
                if (n12 != 15) {
                    return this.PR_E_CODE;
                }
                try {
                    byArray[0] = (byte)this.input_huffman(inputStream);
                }
                catch (IOException iOException) {
                    return this.PR_E_IO;
                }
                int n13 = 1;
                int n14 = 1;
                int n15 = n3;
                int n16 = n4;
                int n17 = 1 << n6;
                int n18 = 1;
                while (n18 < n6) {
                    n13 <<= 1;
                    n14 <<= 1;
                    if (n15 <= (n17 >>= 1)) {
                        --n13;
                    } else {
                        n15 -= n17;
                    }
                    if (n16 <= n17) {
                        --n14;
                    } else {
                        n16 -= n17;
                    }
                    n11 = this.qtree_expand(inputStream, byArray, n13, n14, byArray);
                    if (n11 != this.PR_SUCCESS) {
                        return n11;
                    }
                    ++n18;
                }
                this.qtree_bitins(byArray, n3, n4, nArray, n, n2, n10);
            }
            --n10;
        }
        return this.PR_SUCCESS;
    }

    private int qtree_expand(InputStream inputStream, byte[] byArray, int n, int n2, byte[] byArray2) {
        this.qtree_copy(byArray, n, n2, byArray2, n2);
        int n3 = n * n2 - 1;
        while (n3 >= 0) {
            if (byArray2[n3] != 0) {
                try {
                    byArray2[n3] = (byte)this.input_huffman(inputStream);
                }
                catch (IOException iOException) {
                    return this.PR_E_IO;
                }
            }
            --n3;
        }
        return this.PR_SUCCESS;
    }

    private int read_bdirect(InputStream inputStream, int[] nArray, int n, int n2, int n3, int n4, byte[] byArray, int n5) {
        int n6 = 0;
        while (n6 < (n3 + 1) / 2 * ((n4 + 1) / 2)) {
            try {
                byArray[n6] = (byte)this.input_nybble(inputStream);
            }
            catch (IOException iOException) {
                return this.PR_E_IO;
            }
            ++n6;
        }
        this.qtree_bitins(byArray, n3, n4, nArray, n, n2, n5);
        return this.PR_SUCCESS;
    }

    private void start_inputing_bits() {
        this.buffer = 0;
        this.bits_to_go = 0;
    }
}

