/*
 * Decompiled with CFR 0.152.
 */
package alma.correlatorSrc.CorrConfigValidator;

import alma.ACSErrTypeCommon.wrappers.AcsJBadParameterEx;
import alma.AtmPhaseCorrectionMod.AtmPhaseCorrection;
import alma.Correlator.ACAPhaseSwitchingConfigurations;
import alma.Correlator.BaseBandConfig;
import alma.Correlator.BinSwitching_t;
import alma.Correlator.ChannelAverageRegion;
import alma.Correlator.CorrelatorConfiguration;
import alma.Correlator.SpectralWindow;
import alma.ReceiverSidebandMod.ReceiverSideband;
import alma.StokesParameterMod.StokesParameter;
import alma.SynthProfMod.SynthProf;
import alma.correlatorSrc.CorrConfigValidator.SBConversionException;
import alma.correlatorSrc.CorrConfigValidator.XMLParserBase;
import alma.entity.xmlbinding.schedblock.AbstractBaseBandConfigT;
import alma.entity.xmlbinding.schedblock.AbstractCorrelatorConfigurationT;
import alma.entity.xmlbinding.schedblock.AbstractSpectralWindowT;
import alma.entity.xmlbinding.schedblock.BLBaseBandConfigT;
import alma.entity.xmlbinding.schedblock.BLCorrelatorConfigurationT;
import alma.entity.xmlbinding.schedblock.BLSpectralWindowT;
import alma.entity.xmlbinding.schedblock.BaseBandSpecificationT;
import alma.entity.xmlbinding.schedblock.BeamSwitchingCycleT;
import alma.entity.xmlbinding.schedblock.ChannelAverageRegionT;
import alma.entity.xmlbinding.schedblock.FrequencySetupT;
import alma.entity.xmlbinding.schedblock.SpectralSpecT;
import alma.entity.xmlbinding.schedblock.types.SpectralSpecTReceiverTypeType;
import alma.entity.xmlbinding.valuetypes.TimeT;
import alma.hla.datamodel.enumeration.JAccumMode;
import alma.hla.datamodel.enumeration.JBasebandName;
import alma.hla.datamodel.enumeration.JCorrelationBit;
import alma.hla.datamodel.enumeration.JCorrelationMode;
import alma.hla.datamodel.enumeration.JNetSideband;
import alma.hla.datamodel.enumeration.JReceiverBand;
import alma.hla.datamodel.enumeration.JSidebandProcessingMode;
import alma.hla.datamodel.enumeration.JStokesParameter;
import alma.hla.datamodel.enumeration.JSwitchingMode;
import alma.hla.datamodel.enumeration.JWindowFunction;

public class BL_XMLParser
extends XMLParserBase {
    private boolean m_beamSwitching;
    private boolean m_frequencySwitching;
    private boolean m_unknownSwitching;

    @Override
    public CorrelatorConfiguration getOneCorrelatorConfiguration(SpectralSpecT spectralSpec) throws SBConversionException {
        BLCorrelatorConfigurationT corrConf = spectralSpec.getSpectralSpecTChoice().getBLCorrelatorConfiguration();
        if (corrConf == null) {
            throw new SBConversionException("No BL correlator configuration found");
        }
        CorrelatorConfiguration corrConfIDL = new CorrelatorConfiguration();
        String unitsStr = spectralSpec.getFrequencySetup().getLO1Frequency().getUnit();
        double freqUnits = this.getFrequencyUnits(unitsStr);
        corrConfIDL.LO1FrequencyMHz = spectralSpec.getFrequencySetup().getLO1Frequency().getContent() * freqUnits;
        corrConfIDL.integrationDuration = this.getTimeValue(corrConf.getIntegrationDuration());
        corrConfIDL.channelAverageDuration = this.getTimeValue(corrConf.getChannelAverageDuration());
        corrConfIDL.dumpDuration = this.getTimeValue(corrConf.getDumpDuration());
        SpectralSpecTReceiverTypeType rxType = spectralSpec.getReceiverType();
        if (rxType == SpectralSpecTReceiverTypeType.NOSB) {
            corrConfIDL.receiverType = ReceiverSideband.NOSB;
        } else if (rxType == SpectralSpecTReceiverTypeType.DSB) {
            corrConfIDL.receiverType = ReceiverSideband.DSB;
        } else if (rxType == SpectralSpecTReceiverTypeType.TSB) {
            corrConfIDL.receiverType = ReceiverSideband.TSB;
        } else if (rxType == SpectralSpecTReceiverTypeType.SSB) {
            corrConfIDL.receiverType = ReceiverSideband.SSB;
        } else {
            throw new SBConversionException("Reciever type " + rxType + " is not recognized");
        }
        String str = spectralSpec.getFrequencySetup().getReceiverBand().toString();
        try {
            corrConfIDL.receiverBand = JReceiverBand.newReceiverBand((String)str);
        }
        catch (AcsJBadParameterEx ex) {
            throw new SBConversionException("Receiver band");
        }
        switch (corrConf.getAPCDataSets().getType()) {
            case 0: {
                corrConfIDL.APCDataSets = new AtmPhaseCorrection[1];
                corrConfIDL.APCDataSets[0] = AtmPhaseCorrection.AP_UNCORRECTED;
                break;
            }
            case 1: {
                corrConfIDL.APCDataSets = new AtmPhaseCorrection[1];
                corrConfIDL.APCDataSets[0] = AtmPhaseCorrection.AP_CORRECTED;
                break;
            }
            case 2: {
                corrConfIDL.APCDataSets = new AtmPhaseCorrection[2];
                corrConfIDL.APCDataSets[0] = AtmPhaseCorrection.AP_UNCORRECTED;
                corrConfIDL.APCDataSets[1] = AtmPhaseCorrection.AP_CORRECTED;
            }
        }
        corrConfIDL.ACAPhaseSwConfig = new ACAPhaseSwitchingConfigurations(false, false);
        corrConfIDL.baseBands = this.getBaseBandConfigs((AbstractCorrelatorConfigurationT)corrConf, spectralSpec);
        return corrConfIDL;
    }

    protected BaseBandConfig[] getBaseBandConfigs(AbstractCorrelatorConfigurationT aCorrConf, SpectralSpecT spectralSpec) throws SBConversionException {
        FrequencySetupT frequencySetup = spectralSpec.getFrequencySetup();
        BLCorrelatorConfigurationT corrConf = (BLCorrelatorConfigurationT)aCorrConf;
        int numBBConfs = corrConf.getBLBaseBandConfigCount();
        boolean enable180DWF = corrConf.getEnable180DegreeWalshFunction();
        String loOffsettingMode = corrConf.getLOOffsettingMode().toString();
        boolean enable90DWF = corrConf.getEnable90DegreeWalshFunction();
        BaseBandConfig[] baseBandConfsIDL = new BaseBandConfig[numBBConfs];
        for (int bb = 0; bb < numBBConfs; ++bb) {
            TimeT dwellTime;
            int nps;
            int numPos;
            BeamSwitchingCycleT acaSC;
            BLBaseBandConfigT bbConfig = corrConf.getBLBaseBandConfig(bb);
            BaseBandSpecificationT bbSpec = frequencySetup.getBaseBandSpecification(bb);
            baseBandConfsIDL[bb] = new BaseBandConfig();
            String str = bbSpec.getBaseBandName().toString();
            try {
                baseBandConfsIDL[bb].basebandName = JBasebandName.newBasebandName((String)str);
            }
            catch (AcsJBadParameterEx ex) {
                throw new SBConversionException("Baseband name");
            }
            str = corrConf.getCAM().toString();
            try {
                baseBandConfsIDL[bb].CAM = JAccumMode.newAccumMode((String)str);
            }
            catch (AcsJBadParameterEx ex) {
                throw new SBConversionException("accumulation mode");
            }
            str = bbConfig.getDataProducts().toString();
            try {
                baseBandConfsIDL[bb].dataProducts = JCorrelationMode.newCorrelationMode((String)str);
            }
            catch (AcsJBadParameterEx ex) {
                throw new SBConversionException("correlation mode");
            }
            boolean isLOOffsetOkay = false;
            if (loOffsettingMode.equals("NONE") || loOffsettingMode.equals("TWO_LOS")) {
                str = enable90DWF ? "PHASE_SWITCH_SEPARATION" : "NONE";
                isLOOffsetOkay = true;
            } else if (loOffsettingMode.equals("THREE_LOS") && !enable90DWF) {
                str = "FREQUENCY_OFFSET_REJECTION";
                isLOOffsetOkay = true;
            }
            if (!isLOOffsetOkay) {
                throw new SBConversionException("LO offsetting and Walsh functions setting incompatible (Rx/N/LO/180/90=" + spectralSpec.getReceiverType() + "/" + bbConfig.getBLSpectralWindowCount() + "/" + loOffsettingMode + "/" + enable180DWF + "/" + enable90DWF + ")");
            }
            try {
                baseBandConfsIDL[bb].sideBandSeparationMode = JSidebandProcessingMode.newSidebandProcessingMode((String)str);
            }
            catch (AcsJBadParameterEx ex) {
                throw new SBConversionException("sideband processing");
            }
            baseBandConfsIDL[bb].spectralWindows = this.getSpectralWindows((AbstractBaseBandConfigT)bbConfig);
            baseBandConfsIDL[bb].useUSB = bbSpec.getUseUSB();
            baseBandConfsIDL[bb].use12GHzFilter = bbSpec.getUse12GHzFilter();
            baseBandConfsIDL[bb].LO2FrequencyMHz = bbSpec.getLO2Frequency().getContent() * this.getFrequencyUnits(bbSpec.getLO2Frequency().getUnit());
            str = spectralSpec.getSwitchingType().toString();
            BinSwitching_t binSwitching = new BinSwitching_t();
            try {
                binSwitching.SwitchingType = JSwitchingMode.newSwitchingMode((String)str);
            }
            catch (AcsJBadParameterEx ex) {
                throw new SBConversionException("bin switching");
            }
            if (this.m_beamSwitching) {
                acaSC = spectralSpec.getSpectralSpecTChoice2().getBeamSwitchingCycle();
                binSwitching.numberOfPositions = numPos = acaSC.getNumberOfPositions();
                binSwitching.dwellTime = new long[numPos];
                binSwitching.deadTime = new long[numPos];
                for (nps = 0; nps < numPos; ++nps) {
                    dwellTime = spectralSpec.getSpectralSpecTChoice2().getBeamSwitchingCycle().getBeamSwitchingState(nps).getDwellTime();
                    TimeT deadTime = spectralSpec.getSpectralSpecTChoice2().getBeamSwitchingCycle().getBeamSwitchingState(nps).getTransition();
                    String dwellUnit = dwellTime.getUnit();
                    double dwellTimeFactor = this.getTimeUnits(dwellUnit);
                    binSwitching.dwellTime[nps] = (long)(dwellTime.getContent() * dwellTimeFactor);
                    String deadUnit = deadTime.getUnit();
                    double deadTimeFactor = this.getTimeUnits(deadUnit);
                    binSwitching.deadTime[nps] = (long)(deadTime.getContent() * deadTimeFactor);
                }
            } else if (this.m_frequencySwitching) {
                acaSC = spectralSpec.getSpectralSpecTChoice2().getFrequencySwitchingCycle();
                binSwitching.numberOfPositions = numPos = acaSC.getNumberOfPositions();
                binSwitching.dwellTime = new long[numPos];
                binSwitching.deadTime = new long[numPos];
                for (nps = 0; nps < numPos; ++nps) {
                    dwellTime = spectralSpec.getSpectralSpecTChoice2().getFrequencySwitchingCycle().getFrequencySwitchingState(nps).getDwellTime();
                    String dwellUnit = dwellTime.getUnit();
                    double dwellTimeFactor = this.getTimeUnits(dwellUnit);
                    binSwitching.dwellTime[nps] = (long)(dwellTime.getContent() * dwellTimeFactor);
                    binSwitching.deadTime[nps] = 0L;
                }
            } else {
                acaSC = null;
                binSwitching.numberOfPositions = 1;
                binSwitching.dwellTime = new long[1];
                binSwitching.deadTime = new long[1];
            }
            baseBandConfsIDL[bb].binSwitchingMode = binSwitching;
            baseBandConfsIDL[bb].centerFreqOfResidualDelayMHz = 0.0;
        }
        return baseBandConfsIDL;
    }

    protected SpectralWindow[] getSpectralWindows(AbstractBaseBandConfigT aBaseBandConf) throws SBConversionException {
        BLBaseBandConfigT baseBandConf = (BLBaseBandConfigT)aBaseBandConf;
        int numSpecWindows = baseBandConf.getBLSpectralWindowCount();
        SpectralWindow[] spectWindowsIDL = new SpectralWindow[numSpecWindows];
        for (int ssbs = 0; ssbs < numSpecWindows; ++ssbs) {
            BLSpectralWindowT spectralWindow = baseBandConf.getBLSpectralWindow(ssbs);
            spectWindowsIDL[ssbs] = this.getSpectralWindow(spectralWindow);
            spectWindowsIDL[ssbs].synthProf = SynthProf.NOSYNTH;
        }
        return spectWindowsIDL;
    }

    public SpectralWindow getSpectralWindow(BLSpectralWindowT spectralWindow) throws SBConversionException {
        SpectralWindow spectWindowsIDL = new SpectralWindow();
        spectWindowsIDL.name = spectralWindow.getName();
        String str = spectralWindow.getCenterFrequency().getUnit();
        double units = this.getFrequencyUnits(str);
        spectWindowsIDL.centerFrequencyMHz = spectralWindow.getCenterFrequency().getContent() * units;
        str = spectralWindow.getEffectiveBandwidth().getUnit();
        units = this.getFrequencyUnits(str);
        spectWindowsIDL.effectiveBandwidthMHz = spectralWindow.getEffectiveBandwidth().getContent() * units;
        spectWindowsIDL.effectiveNumberOfChannels = spectralWindow.getEffectiveNumberOfChannels();
        spectWindowsIDL.spectralAveragingFactor = spectralWindow.getSpectralAveragingFactor();
        str = spectralWindow.getSideBand().toString();
        try {
            spectWindowsIDL.sideBand = JNetSideband.newNetSideband((String)str);
        }
        catch (AcsJBadParameterEx ex) {
            throw new SBConversionException("net sideband mode");
        }
        spectWindowsIDL.associatedSpectralWindowNumberInPair = spectralWindow.getAssociatedSpectralWindowNumberInPair();
        spectWindowsIDL.useThisSpectralWindow = spectralWindow.getUseThisSpectralWindow();
        str = spectralWindow.getWindowFunction().toString();
        try {
            spectWindowsIDL.windowFunction = JWindowFunction.newWindowFunction((String)str);
        }
        catch (AcsJBadParameterEx ex) {
            throw new SBConversionException("Window function");
        }
        str = spectralWindow.getCorrelationBits().toString();
        try {
            spectWindowsIDL.correlationBits = JCorrelationBit.newCorrelationBit((String)str);
        }
        catch (AcsJBadParameterEx ex) {
            throw new SBConversionException("Correlation bit");
        }
        spectWindowsIDL.correlationNyquistOversampling = spectralWindow.getCorrelationNyquistOversampling();
        str = spectralWindow.getPolnProducts().toString();
        String patternStr = ",";
        String[] polnProds = str.split(patternStr, -1);
        spectWindowsIDL.polnProductsSeq = new StokesParameter[polnProds.length];
        for (int i = 0; i < polnProds.length; ++i) {
            try {
                spectWindowsIDL.polnProductsSeq[i] = JStokesParameter.newStokesParameter((String)polnProds[i]);
                continue;
            }
            catch (AcsJBadParameterEx ex) {
                throw new SBConversionException("poln products");
            }
        }
        spectWindowsIDL.quantizationCorrection = spectralWindow.getQuantizationCorrection();
        spectWindowsIDL.channelAverageRegions = this.getChannelAvgRegions((AbstractSpectralWindowT)spectralWindow);
        return spectWindowsIDL;
    }

    protected ChannelAverageRegion[] getChannelAvgRegions(AbstractSpectralWindowT aSpecWindow) throws SBConversionException {
        BLSpectralWindowT specWindow = (BLSpectralWindowT)aSpecWindow;
        int numChannAvgRegions = specWindow.getChannelAverageRegionCount();
        ChannelAverageRegion[] channelAvgRegionsIDL = new ChannelAverageRegion[numChannAvgRegions];
        for (int cab = 0; cab < numChannAvgRegions; ++cab) {
            ChannelAverageRegionT car = specWindow.getChannelAverageRegion(cab);
            channelAvgRegionsIDL[cab] = new ChannelAverageRegion();
            channelAvgRegionsIDL[cab].startChannel = car.getStartChannel();
            channelAvgRegionsIDL[cab].numberChannels = car.getNumberChannels();
        }
        return channelAvgRegionsIDL;
    }

    private long getTimeValue(TimeT obj) {
        double units = this.getTimeUnits(obj.getUnit());
        double val = obj.getContent();
        if (val >= 1.0 && units == 1.0E7) {
            return (long)(units / 1000.0 * (1000.0 * val));
        }
        return (long)(units * val);
    }

    private double getTimeUnits(String unitsStr) {
        double timeUnits = 1.0;
        if ((unitsStr = unitsStr.toLowerCase()).equals("s")) {
            timeUnits = 1.0E7;
        } else if (unitsStr.equals("ms")) {
            timeUnits = 10000.0;
        } else if (unitsStr.equals("ns")) {
            timeUnits = 0.01;
        } else if (unitsStr.equals("us")) {
            timeUnits = 10.0;
        } else if (unitsStr.equals("m")) {
            timeUnits = 6.0E8;
        } else if (unitsStr.equals("h")) {
            timeUnits = 3.6E10;
        }
        return timeUnits;
    }

    private double getFrequencyUnits(String unitsStr) {
        double frequencyUnits = 1.0;
        if (unitsStr.equals("MHz")) {
            frequencyUnits = 1.0;
        } else if (unitsStr.equals("GHz")) {
            frequencyUnits = 1000.0;
        } else if (unitsStr.equals("Hz")) {
            frequencyUnits = 1.0E-6;
        }
        return frequencyUnits;
    }
}

