/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uk.ac.starlink.task.AbortException;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;

public class TerminalEnvironment
implements Environment {
    private Map valueMap;
    private Set paramSet;
    public static int NUM_TRIES = 5;

    public TerminalEnvironment(String[] args, Parameter[] params) throws UsageException {
        int i;
        this.paramSet = new HashSet(params.length);
        for (i = 0; i < params.length; ++i) {
            this.paramSet.add(params[i]);
        }
        this.valueMap = new HashMap();
        for (i = 0; i < args.length; ++i) {
            boolean found = false;
            String[] pp = args[i].split("=");
            if (pp.length == 2) {
                String name = pp[0];
                String value = pp[1];
                for (int j = 0; j < params.length; ++j) {
                    if (!params[j].getName().equals(name)) continue;
                    this.valueMap.put(params[j], value);
                    found = true;
                }
                if (!found) {
                    throw new UsageException("Unknown parameter " + name);
                }
            } else {
                for (int j = 0; j < params.length; ++j) {
                    if (params[j].getPosition() != i + 1) continue;
                    this.valueMap.put(params[j], args[i]);
                    found = true;
                }
            }
            if (found) continue;
            throw new UsageException("Unknown word: " + args[i]);
        }
    }

    public void clear(Parameter par) {
        this.valueMap.remove(par);
    }

    public void acquireValue(Parameter par) throws TaskException {
        this.acquireValue(par, NUM_TRIES);
    }

    private void acquireValue(Parameter par, int ntries) throws TaskException {
        if (ntries <= 0) {
            throw new ParameterValueException(par, "No valid value in " + NUM_TRIES + " attempts");
        }
        if (!this.paramSet.contains(par)) {
            throw new IllegalArgumentException("Unknown parameter " + par.getName() + " (programming error)");
        }
        if (!this.valueMap.containsKey(par)) {
            if (par.getDefault() != null) {
                this.valueMap.put(par, par.getDefault());
            } else if (par.getPreferExplicit() || !par.isNullPermitted()) {
                String value;
                String prompt = par.getPrompt();
                System.out.print(par.getName() + (prompt == null ? "" : ": " + prompt) + " > ");
                BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
                try {
                    value = rdr.readLine();
                }
                catch (IOException e) {
                    throw new AbortException("Error getting parameter " + par, e);
                }
                if (value == null || value.equals("!!")) {
                    throw new AbortException();
                }
                if (value.equals("!")) {
                    value = "";
                }
                if (value.length() == 0) {
                    String def = par.getDefault();
                    if (par.getDefault() != null) {
                        value = def;
                    } else {
                        this.acquireValue(par, ntries - 1);
                        return;
                    }
                }
                this.valueMap.put(par, value);
            }
        }
        try {
            par.setValueFromString(this, (String)this.valueMap.get(par));
        }
        catch (ParameterValueException e) {
            System.out.println(e.getMessage());
            this.valueMap.remove(par);
            if (ntries > 1) {
                this.acquireValue(par, ntries - 1);
            }
            throw e;
        }
    }

    public void clearValue(Parameter par) {
        this.valueMap.remove(par);
    }

    public String[] getNames() {
        ArrayList<String> nameList = new ArrayList<String>();
        Iterator it = this.paramSet.iterator();
        while (it.hasNext()) {
            nameList.add(((Parameter)it.next()).getName());
        }
        return nameList.toArray(new String[0]);
    }

    public PrintStream getOutputStream() {
        return System.out;
    }

    public PrintStream getErrorStream() {
        return System.err;
    }
}

