/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.votech.plastic.PlasticHubListener;
import uk.ac.starlink.plastic.PlasticUtils;

public class PlasticRequest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        ArrayList<URI> targetList;
        URI id;
        List msgParams;
        URI msgId;
        String arg;
        String usage = "\nUsage:\n       " + PlasticRequest.class.getName() + "\n           " + " [-sync|-async]" + " [-regName name]" + "\n           " + " [-targetName name ...]" + " [-targetId id ...]" + " [-targetHub]" + "\n           " + " [-clientId id]" + " [--]" + "\n           " + " messsageId" + " [args ...]" + "\n";
        String appName = "request";
        boolean sync = true;
        HashSet targetNameSet = new HashSet();
        ArrayList<URI> targetIdList = new ArrayList<URI>();
        boolean targetHub = false;
        URI spoofId = null;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        Iterator it = argList.iterator();
        while (it.hasNext() && (arg = (String)it.next()).length() != 0 && arg.charAt(0) == '-') {
            String uri;
            if (arg.equals("--")) {
                it.remove();
                break;
            }
            if (arg.startsWith("-sync")) {
                it.remove();
                sync = true;
                continue;
            }
            if (arg.startsWith("-async")) {
                it.remove();
                sync = false;
                continue;
            }
            if (arg.equals("-regName") && it.hasNext()) {
                it.remove();
                appName = (String)it.next();
                it.remove();
                continue;
            }
            if (arg.equals("-targetName") && it.hasNext()) {
                it.remove();
                targetNameSet.add(it.next());
                it.remove();
                continue;
            }
            if (arg.equals("-targetHub")) {
                it.remove();
                targetHub = true;
                continue;
            }
            if (arg.equals("-targetId") && it.hasNext()) {
                it.remove();
                uri = (String)it.next();
                it.remove();
                try {
                    targetIdList.add(new URI(uri));
                    continue;
                }
                catch (URISyntaxException e) {
                    throw (IllegalArgumentException)new IllegalArgumentException("Badly formed URI: " + uri).initCause(e);
                }
            }
            if (arg.equals("-clientId") && it.hasNext()) {
                it.remove();
                uri = (String)it.next();
                it.remove();
                try {
                    spoofId = new URI(uri);
                    continue;
                }
                catch (URISyntaxException e) {
                    throw (IllegalArgumentException)new IllegalArgumentException("Badly formed URI: " + uri).initCause(e);
                }
            }
            if (arg.startsWith("-h")) {
                it.remove();
                System.out.println(usage);
                return;
            }
            if (!arg.startsWith("-")) continue;
            it.remove();
            System.err.println(usage);
            System.exit(1);
        }
        if (argList.isEmpty()) {
            System.err.println(usage);
            System.exit(1);
        }
        try {
            msgId = new URI((String)argList.get(0));
            argList.remove(0);
            msgParams = PlasticRequest.decodeArgs(argList);
        }
        catch (URISyntaxException e) {
            System.err.println("Bad message ID: " + argList.get(0));
            System.exit(1);
            throw new AssertionError();
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println(usage);
            System.exit(1);
            throw new AssertionError();
        }
        PlasticHubListener hub = PlasticUtils.getLocalHub();
        URI uRI = id = spoofId == null ? hub.registerNoCallBack(appName) : spoofId;
        if (targetNameSet.isEmpty() && targetIdList.isEmpty() && !targetHub) {
            targetList = null;
        } else {
            targetList = new ArrayList<URI>();
            if (targetHub) {
                URI hubId = hub.getHubId();
                if (hubId != null) {
                    targetList.add(hubId);
                } else {
                    throw new IOException("No hub ID available");
                }
            }
            targetList.addAll(targetIdList);
            if (!targetNameSet.isEmpty()) {
                Iterator it2 = hub.getRegisteredIds().iterator();
                while (it2.hasNext()) {
                    URI appId = (URI)it2.next();
                    String name = hub.getName(appId);
                    if (!targetNameSet.contains(hub.getName(appId))) continue;
                    targetList.add(appId);
                }
            }
        }
        try {
            if (sync) {
                Map map = targetList == null ? hub.request(id, msgId, msgParams) : hub.requestToSubset(id, msgId, msgParams, targetList);
                PlasticRequest.showMap(map, System.out);
            } else if (targetList == null) {
                hub.requestAsynch(id, msgId, msgParams);
            } else {
                hub.requestToSubsetAsynch(id, msgId, msgParams, targetList);
            }
        }
        finally {
            if (spoofId == null) {
                hub.unregister(id);
            }
        }
    }

    private static List decodeArgs(List inList) {
        ArrayList<Object> outList = new ArrayList<Object>();
        Iterator it = inList.iterator();
        while (it.hasNext()) {
            outList.add(PlasticRequest.decodeArg((String)it.next()));
        }
        return outList;
    }

    private static Object decodeArg(String inArg) {
        int leng = inArg.length();
        if (inArg.charAt(0) == '\"' && inArg.charAt(leng - 1) == '\"' || inArg.charAt(0) == '\'' && inArg.charAt(leng - 1) == '\'') {
            return inArg.substring(1, leng - 1);
        }
        if (inArg.charAt(0) == '(' && inArg.charAt(leng - 1) == ')') {
            String[] items = inArg.substring(1, leng - 1).split(" *, *");
            return PlasticRequest.decodeArgs(Arrays.asList(items));
        }
        if (inArg.charAt(0) == '{' && inArg.charAt(leng - 1) == '}') {
            if (leng == 2) {
                return new HashMap();
            }
            String[] items = inArg.substring(1, leng - 1).split(" *, *");
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            boolean ok = true;
            for (int i = 0; ok && i < items.length; ++i) {
                int sepPos = items[i].indexOf("=>");
                if (sepPos > 0) {
                    Object key = PlasticRequest.decodeArg(items[i].substring(0, sepPos));
                    Object value = PlasticRequest.decodeArg(items[i].substring(sepPos + 2));
                    map.put(key, value);
                    continue;
                }
                ok = false;
            }
            return ok ? map : inArg;
        }
        if ("true".equals(inArg)) {
            return Boolean.TRUE;
        }
        if ("false".equals(inArg)) {
            return Boolean.FALSE;
        }
        try {
            return Integer.valueOf(inArg);
        }
        catch (NumberFormatException e1) {
            try {
                return Double.valueOf(inArg);
            }
            catch (NumberFormatException e2) {
                return inArg;
            }
        }
    }

    private static void showMap(Map map, PrintStream out) {
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys);
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            out.println(key + ": ");
            out.println("    " + map.get(key));
        }
    }
}

