/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject.data;

import alma.entity.xmlbinding.obsattachment.ObsAttachmentRefT;
import alma.entity.xmlbinding.obsproject.AbstractTargetParametersT;
import alma.entity.xmlbinding.obsproject.ExpectedPropertiesT;
import alma.entity.xmlbinding.obsproject.types.AbstractTargetParametersTSolarSystemObjectType;
import alma.entity.xmlbinding.valuetypes.AngleT;
import alma.entity.xmlbinding.valuetypes.AngularVelocityT;
import alma.entity.xmlbinding.valuetypes.SkyCoordinatesT;
import alma.entity.xmlbinding.valuetypes.VelocityT;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.EntityProxy;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ReferenceableProxy;
import alma.hla.runtime.obsprep.bo.ReferenceablesMap;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsattachment.ObsAttachment;
import alma.obsprep.bo.obsproject.AbstractTargetParameters;
import alma.obsprep.bo.obsproject.ExpectedProperties;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTargetParametersData
extends BusinessObject
implements IBusinessObject {
    public static final String SOLARSYSTEMOBJECT_MERCURY = AbstractTargetParametersTSolarSystemObjectType.MERCURY.toString();
    public static final String SOLARSYSTEMOBJECT_VENUS = AbstractTargetParametersTSolarSystemObjectType.VENUS.toString();
    public static final String SOLARSYSTEMOBJECT_MOON = AbstractTargetParametersTSolarSystemObjectType.MOON.toString();
    public static final String SOLARSYSTEMOBJECT_MARS = AbstractTargetParametersTSolarSystemObjectType.MARS.toString();
    public static final String SOLARSYSTEMOBJECT_JUPITER = AbstractTargetParametersTSolarSystemObjectType.JUPITER.toString();
    public static final String SOLARSYSTEMOBJECT_SATURN = AbstractTargetParametersTSolarSystemObjectType.SATURN.toString();
    public static final String SOLARSYSTEMOBJECT_URANUS = AbstractTargetParametersTSolarSystemObjectType.URANUS.toString();
    public static final String SOLARSYSTEMOBJECT_NEPTUNE = AbstractTargetParametersTSolarSystemObjectType.NEPTUNE.toString();
    public static final String SOLARSYSTEMOBJECT_PLUTO = AbstractTargetParametersTSolarSystemObjectType.PLUTO.toString();
    public static final String SOLARSYSTEMOBJECT_SUN = AbstractTargetParametersTSolarSystemObjectType.SUN.toString();
    public static final String SOLARSYSTEMOBJECT_GANYMEDE = AbstractTargetParametersTSolarSystemObjectType.GANYMEDE.toString();
    public static final String SOLARSYSTEMOBJECT_EUROPA = AbstractTargetParametersTSolarSystemObjectType.EUROPA.toString();
    public static final String SOLARSYSTEMOBJECT_CALLISTO = AbstractTargetParametersTSolarSystemObjectType.CALLISTO.toString();
    public static final String SOLARSYSTEMOBJECT_IO = AbstractTargetParametersTSolarSystemObjectType.IO.toString();
    public static final String SOLARSYSTEMOBJECT_TITAN = AbstractTargetParametersTSolarSystemObjectType.TITAN.toString();
    public static final String SOLARSYSTEMOBJECT_CERES = AbstractTargetParametersTSolarSystemObjectType.CERES.toString();
    public static final String SOLARSYSTEMOBJECT_PALLAS = AbstractTargetParametersTSolarSystemObjectType.PALLAS.toString();
    public static final String SOLARSYSTEMOBJECT_JUNO = AbstractTargetParametersTSolarSystemObjectType.JUNO.toString();
    public static final String SOLARSYSTEMOBJECT_VESTA = AbstractTargetParametersTSolarSystemObjectType.VESTA.toString();
    public static final String SOLARSYSTEMOBJECT_EPHEMERIS = AbstractTargetParametersTSolarSystemObjectType.EPHEMERIS.toString();
    public static final String SOLARSYSTEMOBJECT_UNSPECIFIED = AbstractTargetParametersTSolarSystemObjectType.UNSPECIFIED.toString();
    protected static String[] knownSolarSystemObjectList = new String[]{SOLARSYSTEMOBJECT_MERCURY, SOLARSYSTEMOBJECT_VENUS, SOLARSYSTEMOBJECT_MOON, SOLARSYSTEMOBJECT_MARS, SOLARSYSTEMOBJECT_JUPITER, SOLARSYSTEMOBJECT_SATURN, SOLARSYSTEMOBJECT_URANUS, SOLARSYSTEMOBJECT_NEPTUNE, SOLARSYSTEMOBJECT_PLUTO, SOLARSYSTEMOBJECT_SUN, SOLARSYSTEMOBJECT_GANYMEDE, SOLARSYSTEMOBJECT_EUROPA, SOLARSYSTEMOBJECT_CALLISTO, SOLARSYSTEMOBJECT_IO, SOLARSYSTEMOBJECT_TITAN, SOLARSYSTEMOBJECT_CERES, SOLARSYSTEMOBJECT_PALLAS, SOLARSYSTEMOBJECT_JUNO, SOLARSYSTEMOBJECT_VESTA, SOLARSYSTEMOBJECT_EPHEMERIS, SOLARSYSTEMOBJECT_UNSPECIFIED};
    private SkyCoordinates boSourceCoordinates = null;
    private AngularVelocity boPmRA = null;
    private AngularVelocity boPmDec = null;
    private Angle boParallax = null;
    private Velocity boSourceVelocity = null;
    private ArrayList<SkyCoordinates> boSdReferencePosition = new ArrayList();
    private EntityProxy<ObsAttachment> _ObsAttachmentProxy = null;
    private ExpectedProperties boExpectedProperties = null;

    protected AbstractTargetParametersData(AbstractTargetParametersT castorObject) {
        super(castorObject);
    }

    protected static final void patchAbstractTargetParametersT(AbstractTargetParametersT castorObject) {
        castorObject.setNonSiderealMotion(false);
        castorObject.setIndex(0);
    }

    public void setSourceName(String newValue) {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        castorObject.setSourceName(newValue);
        String propName = "alma.obsprep.bo.obsproject.AbstractTargetParameters.sourceName";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.AbstractTargetParameters.sourceName", propValue);
    }

    public String gettrueSourceName() {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        String ret = castorObject.getSourceName();
        return ret;
    }

    public String getSourceName() {
        String ret = this.gettrueSourceName();
        if (ret == null) {
            ret = "";
            this.setSourceName(ret);
        }
        return ret;
    }

    private void wrapSourceCoordinates() {
        SkyCoordinatesT subSo = this.getCastorObject().getSourceCoordinates();
        if (subSo != null) {
            SkyCoordinates subBo;
            this.boSourceCoordinates = subBo = new SkyCoordinates(subSo);
        }
    }

    public void setSourceCoordinates(SkyCoordinates newValue) {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        SkyCoordinatesT subCastorObject = newValue.getCastorObject();
        castorObject.setSourceCoordinates(subCastorObject);
        this.boSourceCoordinates = newValue;
        String propName = "alma.obsprep.bo.obsproject.AbstractTargetParameters.sourceCoordinates";
        SkyCoordinates propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.AbstractTargetParameters.sourceCoordinates", propValue);
    }

    public SkyCoordinates gettrueSourceCoordinates() {
        SkyCoordinates ret = this.boSourceCoordinates;
        return ret;
    }

    public SkyCoordinates getSourceCoordinates() {
        SkyCoordinates ret = this.gettrueSourceCoordinates();
        if (ret == null) {
            ret = SkyCoordinates.createSkyCoordinates();
            this.setSourceCoordinates(ret);
        }
        return ret;
    }

    private void wrapPmRA() {
        AngularVelocityT subSo = this.getCastorObject().getPmRA();
        if (subSo != null) {
            AngularVelocity subBo;
            this.boPmRA = subBo = new AngularVelocity(subSo);
        }
    }

    public void setPmRA(AngularVelocity newValue) {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        AngularVelocityT subCastorObject = newValue.getCastorObject();
        castorObject.setPmRA(subCastorObject);
        this.boPmRA = newValue;
        String propName = "alma.obsprep.bo.obsproject.AbstractTargetParameters.pmRA";
        AngularVelocity propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.AbstractTargetParameters.pmRA", propValue);
    }

    public AngularVelocity gettruePmRA() {
        AngularVelocity ret = this.boPmRA;
        return ret;
    }

    public AngularVelocity getPmRA() {
        AngularVelocity ret = this.gettruePmRA();
        if (ret == null) {
            ret = AngularVelocity.createAngularVelocity();
            this.setPmRA(ret);
        }
        return ret;
    }

    private void wrapPmDec() {
        AngularVelocityT subSo = this.getCastorObject().getPmDec();
        if (subSo != null) {
            AngularVelocity subBo;
            this.boPmDec = subBo = new AngularVelocity(subSo);
        }
    }

    public void setPmDec(AngularVelocity newValue) {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        AngularVelocityT subCastorObject = newValue.getCastorObject();
        castorObject.setPmDec(subCastorObject);
        this.boPmDec = newValue;
        String propName = "alma.obsprep.bo.obsproject.AbstractTargetParameters.pmDec";
        AngularVelocity propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.AbstractTargetParameters.pmDec", propValue);
    }

    public AngularVelocity gettruePmDec() {
        AngularVelocity ret = this.boPmDec;
        return ret;
    }

    public AngularVelocity getPmDec() {
        AngularVelocity ret = this.gettruePmDec();
        if (ret == null) {
            ret = AngularVelocity.createAngularVelocity();
            this.setPmDec(ret);
        }
        return ret;
    }

    private void wrapParallax() {
        AngleT subSo = this.getCastorObject().getParallax();
        if (subSo != null) {
            Angle subBo;
            this.boParallax = subBo = new Angle(subSo);
        }
    }

    public void setParallax(Angle newValue) {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        AngleT subCastorObject = newValue.getCastorObject();
        castorObject.setParallax(subCastorObject);
        this.boParallax = newValue;
        String propName = "alma.obsprep.bo.obsproject.AbstractTargetParameters.parallax";
        Angle propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.AbstractTargetParameters.parallax", propValue);
    }

    public Angle gettrueParallax() {
        Angle ret = this.boParallax;
        return ret;
    }

    public Angle getParallax() {
        Angle ret = this.gettrueParallax();
        if (ret == null) {
            ret = Angle.createAngle();
            this.setParallax(ret);
        }
        return ret;
    }

    public void setNonSiderealMotion(boolean newValue) {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        castorObject.setNonSiderealMotion(newValue);
        String propName = "alma.obsprep.bo.obsproject.AbstractTargetParameters.nonSiderealMotion";
        Boolean propValue = new Boolean(newValue);
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.AbstractTargetParameters.nonSiderealMotion", propValue);
    }

    public boolean gettrueNonSiderealMotion() {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        boolean ret = castorObject.getNonSiderealMotion();
        return ret;
    }

    public boolean getNonSiderealMotion() {
        boolean ret = this.gettrueNonSiderealMotion();
        return ret;
    }

    public boolean hasNonSiderealMotion() {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        boolean ret = castorObject.hasNonSiderealMotion();
        return ret;
    }

    public void setSolarSystemObject(String newValue) throws IllegalArgumentException {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        AbstractTargetParametersTSolarSystemObjectType castorEnumElement = AbstractTargetParametersTSolarSystemObjectType.valueOf(newValue);
        castorObject.setSolarSystemObject(castorEnumElement);
        String propName = "alma.obsprep.bo.obsproject.AbstractTargetParameters.solarSystemObject";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.AbstractTargetParameters.solarSystemObject", propValue);
    }

    public String getSolarSystemObject() {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        AbstractTargetParametersTSolarSystemObjectType value = castorObject.getSolarSystemObject();
        String ret = value == null ? null : value.toString();
        return ret;
    }

    public static String[] getKnownSolarSystemObjectList() {
        return knownSolarSystemObjectList;
    }

    public void setSourceEphemeris(String newValue) {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        castorObject.setSourceEphemeris(newValue);
        String propName = "alma.obsprep.bo.obsproject.AbstractTargetParameters.sourceEphemeris";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.AbstractTargetParameters.sourceEphemeris", propValue);
    }

    public String gettrueSourceEphemeris() {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        String ret = castorObject.getSourceEphemeris();
        return ret;
    }

    public String getSourceEphemeris() {
        String ret = this.gettrueSourceEphemeris();
        if (ret == null) {
            ret = "";
            this.setSourceEphemeris(ret);
        }
        return ret;
    }

    private void wrapSourceVelocity() {
        VelocityT subSo = this.getCastorObject().getSourceVelocity();
        if (subSo != null) {
            Velocity subBo;
            this.boSourceVelocity = subBo = new Velocity(subSo);
        }
    }

    public void setSourceVelocity(Velocity newValue) {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        VelocityT subCastorObject = newValue.getCastorObject();
        castorObject.setSourceVelocity(subCastorObject);
        this.boSourceVelocity = newValue;
        String propName = "alma.obsprep.bo.obsproject.AbstractTargetParameters.sourceVelocity";
        Velocity propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.AbstractTargetParameters.sourceVelocity", propValue);
    }

    public Velocity gettrueSourceVelocity() {
        Velocity ret = this.boSourceVelocity;
        return ret;
    }

    public Velocity getSourceVelocity() {
        Velocity ret = this.gettrueSourceVelocity();
        if (ret == null) {
            ret = Velocity.createVelocity();
            this.setSourceVelocity(ret);
        }
        return ret;
    }

    public void setEphemerisFileName(String newValue) {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        castorObject.setEphemerisFileName(newValue);
        String propName = "alma.obsprep.bo.obsproject.AbstractTargetParameters.ephemerisFileName";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.AbstractTargetParameters.ephemerisFileName", propValue);
    }

    public String gettrueEphemerisFileName() {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        String ret = castorObject.getEphemerisFileName();
        return ret;
    }

    public String getEphemerisFileName() {
        String ret = this.gettrueEphemerisFileName();
        if (ret == null) {
            ret = "";
            this.setEphemerisFileName(ret);
        }
        return ret;
    }

    public void setIndex(int newValue) {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        castorObject.setIndex(newValue);
        String propName = "alma.obsprep.bo.obsproject.AbstractTargetParameters.index";
        Integer propValue = new Integer(newValue);
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.AbstractTargetParameters.index", propValue);
    }

    public int gettrueIndex() {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        int ret = castorObject.getIndex();
        return ret;
    }

    public int getIndex() {
        int ret = this.gettrueIndex();
        return ret;
    }

    public boolean hasIndex() {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        boolean ret = castorObject.hasIndex();
        return ret;
    }

    public void setSdReferencePosition(SkyCoordinates[] bos) {
        this.clearSdReferencePosition();
        for (int i = 0; i < bos.length; ++i) {
            this.addSdReferencePosition(i, bos[i]);
        }
    }

    public SkyCoordinates[] gettrueSdReferencePosition() {
        return this.getSdReferencePosition();
    }

    public SkyCoordinates[] getSdReferencePosition() {
        int size = this.getSdReferencePositionCount();
        SkyCoordinates[] ret = new SkyCoordinates[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getSdReferencePosition(i);
        }
        return ret;
    }

    public void addSdReferencePosition(SkyCoordinates bo) {
        this.addSdReferencePosition(this.getSdReferencePositionCount(), bo);
    }

    public void clearSdReferencePosition() {
        int size = this.getSdReferencePositionCount();
        for (int i = 0; i < size; ++i) {
            SkyCoordinates first = this.getSdReferencePosition(0);
            this.removeSdReferencePosition(first);
        }
    }

    private void wrapSdReferencePosition() {
        SkyCoordinatesT[] all;
        for (SkyCoordinatesT subSo : all = this.getCastorObject().getSdReferencePosition()) {
            SkyCoordinates subBo = new SkyCoordinates(subSo);
            this.boSdReferencePosition.add(subBo);
        }
    }

    public void addSdReferencePosition(int index, SkyCoordinates arg) throws IndexOutOfBoundsException {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        SkyCoordinatesT subCastorObject = arg.getCastorObject();
        castorObject.addSdReferencePosition(index, subCastorObject);
        this.boSdReferencePosition.add(index, arg);
        SkyCoordinates newValue = arg;
        String propName = "alma.obsprep.bo.obsproject.AbstractTargetParameters.sdReferencePosition";
        SkyCoordinates propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.AbstractTargetParameters.sdReferencePosition", propValue);
    }

    public SkyCoordinates getSdReferencePosition(int index) throws IndexOutOfBoundsException {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        return this.boSdReferencePosition.get(index);
    }

    public void removeSdReferencePosition(SkyCoordinates arg) {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        SkyCoordinatesT subCastorObject = arg.getCastorObject();
        boolean ok = castorObject.removeSdReferencePosition(subCastorObject);
        this.boSdReferencePosition.remove(arg);
        ok = true;
        if (ok) {
            SkyCoordinates newValue = arg;
            String propName = "alma.obsprep.bo.obsproject.AbstractTargetParameters.sdReferencePosition";
            SkyCoordinates propValue = newValue;
            this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.AbstractTargetParameters.sdReferencePosition", propValue);
        }
    }

    public int getSdReferencePositionCount() {
        AbstractTargetParametersT castorObject = this.getCastorObject();
        return castorObject.getSdReferencePositionCount();
    }

    private void wrapExpectedProperties() {
        ExpectedPropertiesT subSo = this.getCastorObject().getExpectedProperties();
        if (subSo != null) {
            ExpectedProperties subBo;
            this.boExpectedProperties = subBo = new ExpectedProperties(subSo);
        }
    }

    public ExpectedProperties gettrueExpectedProperties() {
        ExpectedProperties ret = this.boExpectedProperties;
        return ret;
    }

    public ExpectedProperties getExpectedProperties() {
        ExpectedProperties ret = this.gettrueExpectedProperties();
        if (ret == null) {
            ret = ExpectedProperties.createExpectedProperties();
            this.setExpectedProperties(ret);
        }
        return ret;
    }

    public void setExpectedProperties(ExpectedProperties bo) {
        Referring.By by;
        ExpectedProperties removed = this.gettrueExpectedProperties();
        AbstractTargetParametersT myCastor = this.getCastorObject();
        ExpectedPropertiesT subCastor = null;
        if (bo != null) {
            subCastor = bo.getCastorObject();
        }
        myCastor.setExpectedProperties(subCastor);
        this.boExpectedProperties = bo;
        if (removed != null) {
            by = Referring.By.UmlComposition;
            removed.removedFrom((IBusinessObject)this, by);
        }
        if (bo != null) {
            by = Referring.By.UmlComposition;
            bo.addedTo((IBusinessObject)this, by, -1);
        }
    }

    public ObsAttachment gettrueImage() throws UnknownEntityException {
        return this.getImage();
    }

    public ObsAttachment getImage() throws UnknownEntityException {
        if (this._ObsAttachmentProxy == null) {
            return null;
        }
        return this._ObsAttachmentProxy.getEntity();
    }

    public void setImage(ObsAttachment bo) {
        Referring.By by;
        AbstractTargetParametersT castorObject = this.getCastorObject();
        ObsAttachmentRefT ref = bo == null ? null : bo.getReference();
        ObsAttachment removed = null;
        try {
            removed = this.gettrueImage();
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        if (bo == null) {
            this._ObsAttachmentProxy = null;
        } else {
            if (this._ObsAttachmentProxy == null) {
                this._ObsAttachmentProxy = new EntityProxy(ref);
            }
            this._ObsAttachmentProxy.setReference(bo);
        }
        castorObject.setImageRef(ref);
        if (removed != null) {
            by = Referring.By.UmlUnidir;
            removed.removedFrom((IBusinessObject)this, by);
        }
        if (bo != null) {
            by = Referring.By.UmlUnidir;
            bo.addedTo((IBusinessObject)this, by, -1);
        }
    }

    public void wrapImage(ReferenceablesMap referencedObjects, List<ReferenceableProxy<? extends IBusinessObject>> referrers) {
        ObsAttachmentRefT ref = this.getCastorObject().getImageRef();
        if (ref != null) {
            this._ObsAttachmentProxy = new EntityProxy(ref);
            BusinessObject bo = referencedObjects.get(ref.getEntityId(), null);
            if (bo != null && bo instanceof ObsAttachment) {
                this._ObsAttachmentProxy.setReference((ObsAttachment)bo);
            } else {
                referrers.add(this._ObsAttachmentProxy);
            }
        }
    }

    @Override
    public AbstractTargetParametersT getCastorObject() {
        return (AbstractTargetParametersT)this.storageObject;
    }

    public AbstractTargetParameters deepCopy() throws CopyException {
        return (AbstractTargetParameters)super.deepCopy();
    }

    @Override
    protected void initAttribsAndPartsFrom(IBusinessObject original, Copier copier) throws CopyException {
        super.initAttribsAndPartsFrom(original, copier);
        AbstractTargetParametersData orig = (AbstractTargetParametersData)original;
        if (orig.gettrueSourceName() != null) {
            this.setSourceName(orig.gettrueSourceName());
        }
        if (orig.gettrueSourceCoordinates() != null) {
            this.setSourceCoordinates((SkyCoordinates)copier.cpAttr((BusinessObject)orig.gettrueSourceCoordinates()));
        }
        if (orig.gettruePmRA() != null) {
            this.setPmRA((AngularVelocity)copier.cpAttr((BusinessObject)orig.gettruePmRA()));
        }
        if (orig.gettruePmDec() != null) {
            this.setPmDec((AngularVelocity)copier.cpAttr((BusinessObject)orig.gettruePmDec()));
        }
        if (orig.gettrueParallax() != null) {
            this.setParallax((Angle)copier.cpAttr((BusinessObject)orig.gettrueParallax()));
        }
        if (orig.hasNonSiderealMotion()) {
            this.setNonSiderealMotion(orig.getNonSiderealMotion());
        }
        if (orig.getSolarSystemObject() != null) {
            this.setSolarSystemObject(orig.getSolarSystemObject());
        }
        if (orig.gettrueSourceEphemeris() != null) {
            this.setSourceEphemeris(orig.gettrueSourceEphemeris());
        }
        if (orig.gettrueSourceVelocity() != null) {
            this.setSourceVelocity((Velocity)copier.cpAttr((BusinessObject)orig.gettrueSourceVelocity()));
        }
        if (orig.gettrueEphemerisFileName() != null) {
            this.setEphemerisFileName(orig.gettrueEphemerisFileName());
        }
        if (orig.hasIndex()) {
            this.setIndex(orig.getIndex());
        }
        SkyCoordinates[] arySdReferencePosition = orig.getSdReferencePosition();
        SkyCoordinates[] newarySdReferencePosition = new SkyCoordinates[arySdReferencePosition.length];
        for (int i = 0; i < arySdReferencePosition.length; ++i) {
            newarySdReferencePosition[i] = (SkyCoordinates)copier.cpAttr((BusinessObject)arySdReferencePosition[i]);
        }
        this.setSdReferencePosition(newarySdReferencePosition);
        try {
            if (orig.gettrueExpectedProperties() != null) {
                this.setExpectedProperties((ExpectedProperties)copier.cpPart((BusinessObject)orig.gettrueExpectedProperties()));
            }
        }
        catch (Exception exc) {
            throw new CopyException("Failed to copy ExpectedProperties", (Throwable)exc);
        }
    }

    @Override
    protected void initEntityReferencesFrom(IBusinessObject original, Copier copier) throws CopyException {
        super.initEntityReferencesFrom(original, copier);
        AbstractTargetParametersData orig = (AbstractTargetParametersData)original;
        try {
            if (orig.getCastorObject().getImageRef() != null) {
                try {
                    this.setImage((ObsAttachment)copier.cpUnidir((BusinessObject)orig.gettrueImage()));
                }
                catch (UnknownEntityException exc) {
                    this.getCastorObject().setImageRef((ObsAttachmentRefT)copier.cpUnidir(orig.getCastorObject().getImageRef(), new ObsAttachmentRefT()));
                }
            }
        }
        catch (Exception exc) {
            throw new CopyException("Failed to copy Image", (Throwable)exc);
        }
    }

    @Override
    public void wrapObjects(ReferenceablesMap referencedObjects, List<ReferenceableProxy<? extends IBusinessObject>> referrers) {
        super.wrapObjects(referencedObjects, referrers);
        this.wrapSourceCoordinates();
        this.wrapPmRA();
        this.wrapPmDec();
        this.wrapParallax();
        this.wrapSourceVelocity();
        this.wrapSdReferencePosition();
        this.wrapImage(referencedObjects, referrers);
        this.wrapExpectedProperties();
    }

    @Override
    public List<IBusinessObject> referencedBOs(Referring.By ... bys) {
        List<IBusinessObject> r = super.referencedBOs(bys);
        block7: for (Referring.By by : bys) {
            switch (by) {
                case UmlComposition: {
                    this.addToCollection(r, this.gettrueExpectedProperties());
                    continue block7;
                }
                case UmlUnidir: {
                    try {
                        this.addToCollection(r, this.gettrueImage());
                    }
                    catch (UnknownEntityException exc) {
                        Log.logger(this).fine("couldn't dereference Image in type <<DependentClass>> AbstractTargetParameters: " + exc);
                    }
                    continue block7;
                }
                case UmlAttribution: {
                    this.addToCollection(r, this.gettrueSourceCoordinates());
                    this.addToCollection(r, this.gettruePmRA());
                    this.addToCollection(r, this.gettruePmDec());
                    this.addToCollection(r, this.gettrueParallax());
                    this.addToCollection(r, this.gettrueSourceVelocity());
                    this.addToCollection(r, this.getSdReferencePosition());
                }
            }
        }
        return r;
    }
}

