/*
 * Decompiled with CFR 0.152.
 */
package alma.hla.runtime.obsprep.bo;

import alma.entities.commonentity.EntityRefT;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.Entity;
import alma.hla.runtime.obsprep.bo.EntityIDFactory;
import alma.hla.runtime.obsprep.bo.EntityPart;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.hla.runtime.obsprep.util.CannotAssignIdException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;

public class Copier {
    protected BusinessObject theRootObjectToCopy;
    private Map<BusinessObject, BusinessObject> copied = new IdentityHashMap<BusinessObject, BusinessObject>();
    protected HashMap<String, String> map = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BusinessObject copy(BusinessObject obj) throws CopyException {
        this.theRootObjectToCopy = obj;
        this.map.clear();
        BusinessObject.enablePropertyChangeEvents(false);
        try {
            BusinessObject ret = this.goCopy(obj);
            LinkedList<IBusinessObject> elems = new LinkedList<IBusinessObject>();
            elems.add(obj);
            while (!elems.isEmpty()) {
                IBusinessObject current = (IBusinessObject)elems.remove(0);
                elems.addAll(current.referencedBOs(Referring.By.UmlComposition));
                BusinessObject copy = this.copied.get(current);
                copy.initEntityReferencesFrom(current, this);
            }
            BusinessObject businessObject = ret;
            return businessObject;
        }
        finally {
            BusinessObject.enablePropertyChangeEvents(true);
            this.copied.clear();
            this.theRootObjectToCopy = null;
        }
    }

    protected BusinessObject goCopy(BusinessObject obj) {
        BusinessObject ret = obj.invokeCreateUnitialized();
        if (this.copied.get(obj) != null) {
            throw new IllegalArgumentException("Object is already to be found in the map");
        }
        this.copied.put(obj, ret);
        ret.initAttribsAndPartsFrom(obj, this);
        return ret;
    }

    public Map<String, String> reap() {
        Map ret = (Map)this.map.clone();
        this.map.clear();
        return ret;
    }

    public void mkId(EntityPart orig, EntityPart copy) throws CopyException {
        try {
            String orig_epid = orig.getEntityPartId();
            String copy_epid = EntityIDFactory.getFactory().assignEntityPartId(copy);
            this.map.put(orig_epid, copy_epid);
        }
        catch (CannotAssignIdException exc) {
            throw new CopyException("Couldn't create a new EntityId for a clone of " + orig, (Throwable)exc);
        }
    }

    public void mkId(Entity orig, Entity copy) throws CopyException {
        try {
            String orig_eid = orig.getEntityID();
            String copy_eid = EntityIDFactory.getFactory().assignUniqueEntityId(copy);
            this.map.put(orig_eid, copy_eid);
        }
        catch (CannotAssignIdException exc) {
            throw new CopyException("Couldn't create a new EntityPartId for a clone of " + orig, (Throwable)exc);
        }
    }

    public BusinessObject cpAttr(BusinessObject obj) throws CopyException {
        BusinessObject ret = this.copied.get(obj);
        if (ret != null) {
            return ret;
        }
        return this.goCopy(obj);
    }

    public BusinessObject cpPart(BusinessObject obj) throws CopyException {
        BusinessObject ret = this.copied.get(obj);
        if (ret != null) {
            return ret;
        }
        return this.goCopy(obj);
    }

    public BusinessObject cpUnidir(BusinessObject obj) {
        BusinessObject ret = this.copied.get(obj);
        if (ret != null) {
            return ret;
        }
        return obj;
    }

    public EntityRefT cpUnidir(EntityRefT ref, EntityRefT newRef) {
        newRef.setEntityId(ref.getEntityId());
        newRef.setPartId(ref.getPartId());
        newRef.setDocumentVersion(ref.getDocumentVersion());
        return newRef;
    }
}

