/*
 * Decompiled with CFR 0.152.
 */
package alma.hla.runtime.obsprep.bo;

import alma.entity.xmlbinding.valuetypes.DoubleWithUnitT;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.UnitException;
import alma.hla.runtime.obsprep.util.UnitMap;
import java.util.Vector;

public abstract class AbstractDoubleWithUnit<T extends AbstractDoubleWithUnit>
extends BusinessObject
implements ValueUnitPair<T> {
    public static final double COMPARISON_TOLERANCE = 1.0E-5;
    protected static Vector units = null;

    @Override
    public String defaultUnit() {
        return null;
    }

    @Override
    public UnitMap unitMap() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    public void setName(String name) {
    }

    public Object getDelegate() {
        return null;
    }

    @Override
    public abstract DoubleWithUnitT getCastorObject();

    protected AbstractDoubleWithUnit(DoubleWithUnitT castorObject) {
        super(castorObject);
        this.setUnitToDefault();
    }

    @Override
    public void setUnitToDefault() {
        if (this.getUnit() == null) {
            this.setUnit(this.defaultUnit());
        }
    }

    @Override
    public double getContentInDefaultUnits() {
        return this.getContentInUnits(this.defaultUnit());
    }

    @Override
    public double getContentInUnits(String newUnit) {
        double factor;
        double result = this.getContent();
        String unit = this.getUnit();
        try {
            UnitMap arena = this.unitMap();
            factor = arena.getConversionFactor(unit, newUnit);
        }
        catch (UnitException ue) {
            throw new RuntimeException(this.getClass() + ": no conversion factor from current unit '" + unit + "' to '" + newUnit + "'");
        }
        return result *= factor;
    }

    @Override
    public void convertToDefaultUnit() {
        String newUnit = this.defaultUnit();
        this.convertToUnit(newUnit);
    }

    @Override
    public void convertToUnit(String newUnit) {
        double newContent = this.getContentInUnits(newUnit);
        this.setContentAndUnit(newContent, newUnit);
    }

    @Override
    public T inDefaultUnits() {
        AbstractDoubleWithUnit vup = (AbstractDoubleWithUnit)new Copier().copy(this);
        vup.convertToDefaultUnit();
        return (T)vup;
    }

    public String getFriendlyUnit() {
        if (this.isZero()) {
            return this.getUnit();
        }
        Object[] units = this.unitMap().getUnitsSorted();
        String v = null;
        for (int i = units.length - 1; i >= 0; --i) {
            v = (String)units[i];
            if (!(this.getContentInUnits(v) > 1.0)) continue;
            return v;
        }
        return v;
    }

    protected boolean hasValue() {
        return this.hasContent();
    }

    protected double getValue() {
        return this.getContent();
    }

    protected void setValue(double value) {
        this.setContent(value);
    }

    @Override
    public boolean hasContent() {
        return this.getCastorObject().hasContent();
    }

    @Override
    public double getContent() {
        return this.getCastorObject().getContent();
    }

    @Override
    public String getUnit() {
        return this.getCastorObject().getUnit();
    }

    @Override
    public void setContent(double content) {
        this.getCastorObject().setContent(content);
        String property = "alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit.content";
        this.firePropertyChangeEvent(this, "alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit.content", new Double(content));
    }

    @Override
    public void setUnit(String unit) {
        this.getCastorObject().setUnit(unit);
        String property = "alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit.unit";
        this.firePropertyChangeEvent(this, "alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit.unit", unit);
    }

    public void setContentAndUnit(double content, String unit) {
        this.setContentAndUnit_atomic(content, unit);
    }

    protected final void setContentAndUnit_atomic(double content, String unit) {
        this.getCastorObject().setContent(content);
        this.getCastorObject().setUnit(unit);
        this.setContent(content);
        this.setUnit(unit);
    }

    public void setContentAndUnit(ValueUnitPair vup) {
        this.setContentAndUnit(vup.getContent(), vup.getUnit());
    }

    @Override
    public String toString() {
        return this.toBasicString();
    }

    public String toBasicString() {
        return this.getContent() + " " + this.getUnit();
    }

    @Override
    public int compareTo(T that) {
        Double mine = this.getContent();
        Double his = ((AbstractDoubleWithUnit)that).getContentInUnits(this.getUnit());
        return mine.compareTo(his);
    }

    @Override
    public boolean isGreaterThan(T arg) {
        double fInMyUnits = ((AbstractDoubleWithUnit)arg).getContentInUnits(this.getUnit());
        return this.getContent() > fInMyUnits;
    }

    @Override
    public boolean isGreaterThanOrEqualTo(T arg) {
        double fInMyUnits = ((AbstractDoubleWithUnit)arg).getContentInUnits(this.getUnit());
        return this.getContent() >= fInMyUnits;
    }

    @Override
    public boolean isLessThan(T arg) {
        double fInMyUnits = ((AbstractDoubleWithUnit)arg).getContentInUnits(this.getUnit());
        return this.getContent() < fInMyUnits;
    }

    @Override
    public boolean isLessThanOrEqualTo(T arg) {
        double fInMyUnits = ((AbstractDoubleWithUnit)arg).getContentInUnits(this.getUnit());
        return this.getContent() <= fInMyUnits;
    }

    @Override
    public boolean isZero() {
        return this.isZero(1.0E-5);
    }

    @Override
    public boolean isZero(double torelance) {
        double d = Math.abs(this.getContent());
        return d < torelance;
    }

    @Override
    public boolean isEqual(T arg) {
        return this.isEqual(arg, 1.0E-5);
    }

    @Override
    public boolean isEqual(T arg, double torelance) {
        double d = Math.abs(this.getContent() - ((AbstractDoubleWithUnit)arg).getContentInUnits(this.getUnit()));
        return d < torelance;
    }

    @Override
    public T plus(T arg) {
        AbstractDoubleWithUnit ret = (AbstractDoubleWithUnit)this.deepCopy();
        ret.setContent(this.getContent() + ((AbstractDoubleWithUnit)arg).getContentInUnits(this.getUnit()));
        return (T)ret;
    }

    @Override
    public T plus(T arg, boolean fastCopy) {
        if (!fastCopy) {
            return this.plus(arg);
        }
        AbstractDoubleWithUnit ret = (AbstractDoubleWithUnit)((BusinessObject)arg).invokeCreateUnitialized();
        ret.setContent(this.getContent() + ((AbstractDoubleWithUnit)arg).getContentInUnits(this.getUnit()));
        ret.setUnit(this.getUnit());
        return (T)ret;
    }

    @Override
    public T plus(T arg, T result) {
        if (result == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: varName");
        }
        String unit = this.getUnit();
        ((AbstractDoubleWithUnit)result).setContent(this.getContent() + ((AbstractDoubleWithUnit)arg).getContentInUnits(unit));
        ((AbstractDoubleWithUnit)result).setUnit(unit);
        return result;
    }

    @Override
    public T minus(T arg) {
        AbstractDoubleWithUnit ret = (AbstractDoubleWithUnit)this.deepCopy();
        ret.setContent(this.getContent() - ((AbstractDoubleWithUnit)arg).getContentInUnits(this.getUnit()));
        return (T)ret;
    }

    @Override
    public T minus(T arg, boolean fastCopy) {
        if (!fastCopy) {
            return this.minus(arg);
        }
        AbstractDoubleWithUnit ret = (AbstractDoubleWithUnit)this.invokeCreateUnitialized();
        ret.setContent(this.getContent() - ((AbstractDoubleWithUnit)arg).getContentInUnits(this.getUnit()));
        ret.setUnit(this.getUnit());
        return (T)ret;
    }

    @Override
    public T minus(T arg, T result) {
        if (result == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: result");
        }
        String unit = this.getUnit();
        ((AbstractDoubleWithUnit)result).setContent(this.getContent() - ((AbstractDoubleWithUnit)arg).getContentInUnits(unit));
        ((AbstractDoubleWithUnit)result).setUnit(unit);
        return result;
    }

    @Override
    public T multiply(double factor) {
        AbstractDoubleWithUnit ret = (AbstractDoubleWithUnit)this.deepCopy();
        ret.setContent(this.getContent() * factor);
        return (T)ret;
    }

    @Override
    public T multiply(double factor, boolean fastCopy) {
        if (!fastCopy) {
            return (T)this.multiply(factor);
        }
        AbstractDoubleWithUnit ret = (AbstractDoubleWithUnit)this.invokeCreateUnitialized();
        ret.setUnit(this.getUnit());
        ret.setContent(this.getContent() * factor);
        return (T)ret;
    }

    @Override
    public T multiply(double factor, T result) {
        if (result == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: result");
        }
        ((AbstractDoubleWithUnit)result).setContent(this.getContent() * factor);
        ((AbstractDoubleWithUnit)result).setUnit(this.getUnit());
        return result;
    }

    @Override
    public T divide(double factor) {
        AbstractDoubleWithUnit ret = (AbstractDoubleWithUnit)this.deepCopy();
        ret.setContent(this.getContent() / factor);
        return (T)ret;
    }

    @Override
    public T divide(double factor, boolean fastCopy) {
        if (!fastCopy) {
            return (T)this.divide(factor);
        }
        AbstractDoubleWithUnit ret = (AbstractDoubleWithUnit)this.invokeCreateUnitialized();
        ret.setUnit(this.getUnit());
        ret.setContent(this.getContent() / factor);
        return (T)ret;
    }

    @Override
    public T divide(double factor, T result) {
        if (result == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: result");
        }
        ((AbstractDoubleWithUnit)result).setContent(this.getContent() / factor);
        ((AbstractDoubleWithUnit)result).setUnit(this.getUnit());
        return result;
    }

    @Override
    public T half() {
        return (T)this.divide(2.0);
    }

    @Override
    public T half(boolean fastCopy) {
        return (T)this.divide(2.0, fastCopy);
    }
}

