/*
 * Decompiled with CFR 0.152.
 */
package alma.entity.xmlbinding.schedblock;

import alma.entity.xmlbinding.schedblock.SpectralLineT;
import alma.entity.xmlbinding.schedblock.types.AbstractSpectralWindowTPolnProductsType;
import alma.entity.xmlbinding.schedblock.types.AbstractSpectralWindowTSideBandType;
import alma.entity.xmlbinding.schedblock.types.AbstractSpectralWindowTWindowFunctionType;
import alma.entity.xmlbinding.valuetypes.FrequencyT;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;

public abstract class AbstractSpectralWindowT
implements Serializable {
    private AbstractSpectralWindowTSideBandType sideBand = AbstractSpectralWindowTSideBandType.valueOf("NOSB");
    private AbstractSpectralWindowTWindowFunctionType windowFunction = AbstractSpectralWindowTWindowFunctionType.valueOf("HANNING");
    private AbstractSpectralWindowTPolnProductsType polnProducts = AbstractSpectralWindowTPolnProductsType.valueOf("XX,YY");
    private FrequencyT centerFrequency;
    private int spectralAveragingFactor = 1;
    private boolean _hasspectralAveragingFactor;
    private String name;
    private FrequencyT effectiveBandwidth;
    private int effectiveNumberOfChannels;
    private boolean _haseffectiveNumberOfChannels;
    private int associatedSpectralWindowNumberInPair = 0;
    private boolean _hasassociatedSpectralWindowNumberInPair;
    private boolean useThisSpectralWindow = true;
    private boolean _hasuseThisSpectralWindow;
    private FrequencyT desiredCenterFrequency;
    private boolean representativeWindow = false;
    private boolean _hasrepresentativeWindow;
    private List<SpectralLineT> spectralLineList;

    public AbstractSpectralWindowT() {
        this.setSideBand(AbstractSpectralWindowTSideBandType.valueOf("NOSB"));
        this.setWindowFunction(AbstractSpectralWindowTWindowFunctionType.valueOf("HANNING"));
        this.setPolnProducts(AbstractSpectralWindowTPolnProductsType.valueOf("XX,YY"));
        this.spectralLineList = new ArrayList<SpectralLineT>();
    }

    public void addSpectralLine(SpectralLineT vSpectralLine) throws IndexOutOfBoundsException {
        this.spectralLineList.add(vSpectralLine);
    }

    public void addSpectralLine(int index, SpectralLineT vSpectralLine) throws IndexOutOfBoundsException {
        this.spectralLineList.add(index, vSpectralLine);
    }

    public void deleteAssociatedSpectralWindowNumberInPair() {
        this._hasassociatedSpectralWindowNumberInPair = false;
    }

    public void deleteEffectiveNumberOfChannels() {
        this._haseffectiveNumberOfChannels = false;
    }

    public void deleteRepresentativeWindow() {
        this._hasrepresentativeWindow = false;
    }

    public void deleteSpectralAveragingFactor() {
        this._hasspectralAveragingFactor = false;
    }

    public void deleteUseThisSpectralWindow() {
        this._hasuseThisSpectralWindow = false;
    }

    public Enumeration<? extends SpectralLineT> enumerateSpectralLine() {
        return Collections.enumeration(this.spectralLineList);
    }

    public int getAssociatedSpectralWindowNumberInPair() {
        return this.associatedSpectralWindowNumberInPair;
    }

    public FrequencyT getCenterFrequency() {
        return this.centerFrequency;
    }

    public FrequencyT getDesiredCenterFrequency() {
        return this.desiredCenterFrequency;
    }

    public FrequencyT getEffectiveBandwidth() {
        return this.effectiveBandwidth;
    }

    public int getEffectiveNumberOfChannels() {
        return this.effectiveNumberOfChannels;
    }

    public String getName() {
        return this.name;
    }

    public AbstractSpectralWindowTPolnProductsType getPolnProducts() {
        return this.polnProducts;
    }

    public boolean getRepresentativeWindow() {
        return this.representativeWindow;
    }

    public AbstractSpectralWindowTSideBandType getSideBand() {
        return this.sideBand;
    }

    public int getSpectralAveragingFactor() {
        return this.spectralAveragingFactor;
    }

    public SpectralLineT getSpectralLine(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.spectralLineList.size()) {
            throw new IndexOutOfBoundsException("getSpectralLine: Index value '" + index + "' not in range [0.." + (this.spectralLineList.size() - 1) + "]");
        }
        return this.spectralLineList.get(index);
    }

    public SpectralLineT[] getSpectralLine() {
        SpectralLineT[] array = new SpectralLineT[]{};
        return this.spectralLineList.toArray(array);
    }

    public int getSpectralLineCount() {
        return this.spectralLineList.size();
    }

    public boolean getUseThisSpectralWindow() {
        return this.useThisSpectralWindow;
    }

    public AbstractSpectralWindowTWindowFunctionType getWindowFunction() {
        return this.windowFunction;
    }

    public boolean hasAssociatedSpectralWindowNumberInPair() {
        return this._hasassociatedSpectralWindowNumberInPair;
    }

    public boolean hasEffectiveNumberOfChannels() {
        return this._haseffectiveNumberOfChannels;
    }

    public boolean hasRepresentativeWindow() {
        return this._hasrepresentativeWindow;
    }

    public boolean hasSpectralAveragingFactor() {
        return this._hasspectralAveragingFactor;
    }

    public boolean hasUseThisSpectralWindow() {
        return this._hasuseThisSpectralWindow;
    }

    public boolean isRepresentativeWindow() {
        return this.representativeWindow;
    }

    public boolean isUseThisSpectralWindow() {
        return this.useThisSpectralWindow;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends SpectralLineT> iterateSpectralLine() {
        return this.spectralLineList.iterator();
    }

    public void removeAllSpectralLine() {
        this.spectralLineList.clear();
    }

    public boolean removeSpectralLine(SpectralLineT vSpectralLine) {
        boolean removed = this.spectralLineList.remove(vSpectralLine);
        return removed;
    }

    public SpectralLineT removeSpectralLineAt(int index) {
        SpectralLineT obj = this.spectralLineList.remove(index);
        return obj;
    }

    public void setAssociatedSpectralWindowNumberInPair(int associatedSpectralWindowNumberInPair) {
        this.associatedSpectralWindowNumberInPair = associatedSpectralWindowNumberInPair;
        this._hasassociatedSpectralWindowNumberInPair = true;
    }

    public void setCenterFrequency(FrequencyT centerFrequency) {
        this.centerFrequency = centerFrequency;
    }

    public void setDesiredCenterFrequency(FrequencyT desiredCenterFrequency) {
        this.desiredCenterFrequency = desiredCenterFrequency;
    }

    public void setEffectiveBandwidth(FrequencyT effectiveBandwidth) {
        this.effectiveBandwidth = effectiveBandwidth;
    }

    public void setEffectiveNumberOfChannels(int effectiveNumberOfChannels) {
        this.effectiveNumberOfChannels = effectiveNumberOfChannels;
        this._haseffectiveNumberOfChannels = true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPolnProducts(AbstractSpectralWindowTPolnProductsType polnProducts) {
        this.polnProducts = polnProducts;
    }

    public void setRepresentativeWindow(boolean representativeWindow) {
        this.representativeWindow = representativeWindow;
        this._hasrepresentativeWindow = true;
    }

    public void setSideBand(AbstractSpectralWindowTSideBandType sideBand) {
        this.sideBand = sideBand;
    }

    public void setSpectralAveragingFactor(int spectralAveragingFactor) {
        this.spectralAveragingFactor = spectralAveragingFactor;
        this._hasspectralAveragingFactor = true;
    }

    public void setSpectralLine(int index, SpectralLineT vSpectralLine) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.spectralLineList.size()) {
            throw new IndexOutOfBoundsException("setSpectralLine: Index value '" + index + "' not in range [0.." + (this.spectralLineList.size() - 1) + "]");
        }
        this.spectralLineList.set(index, vSpectralLine);
    }

    public void setSpectralLine(SpectralLineT[] vSpectralLineArray) {
        this.spectralLineList.clear();
        for (int i = 0; i < vSpectralLineArray.length; ++i) {
            this.spectralLineList.add(vSpectralLineArray[i]);
        }
    }

    public void setUseThisSpectralWindow(boolean useThisSpectralWindow) {
        this.useThisSpectralWindow = useThisSpectralWindow;
        this._hasuseThisSpectralWindow = true;
    }

    public void setWindowFunction(AbstractSpectralWindowTWindowFunctionType windowFunction) {
        this.windowFunction = windowFunction;
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

