/*
 * Decompiled with CFR 0.152.
 */
package alma.entity.xmlbinding.obsproject;

import alma.entity.xmlbinding.obsproject.ObsProgramT;
import alma.entity.xmlbinding.obsproject.ObsProjectEntityT;
import alma.entity.xmlbinding.obsproject.SubmissionRecordT;
import alma.entity.xmlbinding.obsproject.types.ObsProjectStatusType;
import alma.entity.xmlbinding.obsproposal.ObsProposalRefT;
import alma.entity.xmlbinding.obsreview.ObsReviewRefT;
import alma.entity.xmlbinding.projectstatus.ProjectStatusRefT;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class ObsProject
implements Serializable {
    private String schemaVersion = "13";
    private String revision = "29";
    private String almatype = "APDM::ObsProject";
    private ObsProjectStatusType status = ObsProjectStatusType.valueOf("NewPhase1");
    private ObsProjectEntityT obsProjectEntity;
    private ObsProposalRefT obsProposalRef;
    private ObsReviewRefT obsReviewRef;
    private ProjectStatusRefT projectStatusRef;
    private String projectName;
    private String pI;
    private String version = "0";
    private String code = "None Assigned";
    private int assignedPriority = 0;
    private boolean _hasassignedPriority;
    private String timeOfCreation = "0000-00-00";
    private boolean manualMode = false;
    private boolean _hasmanualMode;
    private boolean simulationMode = false;
    private boolean _hassimulationMode;
    private boolean isCommissioning = false;
    private boolean _hasisCommissioning;
    private boolean isCalibration = false;
    private boolean _hasisCalibration;
    private String letterGrade = "D";
    private int scientificRank = 1;
    private boolean _hasscientificRank;
    private double scientificScore = 1.0;
    private boolean _hasscientificScore;
    private String staffProjectNote;
    private String taPhase2Comments;
    private String taMainComments;
    private String consensusReport;
    private boolean isDDT = false;
    private boolean _hasisDDT;
    private boolean p2gAttention = false;
    private boolean _hasp2gAttention;
    private String p2gAttentionReasons;
    private ObsProgramT obsProgram;
    private List<SubmissionRecordT> submissionRecordList;

    public ObsProject() {
        this.setSchemaVersion("13");
        this.setRevision("29");
        this.setAlmatype("APDM::ObsProject");
        this.setStatus(ObsProjectStatusType.valueOf("NewPhase1"));
        this.setVersion("0");
        this.setCode("None Assigned");
        this.setTimeOfCreation("0000-00-00");
        this.setLetterGrade("D");
        this.submissionRecordList = new ArrayList<SubmissionRecordT>();
    }

    public void addSubmissionRecord(SubmissionRecordT vSubmissionRecord) throws IndexOutOfBoundsException {
        this.submissionRecordList.add(vSubmissionRecord);
    }

    public void addSubmissionRecord(int index, SubmissionRecordT vSubmissionRecord) throws IndexOutOfBoundsException {
        this.submissionRecordList.add(index, vSubmissionRecord);
    }

    public void deleteAssignedPriority() {
        this._hasassignedPriority = false;
    }

    public void deleteIsCalibration() {
        this._hasisCalibration = false;
    }

    public void deleteIsCommissioning() {
        this._hasisCommissioning = false;
    }

    public void deleteIsDDT() {
        this._hasisDDT = false;
    }

    public void deleteManualMode() {
        this._hasmanualMode = false;
    }

    public void deleteP2gAttention() {
        this._hasp2gAttention = false;
    }

    public void deleteScientificRank() {
        this._hasscientificRank = false;
    }

    public void deleteScientificScore() {
        this._hasscientificScore = false;
    }

    public void deleteSimulationMode() {
        this._hassimulationMode = false;
    }

    public Enumeration<? extends SubmissionRecordT> enumerateSubmissionRecord() {
        return Collections.enumeration(this.submissionRecordList);
    }

    public String getAlmatype() {
        return this.almatype;
    }

    public int getAssignedPriority() {
        return this.assignedPriority;
    }

    public String getCode() {
        return this.code;
    }

    public String getConsensusReport() {
        return this.consensusReport;
    }

    public boolean getIsCalibration() {
        return this.isCalibration;
    }

    public boolean getIsCommissioning() {
        return this.isCommissioning;
    }

    public boolean getIsDDT() {
        return this.isDDT;
    }

    public String getLetterGrade() {
        return this.letterGrade;
    }

    public boolean getManualMode() {
        return this.manualMode;
    }

    public ObsProgramT getObsProgram() {
        return this.obsProgram;
    }

    public ObsProjectEntityT getObsProjectEntity() {
        return this.obsProjectEntity;
    }

    public ObsProposalRefT getObsProposalRef() {
        return this.obsProposalRef;
    }

    public ObsReviewRefT getObsReviewRef() {
        return this.obsReviewRef;
    }

    public boolean getP2gAttention() {
        return this.p2gAttention;
    }

    public String getP2gAttentionReasons() {
        return this.p2gAttentionReasons;
    }

    public String getPI() {
        return this.pI;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public ProjectStatusRefT getProjectStatusRef() {
        return this.projectStatusRef;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public int getScientificRank() {
        return this.scientificRank;
    }

    public double getScientificScore() {
        return this.scientificScore;
    }

    public boolean getSimulationMode() {
        return this.simulationMode;
    }

    public String getStaffProjectNote() {
        return this.staffProjectNote;
    }

    public ObsProjectStatusType getStatus() {
        return this.status;
    }

    public SubmissionRecordT getSubmissionRecord(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.submissionRecordList.size()) {
            throw new IndexOutOfBoundsException("getSubmissionRecord: Index value '" + index + "' not in range [0.." + (this.submissionRecordList.size() - 1) + "]");
        }
        return this.submissionRecordList.get(index);
    }

    public SubmissionRecordT[] getSubmissionRecord() {
        SubmissionRecordT[] array = new SubmissionRecordT[]{};
        return this.submissionRecordList.toArray(array);
    }

    public int getSubmissionRecordCount() {
        return this.submissionRecordList.size();
    }

    public String getTaMainComments() {
        return this.taMainComments;
    }

    public String getTaPhase2Comments() {
        return this.taPhase2Comments;
    }

    public String getTimeOfCreation() {
        return this.timeOfCreation;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasAssignedPriority() {
        return this._hasassignedPriority;
    }

    public boolean hasIsCalibration() {
        return this._hasisCalibration;
    }

    public boolean hasIsCommissioning() {
        return this._hasisCommissioning;
    }

    public boolean hasIsDDT() {
        return this._hasisDDT;
    }

    public boolean hasManualMode() {
        return this._hasmanualMode;
    }

    public boolean hasP2gAttention() {
        return this._hasp2gAttention;
    }

    public boolean hasScientificRank() {
        return this._hasscientificRank;
    }

    public boolean hasScientificScore() {
        return this._hasscientificScore;
    }

    public boolean hasSimulationMode() {
        return this._hassimulationMode;
    }

    public boolean isIsCalibration() {
        return this.isCalibration;
    }

    public boolean isIsCommissioning() {
        return this.isCommissioning;
    }

    public boolean isIsDDT() {
        return this.isDDT;
    }

    public boolean isManualMode() {
        return this.manualMode;
    }

    public boolean isP2gAttention() {
        return this.p2gAttention;
    }

    public boolean isSimulationMode() {
        return this.simulationMode;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends SubmissionRecordT> iterateSubmissionRecord() {
        return this.submissionRecordList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllSubmissionRecord() {
        this.submissionRecordList.clear();
    }

    public boolean removeSubmissionRecord(SubmissionRecordT vSubmissionRecord) {
        boolean removed = this.submissionRecordList.remove(vSubmissionRecord);
        return removed;
    }

    public SubmissionRecordT removeSubmissionRecordAt(int index) {
        SubmissionRecordT obj = this.submissionRecordList.remove(index);
        return obj;
    }

    public void setAlmatype(String almatype) {
        this.almatype = almatype;
    }

    public void setAssignedPriority(int assignedPriority) {
        this.assignedPriority = assignedPriority;
        this._hasassignedPriority = true;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setConsensusReport(String consensusReport) {
        this.consensusReport = consensusReport;
    }

    public void setIsCalibration(boolean isCalibration) {
        this.isCalibration = isCalibration;
        this._hasisCalibration = true;
    }

    public void setIsCommissioning(boolean isCommissioning) {
        this.isCommissioning = isCommissioning;
        this._hasisCommissioning = true;
    }

    public void setIsDDT(boolean isDDT) {
        this.isDDT = isDDT;
        this._hasisDDT = true;
    }

    public void setLetterGrade(String letterGrade) {
        this.letterGrade = letterGrade;
    }

    public void setManualMode(boolean manualMode) {
        this.manualMode = manualMode;
        this._hasmanualMode = true;
    }

    public void setObsProgram(ObsProgramT obsProgram) {
        this.obsProgram = obsProgram;
    }

    public void setObsProjectEntity(ObsProjectEntityT obsProjectEntity) {
        this.obsProjectEntity = obsProjectEntity;
    }

    public void setObsProposalRef(ObsProposalRefT obsProposalRef) {
        this.obsProposalRef = obsProposalRef;
    }

    public void setObsReviewRef(ObsReviewRefT obsReviewRef) {
        this.obsReviewRef = obsReviewRef;
    }

    public void setP2gAttention(boolean p2gAttention) {
        this.p2gAttention = p2gAttention;
        this._hasp2gAttention = true;
    }

    public void setP2gAttentionReasons(String p2gAttentionReasons) {
        this.p2gAttentionReasons = p2gAttentionReasons;
    }

    public void setPI(String pI) {
        this.pI = pI;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setProjectStatusRef(ProjectStatusRefT projectStatusRef) {
        this.projectStatusRef = projectStatusRef;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void setScientificRank(int scientificRank) {
        this.scientificRank = scientificRank;
        this._hasscientificRank = true;
    }

    public void setScientificScore(double scientificScore) {
        this.scientificScore = scientificScore;
        this._hasscientificScore = true;
    }

    public void setSimulationMode(boolean simulationMode) {
        this.simulationMode = simulationMode;
        this._hassimulationMode = true;
    }

    public void setStaffProjectNote(String staffProjectNote) {
        this.staffProjectNote = staffProjectNote;
    }

    public void setStatus(ObsProjectStatusType status) {
        this.status = status;
    }

    public void setSubmissionRecord(int index, SubmissionRecordT vSubmissionRecord) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.submissionRecordList.size()) {
            throw new IndexOutOfBoundsException("setSubmissionRecord: Index value '" + index + "' not in range [0.." + (this.submissionRecordList.size() - 1) + "]");
        }
        this.submissionRecordList.set(index, vSubmissionRecord);
    }

    public void setSubmissionRecord(SubmissionRecordT[] vSubmissionRecordArray) {
        this.submissionRecordList.clear();
        for (int i = 0; i < vSubmissionRecordArray.length; ++i) {
            this.submissionRecordList.add(vSubmissionRecordArray[i]);
        }
    }

    public void setTaMainComments(String taMainComments) {
        this.taMainComments = taMainComments;
    }

    public void setTaPhase2Comments(String taPhase2Comments) {
        this.taPhase2Comments = taPhase2Comments;
    }

    public void setTimeOfCreation(String timeOfCreation) {
        this.timeOfCreation = timeOfCreation;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static ObsProject unmarshalObsProject(Reader reader) throws MarshalException, ValidationException {
        return (ObsProject)Unmarshaller.unmarshal(ObsProject.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

