/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.dao;

import alma.sourcecat.dao.SourceBandDaoImpl;
import alma.sourcecat.dao.SourceDao;
import alma.sourcecat.model.Source;
import alma.sourcecat.model.SourceBand;
import alma.sourcecat.model.SourceName;
import alma.sourcecat.model.Type;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public final class SourceDaoImpl
implements SourceDao {
    private static final Log LOG = LogFactory.getLog(SourceDaoImpl.class);
    private JdbcTemplate jdbcTmpl;
    private static final String DELETE_SQL = "DELETE FROM source_type WHERE source_id = ? AND type_id = ?";
    private static final String ID_SQL = "SELECT source_id_seq.nextval FROM dual";
    private static final String INSERT_SQL = "INSERT INTO sources (source_id) VALUES (?)";

    @Override
    public Boolean removeSourceType(Integer sourceId, Integer typeId) {
        boolean success = false;
        if (sourceId != null && typeId != null) {
            try {
                success = this.jdbcTmpl.update(DELETE_SQL, new Object[]{sourceId, typeId}) == 1;
            }
            catch (DataAccessException e) {
                LOG.error((Object)String.format("Could not remove type %s from source %s.", typeId, sourceId), (Throwable)e);
            }
        }
        return success;
    }

    @Override
    public Integer addSource() {
        int sourceId = (Integer)this.jdbcTmpl.queryForObject(ID_SQL, Integer.class);
        int res = this.jdbcTmpl.update(INSERT_SQL, new Object[]{sourceId});
        return res == 1 ? sourceId : 0;
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTmpl = new JdbcTemplate(dataSource);
    }

    @Override
    public List<Source> getSources(String sourceName, Integer limit, Double spectralIndexMin, Double spectralIndexMax) {
        ArrayList<Object> parameters = new ArrayList<Object>(10);
        String sql = "select distinct s.source_id, ra_deg, ra_deg_uncertainty, dec_deg, dec_deg_uncertainty from sources s inner join sourcename sn on sn.source_id = s.source_id left join source_band sb on s.source_id = sb.source_id where 1 = 1";
        String nameSql = "select source_id, id, name from sourcename where 1 = 0";
        String typeSql = "select st.source_id, t.type_id as id, t.type_name as name from source_type st   inner join types t on t.type_id = st.type_id where 1 = 0";
        if (sourceName != null) {
            sql = sql + " and upper(name) like ?";
            parameters.add('%' + sourceName.toUpperCase().trim() + '%');
        }
        if (spectralIndexMin != null) {
            sql = sql + " and sb.spectral_index >= ?";
            parameters.add(spectralIndexMin);
        }
        if (spectralIndexMax != null) {
            sql = sql + " and sb.spectral_index <= ?";
            parameters.add(spectralIndexMax);
        }
        sql = sql + " and rownum < ?";
        parameters.add(limit);
        final HashMap<Integer, Source> sources = new HashMap<Integer, Source>();
        this.jdbcTmpl.query(sql, parameters.toArray(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Integer id = rs.getInt("source_id");
                Source source = (Source)sources.get(id);
                if (source == null) {
                    source = new Source(id);
                    sources.put(id, source);
                }
                SourceDaoImpl.populatePosition(source, rs);
            }
        });
        if (!sources.isEmpty()) {
            String paramSql = this.formSql(sources, parameters);
            this.jdbcTmpl.queryForList("select source_id, id, name from sourcename where 1 = 0" + paramSql, parameters.toArray()).stream().forEach(e -> ((Source)sources.get(SourceDaoImpl.getInt(e, "source_id"))).addName(new SourceName(SourceDaoImpl.getInt(e, "id"), SourceDaoImpl.getString(e, "name"))));
            this.jdbcTmpl.queryForList("select st.source_id, t.type_id as id, t.type_name as name from source_type st   inner join types t on t.type_id = st.type_id where 1 = 0" + paramSql, parameters.toArray()).stream().forEach(e -> ((Source)sources.get(SourceDaoImpl.getInt(e, "source_id"))).addType(new Type(SourceDaoImpl.getInt(e, "id"), SourceDaoImpl.getString(e, "name"))));
        }
        return sources.isEmpty() ? Collections.emptyList() : new ArrayList(sources.values());
    }

    private static final Integer getInt(Map<String, Object> e, String key) {
        return ((BigDecimal)e.get(key)).intValue();
    }

    private static final String getString(Map<String, Object> e, String key) {
        return (String)e.get(key);
    }

    private String formSql(Map<Integer, Source> sources, List<Object> parameters) {
        String whereClause = "";
        parameters.clear();
        for (Integer nextSourceId : sources.keySet()) {
            whereClause = whereClause + " or source_id = ?";
            parameters.add(nextSourceId);
        }
        return whereClause;
    }

    private static void populatePosition(Source source, ResultSet rs) throws SQLException {
        source.setRaDeg(rs.getDouble("ra_deg"));
        if (rs.wasNull()) {
            source.setRaDeg(null);
        }
        source.setRaDegUncertainty(rs.getDouble("ra_deg_uncertainty"));
        if (rs.wasNull()) {
            source.setRaDegUncertainty(null);
        }
        source.setDecDeg(rs.getDouble("dec_deg"));
        if (rs.wasNull()) {
            source.setDecDeg(null);
        }
        source.setDecDegUncertainty(rs.getDouble("dec_deg_uncertainty"));
        if (rs.wasNull()) {
            source.setDecDegUncertainty(null);
        }
    }

    @Override
    public Source getSource(final Integer sourceId) {
        String sourceSql = "select ra_deg, ra_deg_uncertainty, dec_deg, dec_deg_uncertainty, s.update_date, s.update_user, s.update_comment from sources s WHERE s.source_id = :source_id";
        String namesSql = "select id, name, is_alma_default from sourcename WHERE source_id = :source_id order by is_alma_default desc, name asc";
        String bandsSql = "select sb.id, r.range_id, r.frequency_min, r.range_name, sb.uvmin, sb.uvmax, sb.spectral_index,  sb.update_date, sb.update_user, sb.update_comment from source_band sb   inner join ranges r     on sb.band_id = r.range_id WHERE source_id = :source_id order by r.frequency_min asc";
        String typesSql = "select s.type_id, s.type_name from types s inner join source_type st on st.type_id = s.type_id where st.source_id = ?";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("-> getSourceRest(" + sourceId + ")"));
        }
        final Source source = new Source(0);
        this.jdbcTmpl.query("select ra_deg, ra_deg_uncertainty, dec_deg, dec_deg_uncertainty, s.update_date, s.update_user, s.update_comment from sources s WHERE s.source_id = :source_id", new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                source.setId(sourceId);
                SourceDaoImpl.populatePosition(source, rs);
                source.setUpdateComment(rs.getString("update_comment"));
                source.setUpdateDate(rs.getTimestamp("update_date"));
                source.setUpdateUser(rs.getString("update_user"));
            }
        }, new Object[]{sourceId});
        this.jdbcTmpl.query("select id, name, is_alma_default from sourcename WHERE source_id = :source_id order by is_alma_default desc, name asc", new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                source.addName(new SourceName(rs.getInt("id"), rs.getString("name")));
            }
        }, new Object[]{sourceId});
        this.jdbcTmpl.query("select sb.id, r.range_id, r.frequency_min, r.range_name, sb.uvmin, sb.uvmax, sb.spectral_index,  sb.update_date, sb.update_user, sb.update_comment from source_band sb   inner join ranges r     on sb.band_id = r.range_id WHERE source_id = :source_id order by r.frequency_min asc", new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                SourceBand sourceBand = SourceBandDaoImpl.createSourceBand(rs);
                sourceBand.setUpdateComment(rs.getString("update_comment"));
                sourceBand.setUpdateUser(rs.getString("update_user"));
                sourceBand.setUpdateDate(rs.getDate("update_date"));
                source.addSourceBand(sourceBand);
            }
        }, new Object[]{sourceId});
        this.jdbcTmpl.query("select s.type_id, s.type_name from types s inner join source_type st on st.type_id = s.type_id where st.source_id = ?", new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Integer id = rs.getInt("type_id");
                String name = rs.getString("type_name");
                Type type = new Type(id, name);
                source.addType(type);
            }
        }, new Object[]{sourceId});
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<- getSourceRest");
        }
        return source;
    }

    @Override
    public Boolean updateSource(Source source) {
        String updateSql = "UPDATE sources SET     ra_deg = ?,     ra_deg_uncertainty = ?,     dec_deg = ?,     dec_deg_uncertainty = ?,     update_user = ?,     update_date = sysdate,     update_comment = ? WHERE source_id = ?";
        return this.jdbcTmpl.update("UPDATE sources SET     ra_deg = ?,     ra_deg_uncertainty = ?,     dec_deg = ?,     dec_deg_uncertainty = ?,     update_user = ?,     update_date = sysdate,     update_comment = ? WHERE source_id = ?", new Object[]{source.getRaDeg(), source.getRaDegUncertainty(), source.getDecDeg(), source.getDecDegUncertainty(), source.getUpdateUser(), source.getUpdateComment(), source.getId()}) == 1;
    }

    @Override
    public Integer addSource(String name, Double raDeg, Double raDegUncertainty, Double decDeg, Double decDegUncertainty, String createdBy) {
        String idSql = "select source_id_seq.nextval from dual";
        String sourceSql = "insert into sources (source_id, ra_deg, ra_deg_uncertainty, dec_deg, dec_deg_uncertainty, update_user, update_comment, update_date) values (?, ?, ?, ?, ?, ?, 'created', sysdate)";
        String bandSql = "insert into source_band (id, source_id, band_id, update_date, update_user, update_comment) select source_band_seq.nextval, source_id, range_id, sysdate, 'unknown', 'created' from sources s cross join ranges r where source_id = ?";
        Integer newId = (Integer)this.jdbcTmpl.queryForObject("select source_id_seq.nextval from dual", Integer.class);
        this.jdbcTmpl.update("insert into sources (source_id, ra_deg, ra_deg_uncertainty, dec_deg, dec_deg_uncertainty, update_user, update_comment, update_date) values (?, ?, ?, ?, ?, ?, 'created', sysdate)", new Object[]{newId, raDeg, raDegUncertainty, decDeg, decDegUncertainty, createdBy}, new int[]{4, 2, 2, 2, 2, 12});
        this.jdbcTmpl.update("insert into source_band (id, source_id, band_id, update_date, update_user, update_comment) select source_band_seq.nextval, source_id, range_id, sysdate, 'unknown', 'created' from sources s cross join ranges r where source_id = ?", new Object[]{newId});
        return newId;
    }
}

