/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.dao;

import alma.sourcecat.dao.AstronomicalUtils;
import alma.sourcecat.dao.DistinctSourceCounter;
import alma.sourcecat.model.Measurement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

class MeasurementResultSetExtractor
implements ResultSetExtractor<Measurement> {
    private static final Log LOG = LogFactory.getLog(MeasurementResultSetExtractor.class);
    private List<Measurement> measurementsList;
    private Double searchRaInRadians;
    private Double searchDecInRadians;
    private boolean measurementOnly = false;
    private boolean withComments = false;
    private DistinctSourceCounter distinctSourceCounter;

    public MeasurementResultSetExtractor(List<Measurement> measurementsList, MapSqlParameterSource sqlParameters) {
        this.measurementsList = measurementsList;
        this.searchRaInRadians = sqlParameters.hasValue("ra") ? (Double)sqlParameters.getValue("ra") : null;
        this.searchDecInRadians = sqlParameters.hasValue("dec") ? (Double)sqlParameters.getValue("dec") : null;
        Integer searchLimit = sqlParameters.hasValue("max_sources") ? (Integer)sqlParameters.getValue("max_sources") : -1;
        this.distinctSourceCounter = new DistinctSourceCounter(searchLimit);
    }

    public MeasurementResultSetExtractor(List<Measurement> measurementsList, MapSqlParameterSource sqlParameters, boolean measurementOnly) {
        this(measurementsList, sqlParameters);
        this.measurementOnly = measurementOnly;
        this.withComments = measurementOnly;
    }

    public Measurement extractData(ResultSet result) throws SQLException, DataAccessException {
        Integer sourceId;
        long startMillis = System.currentTimeMillis();
        while (result.next() && !this.distinctSourceCounter.requiredNumberReached(sourceId = Integer.valueOf(result.getInt("source_id")))) {
            Double sourceRa = null;
            Double sourceRaUncertainty = null;
            Double sourceDec = null;
            Double sourceDecUncertainty = null;
            if (!this.measurementOnly) {
                sourceRa = result.getDouble("ra_deg");
                sourceRaUncertainty = result.getDouble("ra_deg_uncertainty");
                sourceDec = result.getDouble("dec_deg");
                sourceDecUncertainty = result.getDouble("dec_deg_uncertainty");
            }
            Measurement measurement = new Measurement(result.getInt("measurement_id"), result.getInt("catalogue_id"), sourceId, result.getDouble("ra"), result.getString("ra_uncertainty"), result.getDouble("dec"), result.getString("dec_uncertainty"), result.getDouble("frequency"), result.getDouble("flux"), result.getString("flux_uncertainty"), result.getString("degree"), result.getString("degree_uncertainty"), result.getString("angle"), result.getString("angle_uncertainty"), result.getString("origin"), result.getTimestamp("date_observed"), result.getInt("valid") != 0, sourceRa, sourceRaUncertainty, sourceDec, sourceDecUncertainty);
            if (!this.measurementOnly) {
                measurement.setBandName(result.getString("bandName"));
                Double spectralIndex = result.getDouble("spectral_index");
                if (!result.wasNull()) {
                    measurement.setSpectralIndex(spectralIndex);
                }
                Double separationInDegrees = AstronomicalUtils.calculateSeparation(sourceRa, sourceDec, this.searchRaInRadians, this.searchDecInRadians);
                measurement.setSeparationInDegrees(separationInDegrees);
            }
            Double uvMin = result.getDouble("uvmin");
            if (!result.wasNull()) {
                measurement.setUvMin(uvMin);
            }
            Double uvMax = result.getDouble("uvmax");
            if (!result.wasNull()) {
                measurement.setUvMax(uvMax);
            }
            if (this.withComments) {
                Timestamp date = result.getTimestamp("update_date");
                if (!result.wasNull()) {
                    measurement.setUpdateDate(date);
                }
                String updateUser = result.getString("update_user");
                if (!result.wasNull()) {
                    measurement.setUpdateUser(updateUser);
                }
                String updateComment = result.getString("update_comment");
                if (!result.wasNull()) {
                    measurement.setUpdateComment(updateComment);
                }
            }
            this.measurementsList.add(measurement);
        }
        LOG.info((Object)("extracted " + this.measurementsList.size() + " in " + (System.currentTimeMillis() - startMillis) + "ms"));
        return null;
    }
}

