/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.entityutil;

import alma.acs.entityutil.EntityException;
import alma.acs.util.StopWatch;
import alma.entities.commonentity.EntityRefT;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;

public class EntityRefFinder {
    private boolean m_debug;

    public EntityRefFinder() {
        this(false);
    }

    public EntityRefFinder(boolean debug) {
        this.m_debug = debug;
    }

    public EntityRefT[] findEntityReferences(Object rootEntityObject) throws EntityException {
        ArrayList<EntityRefT> entityRefs = new ArrayList<EntityRefT>();
        StopWatch stopw = new StopWatch(null);
        this.recursiveFindEntityReferences(rootEntityObject, entityRefs);
        if (this.m_debug) {
            System.out.println("findEntityReferences took " + stopw.getLapTimeMillis() + " ms.");
        }
        return entityRefs.toArray(new EntityRefT[0]);
    }

    private void recursiveFindEntityReferences(Object obj, ArrayList<EntityRefT> entityRefs) throws EntityException {
        try {
            if (obj == null) {
                return;
            }
            Class<?> objClass = obj.getClass();
            if (obj instanceof Class || objClass.isPrimitive() || objClass.isArray() || objClass.getPackage().getName().equals("java.lang")) {
                return;
            }
            if (this.m_debug) {
                System.out.println(obj.getClass().getName());
            }
            if (obj instanceof EntityRefT) {
                entityRefs.add((EntityRefT)obj);
                return;
            }
            Method[] methods = obj.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i].getName().startsWith("get") && methods[i].getParameterTypes().length == 0) {
                    Object retObj = methods[i].invoke(obj, (Object[])null);
                    this.recursiveFindEntityReferences(retObj, entityRefs);
                    continue;
                }
                if (!methods[i].getName().startsWith("enumerate") || !methods[i].getReturnType().isAssignableFrom(Enumeration.class) || methods[i].getParameterTypes().length != 0 || Modifier.isStatic(methods[i].getModifiers())) continue;
                Enumeration retObjEnum = (Enumeration)methods[i].invoke(obj, (Object[])null);
                while (retObjEnum.hasMoreElements()) {
                    Object retObj = retObjEnum.nextElement();
                    this.recursiveFindEntityReferences(retObj, entityRefs);
                }
            }
        }
        catch (EntityException ex) {
            throw ex;
        }
        catch (Throwable thr) {
            throw new EntityException("failed to find entity references ", thr);
        }
    }
}

