/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container;

import alma.JavaContainerError.wrappers.AcsJContainerEx;
import alma.acs.container.AcsManagerProxy;
import alma.acs.container.AdvancedContainerServices;
import alma.acs.container.ContainerServicesImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import si.ijs.maci.Administrator;
import si.ijs.maci.AdministratorOperations;
import si.ijs.maci.AdministratorPOATie;
import si.ijs.maci.Client;
import si.ijs.maci.SynchronousAdministratorOperations;
import si.ijs.maci.SynchronousAdministratorPOATie;

public class AdvancedContainerServicesImpl
implements AdvancedContainerServices {
    protected ContainerServicesImpl containerServicesImpl;
    protected Logger logger;
    protected final Map<AdministratorOperations, AcsManagerProxy> adminClientsToManagerProxy = new HashMap<AdministratorOperations, AcsManagerProxy>();

    AdvancedContainerServicesImpl(ContainerServicesImpl containerServicesImpl, Logger logger) {
        this.containerServicesImpl = containerServicesImpl;
        this.logger = logger;
    }

    public String corbaObjectToString(Object objRef) {
        ORB orb = this.getORB();
        String str = orb.object_to_string(objRef);
        this.logger.finer("converted corba object reference of type " + objRef.getClass().getName() + " to the string " + str);
        return str;
    }

    public Object corbaObjectFromString(String strObjRef) {
        ORB orb = this.getORB();
        Object objRef = orb.string_to_object(strObjRef);
        this.logger.finer("converted corba object reference string " + strObjRef + " back to a corba object reference.");
        return objRef;
    }

    public ORB getORB() {
        return this.containerServicesImpl.getAcsCorba().getORB();
    }

    public Any getAny() {
        ORB orb = this.getORB();
        Any any = orb.create_any();
        if (any == null) {
            String msg = "Failed to create org.omg.CORBA.Any";
            this.logger.warning(msg);
            throw new NullPointerException(msg);
        }
        return any;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectManagerAdmin(AdministratorOperations adminOp, boolean retryConnectOnFailure) throws AcsJContainerEx {
        if (adminOp == null) {
            throw new IllegalArgumentException("adminOp == null not allowed.");
        }
        Map<AdministratorOperations, AcsManagerProxy> map = this.adminClientsToManagerProxy;
        synchronized (map) {
            AdministratorPOATie adminpoa;
            if (this.adminClientsToManagerProxy.containsKey(adminOp)) {
                this.logger.info("Attempt to connect manager admin of type " + adminOp.getClass().getName() + " again will be ignored.");
                return;
            }
            AcsManagerProxy acsManagerProxy = this.containerServicesImpl.m_acsManagerProxy.createInstance();
            Administrator admin = null;
            if (adminOp instanceof SynchronousAdministratorOperations) {
                adminpoa = new SynchronousAdministratorPOATie((SynchronousAdministratorOperations)adminOp);
                admin = adminpoa._this(this.getORB());
            } else {
                adminpoa = new AdministratorPOATie(adminOp);
                admin = adminpoa._this(this.getORB());
            }
            int attempts = retryConnectOnFailure ? 0 : 1;
            acsManagerProxy.loginToManager((Client)admin, attempts);
            this.adminClientsToManagerProxy.put(adminOp, acsManagerProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectManagerAdmin(AdministratorOperations adminOp) {
        Map<AdministratorOperations, AcsManagerProxy> map = this.adminClientsToManagerProxy;
        synchronized (map) {
            AcsManagerProxy prox = this.adminClientsToManagerProxy.get(adminOp);
            if (prox != null) {
                prox.logoutFromManager();
            }
        }
    }
}

