/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container;

import alma.JavaContainerError.wrappers.AcsJContainerEx;
import alma.acs.container.AcsContainer;
import alma.acs.container.AcsManagerProxy;
import alma.acs.container.corba.AcsCorba;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import java.util.logging.Logger;

public class AcsEmbeddedContainerRunner {
    protected AcsLogger m_logger;
    protected AcsCorba m_acsCorba;
    protected AcsContainer m_container;
    protected final boolean isEmbedded;
    protected final Boolean recoveryModeOverride;
    protected String m_containerName;
    protected String m_managerLoc;
    protected AcsManagerProxy m_managerProxy;

    public AcsEmbeddedContainerRunner() {
        this(true, false);
    }

    AcsEmbeddedContainerRunner(boolean isEmbedded, Boolean recoveryModeOverride) {
        this.isEmbedded = isEmbedded;
        this.recoveryModeOverride = recoveryModeOverride;
    }

    public void run(AcsCorba acsCorba, String containerName, String managerLoc) throws AcsJContainerEx {
        this.setContainerName(containerName);
        this.setManagerLoc(managerLoc);
        this.run(acsCorba);
    }

    void run(AcsCorba acsCorba) throws AcsJContainerEx {
        this.getContainerLogger();
        if (!acsCorba.isInitialized()) {
            AcsJContainerEx ex = new AcsJContainerEx();
            ex.setContextInfo("The provided AcsCorba object must be initialized!");
            throw ex;
        }
        this.m_acsCorba = acsCorba;
        this.checkReadyToRun(null);
        System.out.println("ContainerStatusMsg: Startup begins");
        this.initManagerProxy();
        this.createContainer();
        this.m_container.initialize();
        System.out.println("ContainerStatusMsg: Startup ends");
    }

    public AcsLogger getContainerLogger() {
        if (this.m_logger == null) {
            this.m_logger = ClientLogManager.getAcsLogManager().getLoggerForContainer(this.m_containerName);
        }
        return this.m_logger;
    }

    AcsContainer getContainer() {
        if (this.m_container == null) {
            throw new IllegalStateException("Container not yet created.");
        }
        return this.m_container;
    }

    AcsManagerProxy getManagerProxy() {
        if (this.m_managerProxy == null) {
            throw new IllegalStateException("Manager proxy not yet created.");
        }
        return this.m_managerProxy;
    }

    void checkReadyToRun(String otherMsg) throws AcsJContainerEx {
        Object msg = "";
        if (this.m_managerLoc == null || this.m_managerLoc.trim().length() == 0) {
            msg = (String)msg + "no manager-location specified; ";
        }
        if (this.m_containerName == null || this.m_containerName.trim().length() == 0) {
            msg = (String)msg + "no container name specified; ";
        }
        if (otherMsg != null) {
            msg = (String)msg + otherMsg;
        }
        if (((String)msg).length() > 0) {
            AcsJContainerEx ex = new AcsJContainerEx();
            ex.setContextInfo("can't start container because of missing information: " + (String)msg);
            throw ex;
        }
    }

    protected void createContainer() throws AcsJContainerEx {
        this.m_logger.fine("creating the AcsContainer " + this.m_containerName);
        this.m_container = new AcsContainer(this.m_containerName, this.m_acsCorba, this.m_managerProxy, this.isEmbedded);
        if (this.recoveryModeOverride != null) {
            this.m_container.setRecoveryModeOverride(this.recoveryModeOverride);
        }
        this.m_logger.fine("AcsContainer '" + this.m_containerName + "' created.");
    }

    protected void initManagerProxy() throws AcsJContainerEx {
        this.m_managerProxy = new AcsManagerProxy(this.m_managerLoc, this.m_acsCorba.getORB(), (Logger)this.m_logger);
        this.m_managerProxy.getManager();
    }

    void setContainerName(String name) {
        this.m_containerName = name;
    }

    void setManagerLoc(String loc) {
        this.m_managerLoc = loc;
    }
}

