/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container;

import alma.ACS.ACSComponentOperations;
import alma.ACS.CBDescIn;
import alma.ACS.CBDescOut;
import alma.ACS.ComponentStates;
import alma.ACSErrTypeCommon.wrappers.AcsJCouldntPerformActionEx;
import alma.ACSErrTypeCommon.wrappers.AcsJIllegalArgumentEx;
import alma.ACSErrTypeCommon.wrappers.AcsJUnknownEx;
import alma.ACSErrTypeOK.wrappers.ACSErrOKAcsJCompletion;
import alma.AcsContainerLog.LOG_CompAct_Corba_OK;
import alma.AcsContainerLog.LOG_CompAct_Init_OK;
import alma.AcsContainerLog.LOG_CompAct_Instance_OK;
import alma.AcsContainerLog.LOG_CompAct_Loading_OK;
import alma.JavaContainerError.wrappers.AcsJContainerEx;
import alma.Logging.ACSLogStatisticsPackage.LogStatsInformation;
import alma.Logging.IllegalLogLevelsEx;
import alma.Logging.LoggerDoesNotExistEx;
import alma.Logging.LoggingConfigurablePackage.LogLevels;
import alma.acs.classloading.AcsComponentClassLoader;
import alma.acs.component.ComponentDescriptor;
import alma.acs.component.ComponentLifecycle;
import alma.acs.container.AcsManagerProxy;
import alma.acs.container.CleaningDaemonThreadFactory;
import alma.acs.container.ComponentAdapter;
import alma.acs.container.ComponentHelper;
import alma.acs.container.ComponentMap;
import alma.acs.container.ContainerSealant;
import alma.acs.container.ContainerServicesBase;
import alma.acs.container.ContainerServicesImpl;
import alma.acs.container.ExternalInterfaceTranslator;
import alma.acs.container.corba.AcsCorba;
import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import alma.acs.logging.config.LogConfig;
import alma.acs.logging.config.LogConfigException;
import alma.acs.logging.level.AcsLogLevelDefinition;
import alma.acs.util.IsoDateFormat;
import alma.acs.util.StopWatch;
import alma.acs.util.UTCUtility;
import alma.alarmsystem.source.ACSAlarmSystemInterfaceFactory;
import alma.cdbErrType.CDBFieldDoesNotExistEx;
import alma.cdbErrType.CDBRecordDoesNotExistEx;
import alma.maci.containerconfig.types.ContainerImplLangType;
import alma.maci.loggingconfig.UnnamedLogger;
import alma.maci.loggingconfig.types.LogLevel;
import alma.maciErrType.CannotActivateComponentEx;
import alma.maciErrType.CannotRestartComponentEx;
import alma.maciErrType.ComponentDeactivationFailedEx;
import alma.maciErrType.ComponentDeactivationUncleanEx;
import alma.maciErrType.wrappers.AcsJCannotActivateComponentEx;
import alma.maciErrType.wrappers.AcsJCannotRestartComponentEx;
import alma.maciErrType.wrappers.AcsJComponentDeactivationFailedEx;
import alma.maciErrType.wrappers.AcsJComponentDeactivationUncleanEx;
import com.cosylab.CDB.DAL;
import com.cosylab.CDB.DALHelper;
import com.cosylab.CDB.DALOperations;
import com.cosylab.CDB.DAO;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Object;
import org.omg.PortableServer.Servant;
import si.ijs.maci.AuthenticationData;
import si.ijs.maci.CBComponentInfo;
import si.ijs.maci.Client;
import si.ijs.maci.ClientType;
import si.ijs.maci.ComponentInfo;
import si.ijs.maci.Container;
import si.ijs.maci.ContainerHelper;
import si.ijs.maci.ContainerPOA;
import si.ijs.maci.ImplLangType;

public class AcsContainer
extends ContainerPOA {
    private static volatile AcsContainer s_instance;
    private final long startTimeUTClong;
    private final String m_containerName;
    private long executionId = -1L;
    private final AcsManagerProxy m_managerProxy;
    private final AcsCorba m_acsCorba;
    private final boolean isEmbedded;
    private final AcsLogger m_logger;
    private final ThreadFactory containerThreadFactory;
    final ThreadPoolExecutor threadPoolExecutor;
    private final ComponentMap m_activeComponentMap;
    private ContainerServicesImpl m_alarmContainerServices;
    private final CountDownLatch containerStartOrbThreadGate;
    private LogConfig logConfig;
    private DAL sharedCdbRef;
    private final AtomicBoolean shuttingDown = new AtomicBoolean(false);
    private boolean useRecoveryMode = true;
    private Boolean recoveryModeOverride = null;
    private int m_managerRetry;
    public static final int CONTAINER_RELOAD = 0;
    public static final int CONTAINER_REBOOT = 1;
    public static final int CONTAINER_EXIT = 2;

    AcsContainer(String containerName, AcsCorba acsCorba, AcsManagerProxy managerProxy, boolean isEmbedded) throws AcsJContainerEx {
        if (s_instance != null) {
            AcsJContainerEx ex = new AcsJContainerEx();
            ex.setContextInfo("illegal attempt to create more than one instance of " + AcsContainer.class.getName() + " inside one JVM.");
            throw ex;
        }
        this.startTimeUTClong = UTCUtility.utcJavaToOmg((long)System.currentTimeMillis());
        this.m_containerName = containerName;
        this.containerStartOrbThreadGate = new CountDownLatch(1);
        this.m_managerProxy = managerProxy;
        this.isEmbedded = isEmbedded;
        this.m_logger = ClientLogManager.getAcsLogManager().getLoggerForContainer(containerName);
        this.containerThreadFactory = new CleaningDaemonThreadFactory(this.m_containerName, (Logger)this.m_logger, "Container");
        this.threadPoolExecutor = new ThreadPoolExecutor(10, 10, 3L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), this.containerThreadFactory, new ThreadPoolExecutor.AbortPolicy());
        this.threadPoolExecutor.allowCoreThreadTimeOut(true);
        this.m_activeComponentMap = new ComponentMap((Logger)this.m_logger);
        this.m_acsCorba = acsCorba;
        System.out.println("ContainerStatusMsg: ORB initialization begins");
        this.registerWithCorba();
        System.out.println("ContainerStatusMsg: ORB initialization ends");
        s_instance = this;
    }

    void initialize() throws AcsJContainerEx {
        try {
            Object dalObj = this.m_managerProxy.get_service("CDB", false);
            this.sharedCdbRef = DALHelper.narrow((Object)dalObj);
        }
        catch (Exception ex) {
            this.m_logger.log(Level.SEVERE, "Failed to access the CDB.", (Throwable)ex);
            throw new AcsJContainerEx((Throwable)ex);
        }
        if (this.sharedCdbRef == null) {
            this.m_logger.log(Level.SEVERE, "Failed to access the CDB.");
            throw new AcsJContainerEx();
        }
        this.initFromCdb(true);
        System.out.println("ContainerStatusMsg: Manager access initialization begins");
        this.loginToManager(this.m_managerRetry);
        System.out.println("ContainerStatusMsg: Manager access initialization ends");
        this.logConfig = ClientLogManager.getAcsLogManager().getLogConfig();
        this.logConfig.setCDBLoggingConfigPath("MACI/Containers/" + this.m_containerName);
        this.logConfig.setCDB((DALOperations)this.sharedCdbRef);
        try {
            this.logConfig.initialize(false);
        }
        catch (LogConfigException ex) {
            this.m_logger.log(Level.FINE, "Failed to configure logging (default values will be used).", (Throwable)ex);
        }
        this.m_alarmContainerServices = new ContainerServicesImpl(this.m_managerProxy, this.sharedCdbRef, this.m_acsCorba.createPOAForComponent("alarmSystem"), this.m_acsCorba, this.m_logger, 0, this.m_containerName, null, this.containerThreadFactory){
            private AcsLogger alarmLogger;

            @Override
            public AcsLogger getLogger() {
                if (this.alarmLogger == null) {
                    this.alarmLogger = ClientLogManager.getAcsLogManager().getLoggerForContainer(this.getName());
                }
                return this.alarmLogger;
            }
        };
        try {
            ACSAlarmSystemInterfaceFactory.init((ContainerServicesBase)this.m_alarmContainerServices);
        }
        catch (Throwable thr) {
            AcsJContainerEx ex = new AcsJContainerEx(thr);
            ex.setContextInfo("Error initializing the alarm system factory");
            throw ex;
        }
        ClientLogManager.LogAlarmHandler logAlarmHandler = new ClientLogManager.LogAlarmHandler(){

            public void raiseAlarm(String faultFamily, String faultMember, int faultCode) throws AcsJCouldntPerformActionEx {
                AcsContainer.this.m_alarmContainerServices.getAlarmSource().raiseAlarm(faultFamily, faultMember, faultCode);
            }

            public void clearAlarm(String faultFamily, String faultMember, int faultCode) throws AcsJCouldntPerformActionEx {
                AcsContainer.this.m_alarmContainerServices.getAlarmSource().clearAlarm(faultFamily, faultMember, faultCode);
            }
        };
        ClientLogManager.getAcsLogManager().enableLoggingAlarms(logAlarmHandler);
        try {
            Class<?> clazz = Class.forName("alma.ACS.jbaci.BACIFramework");
            java.lang.Object baciFramework = clazz.getField("INSTANCE").get(null);
            clazz.getMethod("initialize", ThreadFactory.class).invoke(baciFramework, this.containerThreadFactory);
        }
        catch (Exception e) {
            AcsJContainerEx ex = new AcsJContainerEx((Throwable)e);
            ex.setContextInfo("Error initializing the BACI framework");
            this.m_logger.log((Level)AcsLogLevel.WARNING, "Error initializing the BACI framework, container will run withouth the BACI Framework initialized", (Throwable)ex);
        }
        this.containerStartOrbThreadGate.countDown();
    }

    protected void initFromCdb(boolean isContainerStart) {
        alma.maci.containerconfig.Container containerConfig = null;
        boolean isDefaultConfig = false;
        String cdbPath = "MACI/Containers/" + this.m_containerName;
        try {
            String xml = this.sharedCdbRef.get_DAO(cdbPath);
            containerConfig = alma.maci.containerconfig.Container.unmarshalContainer((Reader)new StringReader(xml));
        }
        catch (Exception ex) {
            containerConfig = new alma.maci.containerconfig.Container();
            this.m_logger.warning("Failed to access container configuration data in the CDB. Will use XSD defaults.");
            isDefaultConfig = true;
        }
        double timeoutSeconds = containerConfig.getTimeout();
        try {
            this.m_acsCorba.setORBLevelRoundtripTimeout(timeoutSeconds);
        }
        catch (Exception ex) {
            this.m_logger.log(Level.WARNING, "No CDB timeout applied to the container.", (Throwable)ex);
        }
        if (!isDefaultConfig && containerConfig.getImplLang() != ContainerImplLangType.JAVA) {
            this.m_logger.warning("Bad CDB configuration for '" + cdbPath + "'. Should be ImplLang==java.");
        }
        if (this.recoveryModeOverride != null) {
            this.useRecoveryMode = this.recoveryModeOverride;
            this.m_logger.fine("Component recovery = '" + this.useRecoveryMode + "' (from local setting overriding CDB/XSD)");
        } else {
            this.useRecoveryMode = containerConfig.getRecovery();
            this.m_logger.fine("Component recovery = '" + this.useRecoveryMode + "' (from CDB/XSD)");
        }
        this.m_managerRetry = containerConfig.getManagerRetry();
    }

    void setRecoveryModeOverride(Boolean recoveryModeOverride) {
        this.recoveryModeOverride = recoveryModeOverride;
    }

    private void registerWithCorba() throws AcsJContainerEx {
        Object obj = this.m_acsCorba.activateContainer(this, this.m_containerName);
        if (obj == null) {
            AcsJContainerEx ex = new AcsJContainerEx();
            ex.setContextInfo("failed to register this AcsContainer with the ORB.");
            throw ex;
        }
        try {
            Container container = ContainerHelper.narrow((Object)obj);
            if (container == null) {
                throw new NullPointerException("Container CORBA-narrow returned a null.");
            }
        }
        catch (Throwable thr) {
            AcsJContainerEx ex = new AcsJContainerEx();
            ex.setContextInfo("failed to narrow the AcsContainer to CORBA type Container.");
            throw ex;
        }
        this.m_logger.finer("AcsContainer successfully registered with the ORB as a Container");
    }

    protected void loginToManager(int attempts) throws AcsJContainerEx {
        this.m_managerProxy.loginToManager((Client)this.m_acsCorba.getContainerCorbaRef(this), attempts);
    }

    public int get_handle() {
        return this.m_managerProxy.getManagerHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentInfo activate_component(int componentHandle, long execution_id, String compName, String exe, String type) throws CannotActivateComponentEx {
        if (this.shuttingDown.get()) {
            String msg = "activate_component() rejected because of container shutdown.";
            this.m_logger.fine(msg);
            AcsJCannotActivateComponentEx ex = new AcsJCannotActivateComponentEx();
            ex.setCURL(compName);
            ex.setDetailedReason(msg);
            throw ex.toCannotActivateComponentEx();
        }
        ComponentInfo componentInfo = null;
        StopWatch activationWatch = new StopWatch((Logger)this.m_logger);
        this.m_logger.finer("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        this.m_logger.fine("activate_component: handle=" + componentHandle + " name=" + compName + " helperClass=" + exe + " type=" + type);
        boolean contInitWaitSuccess = false;
        try {
            contInitWaitSuccess = this.containerStartOrbThreadGate.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!contInitWaitSuccess) {
            String msg = "Activation of component " + compName + " timed out after 30 s waiting for the container to finish its initialization.";
            this.m_logger.warning(msg);
            AcsJCannotActivateComponentEx ex = new AcsJCannotActivateComponentEx();
            ex.setCURL(compName);
            ex.setDetailedReason(msg);
            throw ex.toCannotActivateComponentEx();
        }
        ComponentAdapter compAdapter = null;
        try {
            ComponentMap ex = this.m_activeComponentMap;
            synchronized (ex) {
                block32: {
                    ComponentAdapter existingCompAdapter = this.getExistingComponent(componentHandle, compName, type);
                    if (existingCompAdapter == null) break block32;
                    ComponentInfo componentInfo2 = existingCompAdapter.getComponentInfo();
                    return componentInfo2;
                }
                if (!this.m_activeComponentMap.reserveComponent(componentHandle)) {
                    AcsJContainerEx ex2 = new AcsJContainerEx();
                    ex2.setContextInfo("Component with handle '" + componentHandle + "' is already being activated by this container. Manager should have prevented double activation.");
                    throw ex2;
                }
            }
            ClassLoader compCL = null;
            String compJarDirs = System.getProperty("acs.components.classpath.jardirs");
            compCL = compJarDirs != null ? new AcsComponentClassLoader(Thread.currentThread().getContextClassLoader(), (Logger)this.m_logger, compName) : Thread.currentThread().getContextClassLoader();
            ComponentHelper compHelper = this.createComponentHelper(compName, exe, compCL);
            StopWatch compStopWatch = new StopWatch();
            ComponentLifecycle compImpl = compHelper.getComponentImpl();
            LOG_CompAct_Instance_OK.log((Logger)this.m_logger, (String)compName, (long)compStopWatch.getLapTimeMillis());
            Class<? extends ACSComponentOperations> operationsIFClass = compHelper.getOperationsInterface();
            Constructor<? extends Servant> poaTieCtor = compHelper.getPOATieClass().getConstructor(operationsIFClass);
            java.lang.Object operationsIFImpl = null;
            if (operationsIFClass.isInstance(compImpl)) {
                this.m_logger.finer("component " + compName + " implements operations interface directly; no dynamic translator proxy used.");
                operationsIFImpl = compImpl;
            } else {
                this.m_logger.finer("creating dynamic proxy to map corba interface calls to component " + compName + ".");
                operationsIFImpl = compHelper.getInterfaceTranslator();
                if (!Proxy.isProxyClass(operationsIFImpl.getClass()) && !(operationsIFImpl instanceof ExternalInterfaceTranslator)) {
                    this.m_logger.log((Level)AcsLogLevel.NOTICE, "interface translator proxy for component " + compName + " isn't the default one, and doesn't expose the default as one either. This may cause problem when invoking xml-aware offshoot getters");
                }
            }
            String[] methodsExcludedFromInvocationLogging = compHelper.getComponentMethodsExcludedFromInvocationLogging();
            ACSComponentOperations poaDelegate = ContainerSealant.createContainerSealant(operationsIFClass, operationsIFImpl, compName, false, (Logger)this.m_logger, compCL, methodsExcludedFromInvocationLogging);
            Servant servant = null;
            try {
                servant = poaTieCtor.newInstance(poaDelegate);
            }
            catch (Throwable thr) {
                AcsJContainerEx ex3 = new AcsJContainerEx(thr);
                ex3.setContextInfo("failed to instantiate the servant object for component " + compName + " of type " + compImpl.getClass().getName());
                throw ex3;
            }
            compAdapter = new ComponentAdapter(compName, type, exe, componentHandle, this.m_containerName, compImpl, this.m_managerProxy, this.sharedCdbRef, compCL, this.m_logger, this.m_acsCorba);
            if (!operationsIFClass.isInstance(compImpl)) {
                if (operationsIFImpl instanceof ExternalInterfaceTranslator) {
                    operationsIFImpl = ((ExternalInterfaceTranslator)operationsIFImpl).getDefaultInterfaceTranslator();
                }
                compAdapter.setComponentXmlTranslatorProxy(operationsIFImpl);
            }
            compAdapter.setMethodsExcludedFromInvocationLogging(methodsExcludedFromInvocationLogging);
            compStopWatch.reset();
            compAdapter.activateComponent(servant);
            LOG_CompAct_Corba_OK.log((Logger)this.m_logger, (String)compName, (long)compStopWatch.getLapTimeMillis());
            if (compHelper.requiresOrbCentralLogSuppression()) {
                ClientLogManager.getAcsLogManager().suppressCorbaRemoteLogging();
            }
            this.m_logger.fine("about to initialize component " + compName);
            compStopWatch.reset();
            compAdapter.initializeComponent();
            compAdapter.executeComponent();
            LOG_CompAct_Init_OK.log((Logger)this.m_logger, (String)compName, (long)compStopWatch.getLapTimeMillis());
            this.m_activeComponentMap.put(componentHandle, compAdapter);
            long activTime = activationWatch.getLapTimeMillis();
            this.m_logger.info("component " + compName + " activated and initialized in " + activTime + " ms.");
            componentInfo = compAdapter.getComponentInfo();
            try {
                String componentsCdbPath = "MACI/Components";
                DAO myDao = null;
                try {
                    myDao = this.sharedCdbRef.get_DAO_Servant(componentsCdbPath + "/" + compName);
                }
                catch (CDBRecordDoesNotExistEx e) {
                    myDao = this.sharedCdbRef.get_DAO_Servant(componentsCdbPath + "/*");
                    String ctype = myDao.get_string("Type");
                    int i = 1;
                    while (ctype.compareTo(type) != 0) {
                        myDao = this.sharedCdbRef.get_DAO_Servant(componentsCdbPath + "/*" + i);
                        ctype = myDao.get_string("Type");
                        ++i;
                    }
                }
                String keepAlive = myDao.get_string("KeepAliveTime");
                this.m_logger.info("Component '" + compName + "' has KeepAliveTime '" + keepAlive + "'.");
            }
            catch (CDBFieldDoesNotExistEx e) {
                this.m_logger.info("Component '" + compName + "' doesn't have any KeepAliveTime configuration associated with it.");
            }
            catch (CDBRecordDoesNotExistEx e) {
                this.m_logger.info("Component '" + compName + "' doesn't have any KeepAliveTime configuration associated with it.");
            }
        }
        catch (Throwable thr) {
            this.m_logger.log(Level.SEVERE, "Failed to activate component " + compName + ", problem was: ", thr);
            if (compAdapter != null) {
                try {
                    compAdapter.deactivateComponent();
                }
                catch (Exception ex) {
                    this.m_logger.log(Level.FINE, ex.getMessage(), (Throwable)ex);
                }
            }
            this.m_activeComponentMap.remove(componentHandle);
            AcsJCannotActivateComponentEx ex = new AcsJCannotActivateComponentEx(thr);
            throw ex.toCannotActivateComponentEx();
        }
        finally {
            this.m_logger.finer(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
        return componentInfo;
    }

    public void activate_component_async(final int h, final long execution_id, final String name, final String exe, final String type, final CBComponentInfo callback, final CBDescIn desc) {
        this.m_logger.finer("activate_component_async request received for '" + name + "', enqueueing (taskCount: " + this.threadPoolExecutor.getTaskCount() + ", active threads: " + this.threadPoolExecutor.getActiveCount() + ", maxPoolSize: " + this.threadPoolExecutor.getMaximumPoolSize() + ").");
        this.threadPoolExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ComponentInfo dummyComponentInfo;
                AcsContainer.this.m_logger.finer("activate_component_async request for '" + name + "' is being processed now.");
                CBDescOut descOut = new CBDescOut(0L, desc.id_tag);
                ComponentInfo componentInfo = null;
                try {
                    componentInfo = AcsContainer.this.activate_component(h, execution_id, name, exe, type);
                }
                catch (CannotActivateComponentEx ae) {
                    AcsJCannotActivateComponentEx aae = AcsJCannotActivateComponentEx.fromCannotActivateComponentEx((CannotActivateComponentEx)ae);
                    dummyComponentInfo = new ComponentInfo(type, exe, null, name, new int[0], 0, AcsContainer.this.m_containerName, h, 0, new String[0]);
                    callback.done(dummyComponentInfo, aae.toAcsJCompletion().toCorbaCompletion(), descOut);
                }
                catch (Throwable th) {
                    AcsJUnknownEx ae = new AcsJUnknownEx(th);
                    dummyComponentInfo = new ComponentInfo(type, exe, null, name, new int[0], 0, AcsContainer.this.m_containerName, h, 0, new String[0]);
                    callback.done(dummyComponentInfo, ae.toAcsJCompletion().toCorbaCompletion(), descOut);
                }
                int retry = 0;
                boolean notified = false;
                while (retry < 3 && !notified) {
                    try {
                        AcsContainer.this.m_logger.log((Level)AcsLogLevel.DELOUSE, "Calling maci::CBComponentInfo::done with descOut.id_tag = %d." + descOut.id_tag + " for '" + name + "'");
                        callback.done(componentInfo, new ACSErrOKAcsJCompletion().toCorbaCompletion(), descOut);
                        notified = true;
                        AcsContainer.this.m_logger.log((Level)AcsLogLevel.DELOUSE, "Call to maci::CBComponentInfo::done with descOut.id_tag = %d." + descOut.id_tag + " for '" + name + "' completed");
                    }
                    catch (Throwable t) {
                        ++retry;
                        AcsContainer.this.m_logger.log((Level)AcsLogLevel.DELOUSE, "Call to maci::CBComponentInfo::done with descOut.id_tag = %d." + descOut.id_tag + " for '" + name + "' failed, retrying...", t);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (!notified) {
                    AcsContainer.this.m_logger.log((Level)AcsLogLevel.ERROR, "Call to maci::CBComponentInfo::done with descOut.id_tag = %d." + descOut.id_tag + " for '" + name + "' failed, deactivating the component.");
                    try {
                        AcsContainer.this.deactivate_component(h);
                    }
                    catch (ComponentDeactivationUncleanEx e) {
                        AcsContainer.this.m_logger.log((Level)AcsLogLevel.WARNING, "UNclean deactivation of component descOut.id_tag = %d." + descOut.id_tag + " for '" + name + "'", (Throwable)e);
                    }
                    catch (ComponentDeactivationFailedEx e) {
                        AcsContainer.this.m_logger.log((Level)AcsLogLevel.WARNING, "Deactivation of component failed descOut.id_tag = %d." + descOut.id_tag + " for '" + name + "'", (Throwable)e);
                    }
                    catch (Throwable t) {
                        AcsContainer.this.m_logger.log((Level)AcsLogLevel.WARNING, "Deactivation of component failed descOut.id_tag = %d." + descOut.id_tag + " for '" + name + "'", t);
                    }
                }
            }
        });
    }

    private ComponentAdapter getExistingComponent(int componentHandle, String name, String type) {
        ComponentAdapter existingCompAdapter = this.m_activeComponentMap.get(componentHandle);
        if (existingCompAdapter != null) {
            String msg = "component with handle " + componentHandle + " ('" + name + "') already activated";
            this.m_logger.warning(msg);
            if (existingCompAdapter.getName().equals(name) && existingCompAdapter.getType().equals(type)) {
                String msgReuse = "will reuse existing component " + name;
                this.m_logger.warning(msgReuse);
            } else {
                String msgMismatch = "component with handle " + componentHandle + ": name and/or type don't match between existing and requested component: existing(" + existingCompAdapter.getName() + ", " + existingCompAdapter.getType() + ") vs. requested(" + name + ", " + type + "). Will deactivate existing component and load the requested.";
                this.m_logger.warning(msgMismatch);
                try {
                    this.deactivate_component(componentHandle);
                }
                catch (Exception ex) {
                    this.m_logger.log(Level.FINE, "Failed to deactivate existing component with handle " + componentHandle);
                }
                existingCompAdapter = null;
            }
        } else {
            existingCompAdapter = this.m_activeComponentMap.getComponentByNameAndType(name, type);
            if (existingCompAdapter != null) {
                int orgHandle = existingCompAdapter.getHandle();
                String msg = "container refuses to activate component '" + name + "' (" + type + ") since another component with the same name and type has already been activated using a different handle (" + orgHandle + "). Will keep the original handle.";
                this.m_logger.warning(msg);
            }
        }
        return existingCompAdapter;
    }

    private ComponentHelper createComponentHelper(String compName, String exe, ClassLoader compCL) throws AcsJContainerEx {
        this.m_logger.finer("creating component helper instance of type '" + exe + "' using classloader " + compCL.getClass().getName());
        StopWatch sw = new StopWatch();
        Class<ComponentHelper> compHelperClass = null;
        try {
            compHelperClass = Class.forName(exe, true, compCL).asSubclass(ComponentHelper.class);
        }
        catch (ClassNotFoundException ex) {
            AcsJContainerEx ex2 = new AcsJContainerEx((Throwable)ex);
            ex2.setContextInfo("component helper class '" + exe + "' not found.");
            throw ex2;
        }
        catch (ClassCastException ex) {
            AcsJContainerEx ex2 = new AcsJContainerEx();
            ex2.setContextInfo("component helper class '" + exe + "' does not inherit from required base class " + ComponentHelper.class.getName());
            throw ex2;
        }
        LOG_CompAct_Loading_OK.log((Logger)this.m_logger, (String)compName, (long)sw.getLapTimeMillis());
        Constructor<ComponentHelper> helperCtor = null;
        ComponentHelper compHelper = null;
        try {
            helperCtor = compHelperClass.getConstructor(Logger.class);
        }
        catch (NoSuchMethodException ex) {
            String msg = "component helper class '" + exe + "' has no constructor  that takes a java.util.Logger";
            this.m_logger.fine(msg);
            AcsJContainerEx ex2 = new AcsJContainerEx((Throwable)ex);
            ex2.setContextInfo(msg);
            throw ex2;
        }
        try {
            compHelper = helperCtor.newInstance(this.m_logger);
        }
        catch (Throwable thr) {
            AcsJContainerEx ex = new AcsJContainerEx(thr);
            ex.setContextInfo("component helper class '" + exe + "' could not be instantiated");
            throw ex;
        }
        compHelper.setComponentInstanceName(compName);
        return compHelper;
    }

    public void set_component_shutdown_order(int[] handleSeq) {
        java.lang.Object handleSeqString = null;
        if (handleSeq == null) {
            handleSeqString = "null";
        } else {
            handleSeqString = "";
            for (int i = 0; i < handleSeq.length; ++i) {
                handleSeqString = (String)handleSeqString + handleSeq[i] + " ";
            }
            this.m_activeComponentMap.sort(handleSeq);
        }
        this.m_logger.fine("set_component_shutdown_order called. Handles: " + (String)handleSeqString);
    }

    public void deactivate_component(int handle) throws ComponentDeactivationUncleanEx, ComponentDeactivationFailedEx {
        this.m_logger.fine("received call to deactivate_component, handle=" + handle);
        ComponentAdapter[] compAdapters = this.m_activeComponentMap.getComponentAdapters(new int[]{handle});
        ComponentAdapter[] validAdapters = this.markAndFilterForDeactivation(compAdapters);
        if (validAdapters.length <= 1 && validAdapters.length != 0) {
            ComponentAdapter compAdapter = validAdapters[0];
            try {
                this.deactivateComponentInternal(compAdapter);
            }
            catch (AcsJComponentDeactivationUncleanEx ex) {
                throw ex.toComponentDeactivationUncleanEx();
            }
            catch (AcsJComponentDeactivationFailedEx ex) {
                throw ex.toComponentDeactivationFailedEx();
            }
        }
    }

    private void deactivateAllComponents() {
        ComponentAdapter[] validAdapters;
        ComponentAdapter[] compAdapters = this.m_activeComponentMap.getAllComponentAdapters();
        for (ComponentAdapter compAdapter : validAdapters = this.markAndFilterForDeactivation(compAdapters)) {
            try {
                this.deactivateComponentInternal(compAdapter);
            }
            catch (Exception ex) {
                this.m_logger.log(Level.INFO, "failed to properly deactivate component " + compAdapter.getName(), (Throwable)ex);
            }
        }
    }

    private void deactivateComponentInternal(ComponentAdapter compAdapter) throws AcsJComponentDeactivationUncleanEx, AcsJComponentDeactivationFailedEx {
        try {
            compAdapter.deactivateComponent();
        }
        finally {
            this.m_activeComponentMap.remove(compAdapter.getHandle());
        }
    }

    private synchronized ComponentAdapter[] markAndFilterForDeactivation(ComponentAdapter[] compAdapters) {
        ArrayList<ComponentAdapter> adaptersForDestruction = new ArrayList<ComponentAdapter>();
        for (int i = 0; i < compAdapters.length; ++i) {
            try {
                ComponentAdapter compAdapter = compAdapters[i];
                ComponentStates state = compAdapter.getComponentStateManager().getCurrentState();
                if (state == ComponentStates.COMPSTATE_DESTROYING || state == ComponentStates.COMPSTATE_ABORTING || state == ComponentStates.COMPSTATE_DEFUNCT) {
                    this.m_logger.fine("coming too late to deactivate component " + compAdapter.getName());
                    continue;
                }
                compAdapter.getComponentStateManager().setStateByContainer(ComponentStates.COMPSTATE_DESTROYING);
                adaptersForDestruction.add(compAdapter);
                continue;
            }
            catch (Throwable thr) {
                this.m_logger.log(Level.WARNING, "something went wrong while marking components for destruction. Will continue.", thr);
            }
        }
        return adaptersForDestruction.toArray(new ComponentAdapter[adaptersForDestruction.size()]);
    }

    public Object restart_component(int compHandle) throws CannotRestartComponentEx {
        String curl = null;
        try {
            ComponentAdapter compAdapter = this.m_activeComponentMap.get(compHandle);
            if (compAdapter != null) {
                curl = compAdapter.getName();
            }
            this.m_logger.warning("method restart_component not yet implemented.");
            AcsJCannotRestartComponentEx ex = new AcsJCannotRestartComponentEx();
            ex.setCURL(curl);
            throw ex;
        }
        catch (AcsJCannotRestartComponentEx ex) {
            throw ex.toCannotRestartComponentEx();
        }
        catch (Throwable thr) {
            AcsJCannotRestartComponentEx ex = new AcsJCannotRestartComponentEx(thr);
            ex.setCURL(curl);
            throw ex.toCannotRestartComponentEx();
        }
    }

    public void shutdown(int encryptedAction) {
        this.shutdown(encryptedAction, true, true);
    }

    void shutdown(int encryptedAction, boolean gracefully, boolean isOrbThread) {
        int action = encryptedAction >> 8 & 0xFF;
        this.m_logger.info("received call to 'shutdown', action=" + action + " (encryptedAction=" + encryptedAction + "), gracefully=" + gracefully + ".");
        if (this.shuttingDown.getAndSet(true)) {
            this.m_logger.fine("call to shutdown() while shutting down will be ignored...");
            return;
        }
        this.m_managerProxy.shutdownNotify();
        this.threadPoolExecutor.shutdown();
        if (gracefully) {
            try {
                this.deactivateAllComponents();
            }
            catch (Exception ex) {
                this.m_logger.log(Level.WARNING, "Failed to deactivate components for graceful shutdown");
            }
        } else {
            this.abortAllComponents(3000L);
        }
        ACSAlarmSystemInterfaceFactory.done();
        try {
            Class<?> clazz = Class.forName("alma.ACS.jbaci.BACIFramework");
            java.lang.Object baciFramework = clazz.getField("INSTANCE").get(null);
            clazz.getMethod("shutdown", new Class[0]).invoke(baciFramework, new java.lang.Object[0]);
        }
        catch (Exception e) {
            this.m_logger.log(Level.WARNING, "Failed to graceful shutdown the BACI framework");
        }
        this.m_managerProxy.logoutFromManager();
        if (!this.isEmbedded) {
            ClientLogManager.getAcsLogManager().shutdown(gracefully);
            this.m_acsCorba.shutdownORB(gracefully, isOrbThread);
        }
        if (this.m_alarmContainerServices != null) {
            this.m_alarmContainerServices.cleanUp();
        }
        s_instance = null;
    }

    private synchronized void abortAllComponents(long maxWaitTimeMillis) {
        java.lang.Object msg;
        this.m_logger.info("will shut down all active components, thread=" + Thread.currentThread().getName());
        boolean didAbort = false;
        ComponentAdapter[] compAdapters = this.m_activeComponentMap.getAllComponentAdapters();
        int corePoolSize = compAdapters.length / 2 + 1;
        int maxThreadNumber = compAdapters.length + 1;
        int queueCapacity = compAdapters.length / 2 + 1;
        ArrayBlockingQueue<Runnable> execQueue = new ArrayBlockingQueue<Runnable>(queueCapacity);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maxThreadNumber, 60L, TimeUnit.SECONDS, execQueue, this.containerThreadFactory);
        for (int i = 0; i < compAdapters.length; ++i) {
            ComponentAdapter compAdapter = compAdapters[i];
            ComponentStates state = compAdapter.getComponentStateManager().getCurrentState();
            if (state == ComponentStates.COMPSTATE_ABORTING || state == ComponentStates.COMPSTATE_DEFUNCT) continue;
            didAbort = true;
            Runnable abortionist = compAdapter.getComponentAbortionist(false);
            try {
                executor.execute(abortionist);
                continue;
            }
            catch (RejectedExecutionException e) {
                System.err.println("failed to abort component '" + compAdapter.getName() + "' because of exception " + e.getMessage());
            }
        }
        executor.shutdown();
        boolean doneInTime = false;
        try {
            doneInTime = executor.awaitTermination(maxWaitTimeMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException compAdapter) {
            // empty catch block
        }
        if (didAbort) {
            msg = "done with aborting components ";
            msg = doneInTime ? (String)msg + "in time." : (String)msg + "(timed out).";
            this.m_logger.info((String)msg);
        } else {
            msg = "no components needed to be aborted.";
            this.m_logger.info((String)msg);
        }
    }

    public ComponentInfo[] get_component_info(int[] handles) {
        this.logManagerRequest("received call to get_component_info", handles);
        ArrayList<ComponentInfo> componentInfolist = new ArrayList<ComponentInfo>();
        ComponentAdapter[] adapters = null;
        adapters = handles != null && handles.length > 0 ? this.m_activeComponentMap.getComponentAdapters(handles) : this.m_activeComponentMap.getAllComponentAdapters();
        for (int i = 0; i < adapters.length; ++i) {
            ComponentAdapter adapter = adapters[i];
            componentInfolist.add(adapter.getComponentInfo());
        }
        ComponentInfo[] ret = componentInfolist.toArray(new ComponentInfo[0]);
        return ret;
    }

    public String name() {
        this.m_logger.fine("call to name() answered with '" + this.m_containerName + "'.");
        return this.m_containerName;
    }

    public void disconnect() {
        this.m_logger.warning("Manager requests logout...");
        this.m_managerProxy.logoutFromManager();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Runnable reloginRunnable = new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        AcsContainer.this.loginToManager(AcsContainer.this.m_managerRetry);
                    }
                    catch (Exception e) {
                        AcsContainer.this.m_logger.log(Level.WARNING, "Failed to re-login to the manager. Will shut down.", (Throwable)e);
                        if (AcsContainer.this.shuttingDown.get()) break block2;
                        AcsContainer.this.shutdown(512, true, false);
                    }
                }
            }
        };
        this.containerThreadFactory.newThread(reloginRunnable).start();
    }

    public AuthenticationData authenticate(long execution_id, String question) {
        String code = this.useRecoveryMode ? "AR" : "A";
        String answer = code + " " + this.m_containerName;
        if (this.executionId < 0L) {
            this.executionId = execution_id;
        }
        AuthenticationData ret = new AuthenticationData(answer, ClientType.CONTAINER_TYPE, ImplLangType.JAVA, this.useRecoveryMode, this.startTimeUTClong, this.executionId);
        return ret;
    }

    public void message(short type, String message) {
        if (type == 0) {
            this.m_logger.warning("Error message from the manager: " + message);
        } else if (type == 20) {
            this.m_logger.info("Info message from the manager: " + message);
        } else {
            this.m_logger.info("Message of unknown type from the manager: " + message);
        }
    }

    public void taggedmessage(short type, short messageID, String message) {
        if (messageID == 1) {
            System.out.println("ContainerStatusMsg: Automatic component loading begins");
        }
        if (type == 0) {
            this.m_logger.warning("Error message from the manager: " + message);
        } else if (type == 20) {
            this.m_logger.info("Info message from the manager: " + message);
        } else {
            this.m_logger.info("Message of unknown type from the manager: " + message);
        }
        if (messageID == 2) {
            System.out.println("ContainerStatusMsg: Automatic component loading ends");
            System.out.println("ContainerStatusMsg: Ready");
        }
    }

    public boolean ping() {
        AcsLogLevelDefinition stdoutLevel;
        try {
            stdoutLevel = AcsLogLevelDefinition.fromXsdLogLevel((LogLevel)this.logConfig.getNamedLoggerConfig(this.m_containerName).getMinLogLevelLocal());
        }
        catch (AcsJIllegalArgumentEx ex) {
            stdoutLevel = AcsLogLevelDefinition.DEBUG;
            ex.printStackTrace();
        }
        if (stdoutLevel.compareTo((Enum)AcsLogLevelDefinition.DEBUG) <= 0) {
            Runtime rt = Runtime.getRuntime();
            long totalMemKB = rt.totalMemory() / 1024L;
            long usedMemKB = totalMemKB - rt.freeMemory() / 1024L;
            String memStatus = "Memory usage " + usedMemKB + " of " + totalMemKB + " kB ";
            long maxMem = rt.maxMemory();
            if (maxMem < Long.MAX_VALUE) {
                long maxMemKB = maxMem / 1024L;
                memStatus = memStatus + "(= " + (double)(usedMemKB * 1000L / maxMemKB) / 10.0 + "% of JVM growth limit " + maxMemKB + " kB) ";
            }
            String timestamp = IsoDateFormat.formatCurrentDate();
            System.out.println(timestamp + " [" + this.m_containerName + "] ping received, container alive. " + memStatus);
        }
        return true;
    }

    public void components_available(ComponentInfo[] components) {
        if (components == null) {
            return;
        }
        StringBuffer buff = new StringBuffer("components_available: ");
        for (int i = 0; i < components.length; ++i) {
            buff.append(components[i].name).append(" ");
        }
        this.m_logger.fine(buff.toString());
        List<ComponentDescriptor> compDescs = ComponentDescriptor.fromComponentInfoArray(components);
        for (ComponentAdapter compAd : this.m_activeComponentMap.getAllComponentAdapters()) {
            compAd.getContainerServices().fireComponentsAvailable(compDescs);
        }
    }

    public void components_unavailable(String[] component_names) {
        if (component_names == null) {
            return;
        }
        StringBuffer buff = new StringBuffer("components_unavailable: ");
        for (int i = 0; i < component_names.length; ++i) {
            buff.append(component_names[i]).append(" ");
        }
        this.m_logger.fine(buff.toString());
        List<String> compNames = Arrays.asList(component_names);
        for (ComponentAdapter compAd : this.m_activeComponentMap.getAllComponentAdapters()) {
            compAd.getContainerServices().fireComponentsUnavailable(compNames);
        }
    }

    private void logManagerRequest(String msgBegin, int[] handles) {
        if (handles != null) {
            StringBuffer buff = new StringBuffer(msgBegin + "; handles = ");
            for (int i = 0; i < handles.length; ++i) {
                buff.append(handles[i]);
                ComponentAdapter compAdapter = this.m_activeComponentMap.get(handles[i]);
                if (compAdapter == null) {
                    buff.append("(unknown) ");
                    continue;
                }
                buff.append(' ');
            }
            this.m_logger.fine(buff.toString());
        } else {
            this.m_logger.fine(msgBegin);
        }
    }

    public LogLevels get_default_logLevels() {
        this.tryToWaitForContainerStart();
        LogLevels logLevels = new LogLevels();
        logLevels.useDefault = false;
        logLevels.minLogLevel = (short)this.logConfig.getDefaultMinLogLevel().value;
        logLevels.minLogLevelLocal = (short)this.logConfig.getDefaultMinLogLevelLocal().value;
        return logLevels;
    }

    public void set_default_logLevels(LogLevels levels) throws IllegalLogLevelsEx {
        this.tryToWaitForContainerStart();
        try {
            this.logConfig.setDefaultMinLogLevel(AcsLogLevelDefinition.fromInteger((int)levels.minLogLevel));
            this.logConfig.setDefaultMinLogLevelLocal(AcsLogLevelDefinition.fromInteger((int)levels.minLogLevelLocal));
        }
        catch (AcsJIllegalArgumentEx ex) {
            IllegalLogLevelsEx ille = new IllegalLogLevelsEx(ex.getErrorDesc());
            throw ille;
        }
    }

    public String[] get_logger_names() {
        this.tryToWaitForContainerStart();
        Set loggerNames = this.logConfig.getLoggerNames();
        return loggerNames.toArray(new String[loggerNames.size()]);
    }

    public LogLevels get_logLevels(String logger_name) throws LoggerDoesNotExistEx {
        this.tryToWaitForContainerStart();
        if (!this.logConfig.isKnownLogger(logger_name)) {
            throw new LoggerDoesNotExistEx();
        }
        LogConfig.LockableUnnamedLogger xsdLevels = this.logConfig.getNamedLoggerConfig(logger_name);
        boolean useDefault = !this.logConfig.hasCustomConfig(logger_name);
        LogLevels ret = AcsLogLevelDefinition.createIdlLogLevelsFromXsd((boolean)useDefault, (UnnamedLogger)xsdLevels);
        return ret;
    }

    public void set_logLevels(String logger_name, LogLevels levels) throws LoggerDoesNotExistEx, IllegalLogLevelsEx {
        this.tryToWaitForContainerStart();
        if (!this.logConfig.isKnownLogger(logger_name)) {
            throw new LoggerDoesNotExistEx();
        }
        if (levels.useDefault) {
            this.logConfig.clearNamedLoggerConfig(logger_name);
        } else {
            try {
                UnnamedLogger config = AcsLogLevelDefinition.createXsdLogLevelsFromIdl((LogLevels)levels);
                this.logConfig.setNamedLoggerConfig(logger_name, config);
            }
            catch (AcsJIllegalArgumentEx ex) {
                IllegalLogLevelsEx ille = new IllegalLogLevelsEx(ex.getErrorDesc());
                throw ille;
            }
        }
    }

    public void refresh_logging_config() {
        this.tryToWaitForContainerStart();
        try {
            this.logConfig.initialize(true);
        }
        catch (LogConfigException ex) {
            this.m_logger.log(Level.FINE, "Failed to configure logging (default values will be used).", (Throwable)ex);
        }
    }

    public LogStatsInformation[] get_statistics_logger_configuration() {
        this.tryToWaitForContainerStart();
        ArrayList<LogStatsInformation> statsInfoList = new ArrayList<LogStatsInformation>();
        Set loggerNames = this.logConfig.getLoggerNames();
        for (String name : loggerNames) {
            AcsLogger retrievedLogger = ClientLogManager.getAcsLogManager().getLoggerByName(name);
            statsInfoList.add(new LogStatsInformation(retrievedLogger.stats.getStatisticsIdentification(), retrievedLogger.getName(), retrievedLogger.stats.getDisableStatistics().booleanValue(), retrievedLogger.stats.getStatisticsCalculationPeriod(), retrievedLogger.stats.getStatisticsGranularity()));
        }
        LogStatsInformation[] statsInfoSeq = new LogStatsInformation[statsInfoList.size()];
        statsInfoSeq = statsInfoList.toArray(statsInfoSeq);
        return statsInfoSeq;
    }

    public LogStatsInformation get_statistics_logger_configuration_byname(String logger_name) throws LoggerDoesNotExistEx {
        AcsLogger retrievedLogger = ClientLogManager.getAcsLogManager().getLoggerByName(logger_name);
        if (retrievedLogger == null) {
            LoggerDoesNotExistEx inexistantLoggerEx = new LoggerDoesNotExistEx(logger_name);
            throw inexistantLoggerEx;
        }
        LogStatsInformation statsInfo = new LogStatsInformation(retrievedLogger.stats.getStatisticsIdentification(), retrievedLogger.getName(), retrievedLogger.stats.getDisableStatistics().booleanValue(), retrievedLogger.stats.getStatisticsCalculationPeriod(), retrievedLogger.stats.getStatisticsGranularity());
        return statsInfo;
    }

    public void set_statistics_logger_configuration_byname(String logger_name, LogStatsInformation statsInformation) throws LoggerDoesNotExistEx {
        AcsLogger retrievedLogger = ClientLogManager.getAcsLogManager().getLoggerByName(logger_name);
        if (retrievedLogger == null) {
            LoggerDoesNotExistEx inexistantLoggerEx = new LoggerDoesNotExistEx(logger_name);
            throw inexistantLoggerEx;
        }
        retrievedLogger.stats.configureStatistics(statsInformation.statsId, statsInformation.statsStatus, statsInformation.statsPeriodConfiguration, statsInformation.statsGranularityConfiguration);
    }

    protected void tryToWaitForContainerStart() {
        try {
            this.containerStartOrbThreadGate.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

