/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.component.dynwrapper;

import alma.acs.component.dynwrapper.ComponentInvocationHandler;
import alma.acs.component.dynwrapper.DynWrapperException;
import alma.acs.component.dynwrapper.TypeMapper;
import java.lang.reflect.Field;
import java.util.logging.Logger;

public class CompositionMapper
extends TypeMapper {
    public CompositionMapper(Object delegate, Logger logger) {
        super(delegate, logger);
    }

    public boolean canTranslate(Class oldObjClass, Class newObjClass, ComponentInvocationHandler invHandler) {
        boolean canTranslate = true;
        Field oldField = null;
        String fieldMismatchMsg = null;
        try {
            Field[] oldFields = oldObjClass.getFields();
            for (int i = 0; i < oldFields.length; ++i) {
                oldField = oldFields[i];
                Field newField = newObjClass.getField(oldField.getName());
                boolean canTranslateField = invHandler.canTranslate(oldField.getType(), newField.getType());
                if (canTranslateField) continue;
                canTranslate = false;
                break;
            }
        }
        catch (NoSuchFieldException e) {
            canTranslate = false;
            fieldMismatchMsg = "Member field '" + oldField.getName() + "' not found in " + newObjClass.getName() + ".";
        }
        if (this.m_verbose) {
            String msg = "can " + (canTranslate ? "" : "not ") + "translate from class '" + oldObjClass.getName() + "' to class '" + newObjClass.getName() + "'. ";
            if (fieldMismatchMsg != null) {
                msg = msg + fieldMismatchMsg;
            }
            this.m_logger.finer(msg);
        }
        return canTranslate;
    }

    @Override
    public <T> Object translate(Object oldObject, T newObjectTemplate, Class<T> newObjectClass, ComponentInvocationHandler invHandler) throws DynWrapperException {
        if (this.m_verbose) {
            this.m_logger.finer("will try to translate from '" + oldObject.getClass().getName() + "' to '" + newObjectClass.getName() + "'.");
        }
        if (newObjectTemplate == null) {
            try {
                newObjectTemplate = newObjectClass.newInstance();
            }
            catch (Exception e) {
                throw new DynWrapperException("failed to create composition class " + newObjectClass.getName());
            }
        }
        try {
            Field[] oldFields = oldObject.getClass().getFields();
            for (int i = 0; i < oldFields.length; ++i) {
                Field oldValueField = oldFields[i];
                Object oldValue = oldValueField.get(oldObject);
                Field newValueField = newObjectClass.getField(oldValueField.getName());
                Object newValueTemplate = newValueField.get(newObjectTemplate);
                Object newValue = null;
                if (oldValue == null) {
                    this.m_logger.warning("Field " + oldObject.getClass().getName() + "." + oldValueField.getName() + " is null. If this corresponds to a CORBA struct, the ORB will not transmit this data.");
                } else {
                    newValue = invHandler.translate(oldValue, newValueTemplate, newValueField.getType());
                }
                newValueField.set(newObjectTemplate, newValue);
            }
        }
        catch (Exception e) {
            throw new DynWrapperException(e);
        }
        if (this.m_verbose) {
            this.m_logger.finer("successfully translated from '" + oldObject.getClass().getName() + "' to '" + newObjectTemplate.getClass().getName() + "'.");
        }
        return newObjectTemplate;
    }
}

