/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.component.client;

import alma.acs.component.ComponentDescriptor;
import alma.acs.container.ContainerServicesImpl;
import alma.acs.util.UTCUtility;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import si.ijs.maci.AuthenticationData;
import si.ijs.maci.ClientPOA;
import si.ijs.maci.ClientType;
import si.ijs.maci.ComponentInfo;
import si.ijs.maci.ImplLangType;

class ManagerClient
extends ClientPOA {
    private final String m_clientName;
    private final Logger m_logger;
    private final long startTimeUTClong = UTCUtility.utcJavaToOmg((long)System.currentTimeMillis());
    private long executionId = -1L;
    private volatile ContainerServicesImpl containerServices;

    ManagerClient(String clientName, Logger logger) {
        this.m_clientName = clientName;
        this.m_logger = logger;
    }

    public void setContainerServices(ContainerServicesImpl containerServices) {
        this.containerServices = containerServices;
    }

    public AuthenticationData authenticate(long execution_id, String question) {
        if (this.executionId < 0L) {
            this.executionId = execution_id;
        }
        AuthenticationData ret = new AuthenticationData("C", ClientType.CLIENT_TYPE, ImplLangType.JAVA, false, this.startTimeUTClong, this.executionId);
        return ret;
    }

    public void components_available(ComponentInfo[] components) {
        if (this.containerServices != null) {
            List<ComponentDescriptor> compDescs = ComponentDescriptor.fromComponentInfoArray(components);
            this.containerServices.fireComponentsAvailable(compDescs);
        }
    }

    public void components_unavailable(String[] component_names) {
        if (this.containerServices != null) {
            List<String> compNames = Arrays.asList(component_names);
            this.containerServices.fireComponentsUnavailable(compNames);
        }
    }

    public void disconnect() {
        this.m_logger.info("disconnected from manager");
    }

    public void message(short type, String message) {
        this.m_logger.info("message: " + message);
    }

    public void taggedmessage(short type, short tag, String message) {
        this.m_logger.info("message: " + message);
    }

    public String name() {
        return this.m_clientName;
    }

    public boolean ping() {
        return true;
    }
}

