/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.registry.search;

import java.util.List;
import java.util.ListIterator;
import net.ivoa.registry.search.Metadata;
import org.w3c.dom.Element;

public class Capability
extends Metadata {
    private String captype = null;
    private String standardid = null;

    public Capability(Element el) {
        super(el);
    }

    Capability(Element el, String xsitype, String stdid) {
        super(el);
        this.captype = xsitype;
        this.standardid = stdid;
    }

    public String getCapabilityClass() {
        int c;
        if (this.captype != null) {
            return this.captype;
        }
        String out = ((Element)this.getDOMNode()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (out == null) {
            out = "Capability";
        }
        if ((c = out.indexOf(":")) >= 0) {
            out = out.substring(c + 1);
        }
        this.captype = out;
        return out;
    }

    public String getStandardID() {
        if (this.standardid != null) {
            return this.standardid;
        }
        this.standardid = ((Element)this.getDOMNode()).getAttribute("standardID");
        return this.standardid;
    }

    public Metadata getStandardInterface(String version) {
        if (version == null) {
            version = "1.0";
        }
        return this.getInterface("std", version);
    }

    public Metadata getInterface(String role, String version) {
        Metadata intf = null;
        List interfaces = this.findBlocks("interface");
        ListIterator iter = interfaces.listIterator();
        while (iter.hasNext()) {
            intf = (Metadata)iter.next();
            if (!role.equals(intf.getParameter("role")) || !version.equals(intf.getParameter("version"))) continue;
            return intf;
        }
        return null;
    }

    public String getStandardAccessURL(String version) {
        return this.getAccessURL("std", version);
    }

    public String getAccessURL(String role, String version) {
        Metadata intf = this.getInterface(role, version);
        return intf.getParameter("accessURL");
    }
}

