/*
 * Decompiled with CFR 0.152.
 */
package alma.alarmsystem.source;

import alma.acs.logging.AcsLogLevel;
import alma.acs.util.XmlNormalizer;
import alma.alarmsystem.source.ACSAlarmSystemInterface;
import alma.alarmsystem.source.ACSFaultState;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ACSAlarmSystemInterfaceProxy
implements ACSAlarmSystemInterface {
    private Logger m_logger;
    String name;

    public ACSAlarmSystemInterfaceProxy(String name, Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("Invalid null logger in constructor");
        }
        this.name = name;
        this.m_logger = logger;
        this.m_logger.fine("Alarm source of " + name + " connected to the logging");
    }

    @Override
    public void setSourceName(String newSourceName) {
        this.name = newSourceName;
    }

    @Override
    public String getSourceName() {
        return this.name;
    }

    @Override
    public void close() {
    }

    @Override
    public void push(ACSFaultState state) {
        this.logFaultState(state);
    }

    @Override
    public void push(Collection<ACSFaultState> states) {
        if (states == null || states.size() == 0) {
            return;
        }
        for (ACSFaultState acsFaultState : states) {
            this.push(acsFaultState);
        }
    }

    @Override
    public void pushActiveList(Collection<ACSFaultState> active) {
        if (active == null || active.size() == 0) {
            return;
        }
        this.push(active);
    }

    private void logFaultState(ACSFaultState fs) {
        if (fs == null) {
            return;
        }
        StringBuilder sb = new StringBuilder("Alarm sent: <");
        sb.append(fs.getFamily() + "," + fs.getMember() + "," + fs.getCode() + ">");
        sb.append(" " + fs.getDescriptor());
        this.m_logger.log((Level)AcsLogLevel.ALERT, XmlNormalizer.normalize((String)sb.toString()));
    }
}

