/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.plug;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;

public class DefaultCORBAService
implements Runnable {
    private ORB orb = null;
    private volatile boolean destroyState = false;
    private POA rootPOA = null;
    private Logger logger = null;

    public DefaultCORBAService(Logger logger) {
        this.logger = logger;
        this.internalInitialize();
    }

    private void internalInitialize() {
        Properties orbprops = System.getProperties();
        Properties serviceConfig = new Properties();
        serviceConfig.put("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        serviceConfig.put("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
        serviceConfig.put("jacorb.implname", "ORB");
        serviceConfig.put("jacorb.orb.objectKeyMap.Manager", "ORB/ManagerPOA/Manager");
        serviceConfig.put("jacorb.verbosity", "1");
        serviceConfig.put("org.omg.PortableInterceptor.ORBInitializerClass.bidir_init", "org.jacorb.orb.giop.BiDirConnectionInitializer");
        if (serviceConfig != null) {
            orbprops.putAll((Map<?, ?>)serviceConfig);
        }
        this.orb = ORB.init((String[])new String[0], (Properties)orbprops);
        try {
            this.rootPOA = POAHelper.narrow((Object)this.orb.resolve_initial_references("RootPOA"));
            POAManager manager = this.rootPOA.the_POAManager();
            manager.activate();
        }
        catch (Throwable th) {
            this.logger.log(Level.SEVERE, "Failed to initialize CORBA.", th);
        }
        new Thread((Runnable)this, "DefaultCORBAService").start();
    }

    public void destroy() {
        this.destroyState = true;
        if (this.orb != null) {
            try {
                this.orb.shutdown(false);
                this.orb.destroy();
                this.orb = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public ORB getORB() {
        return this.orb;
    }

    public POA getRootPOA() {
        return this.rootPOA;
    }

    @Override
    public void run() {
        ORB localORBRef = this.orb;
        if (!this.destroyState && localORBRef != null) {
            localORBRef.run();
        }
    }
}

