/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.manager.gui;

import alma.acs.logging.formatters.ConsoleLogFormatter;
import com.cosylab.acs.maci.manager.ManagerShutdown;
import com.cosylab.acs.maci.manager.app.ManagerEngine;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class Manager
extends JFrame
implements ManagerShutdown {
    private static final long serialVersionUID = -1120227545786082722L;
    private ManagerEngine engine;
    private boolean shuttingDown = false;
    public static final int GUI_UPDATE_INTERVAL = 250;
    private JProgressBar progressBar;
    private Timer guiUpdaterTimer;
    private Color defaultProgressBarColor;

    public Manager() {
        this.initialize();
    }

    public ManagerEngine getManagerEngine() {
        if (this.engine == null) {
            this.engine = new ManagerEngine(this);
        }
        return this.engine;
    }

    protected void initialize() {
        this.getManagerEngine().initialize();
        this.initializeGUI();
        LogRecord record = new LogRecord(Level.INFO, "AcsManagerStatusMessage_ManagerStarted Manager Application initialized.");
        record.setLoggerName(this.getManagerEngine().getLogger().getName());
        String formattedString = new ConsoleLogFormatter().format(record);
        System.out.println(formattedString);
    }

    public void initializeGUI() {
        this.setSize(320, 200);
        this.setLayout(new GridBagLayout());
        this.setTitle("ACS Manager");
        this.add((Component)this.getRequestsProgressBar(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(40, 40, 40, 40), 0, 0));
        this.guiUpdaterTimer = new Timer(250, new GUIUpdater());
        this.guiUpdaterTimer.start();
        this.setLocationByPlatform(true);
        this.setVisible(true);
        this.toFront();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent event) {
            }

            @Override
            public void windowClosed(WindowEvent event) {
            }

            @Override
            public void windowClosing(WindowEvent event) {
                Manager.this.destroy();
            }

            @Override
            public void windowDeactivated(WindowEvent event) {
            }

            @Override
            public void windowDeiconified(WindowEvent event) {
            }

            @Override
            public void windowIconified(WindowEvent event) {
            }

            @Override
            public void windowOpened(WindowEvent event) {
            }
        });
    }

    @Override
    public boolean isShutdownInProgress() {
        return this.shuttingDown;
    }

    @Override
    public void shutdown(boolean sigInt) {
        if (!this.shuttingDown) {
            this.destroy();
        }
    }

    public void destroy() {
        this.shuttingDown = true;
        if (this.guiUpdaterTimer != null) {
            this.guiUpdaterTimer.stop();
        }
        this.dispose();
        this.getManagerEngine().destroy();
    }

    public JProgressBar getRequestsProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar(0, 8);
            this.defaultProgressBarColor = this.progressBar.getForeground();
            this.progressBar.setStringPainted(true);
            this.progressBar.setString("0 requests pending");
        }
        return this.progressBar;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-n") && !args[i].equals("-nr")) continue;
            System.getProperties().put("Manager.recovery", "false");
        }
        new Manager();
    }

    class GUIUpdater
    implements ActionListener {
        private static final String requestsPending = " request(s) pending";

        GUIUpdater() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ManagerEngine engine = Manager.this.getManagerEngine();
            JProgressBar progressBar = Manager.this.getRequestsProgressBar();
            int requests = engine.getNumberOfPendingRequests();
            if (requests != progressBar.getValue()) {
                if (requests < progressBar.getMaximum() / 2) {
                    progressBar.setForeground(Manager.this.defaultProgressBarColor);
                } else if (requests < progressBar.getMaximum()) {
                    progressBar.setForeground(Color.yellow);
                } else {
                    progressBar.setForeground(Color.red);
                }
                progressBar.setValue(requests);
                progressBar.setString(String.valueOf(requests) + requestsPending);
            }
        }
    }
}

