/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.client;

import com.cosylab.util.FileHelper;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class XmlSchemaStructSorter {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("ERROR: must give at least 2 parameters");
            XmlSchemaStructSorter.printHelp();
            return;
        }
        String sourceDir = args[0];
        String targetDir = args[1];
        File sourceDirFile = new File(sourceDir);
        File targetDirFile = new File(targetDir);
        if (!sourceDirFile.exists()) {
            System.out.println("ERROR: source directory does not exist.");
            return;
        }
        if (!targetDirFile.exists()) {
            System.out.println("ERROR: target directory does not exist.");
            return;
        }
        SAXBuilder builder = new SAXBuilder();
        File[] sourceFiles = sourceDirFile.listFiles();
        int fileCount = 0;
        for (int i = 0; i < sourceFiles.length; ++i) {
            String path = null;
            try {
                path = sourceFiles[i].getCanonicalPath();
            }
            catch (IOException e) {
                System.out.println("ERROR: could not read input file " + sourceFiles[i].getName() + " in directory " + sourceDir + "\n" + e);
                return;
            }
            if (!sourceFiles[i].getName().endsWith(".xsd")) continue;
            ++fileCount;
            Document doc = null;
            try {
                doc = builder.build(sourceFiles[i]);
            }
            catch (JDOMException e) {
                System.out.println("ERROR: XML parsing exception in file " + path + "\n" + e);
                return;
            }
            catch (IOException e) {
                System.out.println("ERROR: could not read file: " + path + "\n" + e);
                return;
            }
            Object nsDir = doc.getRootElement().getAttributeValue("targetNamespace");
            if (nsDir == null) {
                System.out.println("ERROR: targetNamespace not defined in file " + path);
                return;
            }
            if (((String)nsDir).startsWith("http://")) {
                nsDir = ((String)nsDir).substring(7);
            }
            try {
                nsDir = ((String)nsDir).substring(0, ((String)nsDir).lastIndexOf(47));
            }
            catch (Exception e) {
                System.out.println("ERROR: targetNamespace does not contain '/' in file " + path);
                return;
            }
            String schemaVersion = doc.getRootElement().getAttributeValue("version");
            if (schemaVersion == null) {
                System.out.println("ERROR: version not defined in file " + path);
                return;
            }
            if (schemaVersion.indexOf(32) == -1) {
                System.out.println("WARNING: document " + path + " does not contain 2 part version attribute (separated by ' '). Continuing...");
            } else {
                schemaVersion = schemaVersion.substring(0, schemaVersion.indexOf(32));
            }
            nsDir = (String)nsDir + "/" + schemaVersion;
            File nsDirFile = new File(targetDir + File.separator + (String)nsDir);
            if (!nsDirFile.exists()) {
                String nsPath = null;
                try {
                    nsPath = nsDirFile.getCanonicalPath();
                }
                catch (IOException e) {
                    System.out.println("ERROR: could not read directory " + targetDir + File.separator + (String)nsDir + "\n" + e);
                    return;
                }
                System.out.println("Creating directory " + nsPath);
                if (!nsDirFile.mkdirs()) {
                    System.out.println("ERROR: could not create directory " + nsPath);
                    return;
                }
            }
            try {
                FileHelper.copy((File)sourceFiles[i], (File)new File(targetDir + File.separator + (String)nsDir + File.separator + sourceFiles[i].getName()), (boolean)false);
                continue;
            }
            catch (IOException e) {
                System.out.println("ERROR: could not copy file " + path + " to " + targetDir + File.separator + (String)nsDir + "\n" + e);
                return;
            }
        }
    }

    private static void printHelp() {
        System.out.println("USAGE: archiveSchemaSort inDir outDir");
        System.out.println("Sorts schemas from inDir into a newly created directory structure under outDir.");
        System.out.println("Each schema under inDir is copied into a substructure corresponding to it's targetNamespace attribute value.");
    }
}

