/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.client;

import alma.acs.container.archive.Range;
import alma.archive.database.helpers.DatabaseHelper;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.database.oracle.DatabaseConnectionPool;
import alma.archive.database.oracle.DatabaseWriter;
import alma.archive.database.oracle.IdentifierArchive;
import alma.archive.database.oracle.InternalIfImpl;
import alma.archive.database.oracle.SchemaManagerImpl;
import alma.archive.wrappers.ArchiveTimeStamp;
import alma.archive.wrappers.Permissions;
import java.io.File;
import java.net.URI;
import java.sql.Connection;
import java.util.logging.Logger;
import oracle.jdbc.OraclePreparedStatement;
import oracle.xdb.XMLType;

public class FileInserter {
    public static void main(String[] args) throws Exception {
        URI schemaURI;
        if (args.length < 2) {
            FileInserter.printHelp();
            return;
        }
        InternalIfImpl database = InternalIfImpl.instance(Logger.getAnonymousLogger());
        DatabaseWriter dbWriter = database.getWriter();
        IdentifierArchive ident = database.getIdentifierArchive();
        Range range = new Range(ident.getNewRange());
        SchemaManagerImpl manager = new SchemaManagerImpl(dbWriter, database.getReader(), database.getCache());
        if (args[0].equalsIgnoreCase("-xslt")) {
            FileInserter.insertXSLT(args, range, manager, database.getConnectionPool());
            return;
        }
        URI docUri = range.next();
        try {
            schemaURI = manager.getSchemaURI(args[1]);
        }
        catch (Exception e) {
            System.out.println("ERROR: (Simple file insert) Could not find schema " + args[1] + " in Archive");
            return;
        }
        dbWriter.put(docUri, new ArchiveTimeStamp(), DatabaseHelper.readFile(args[0]), schemaURI, args[1], "commandLineInsert", new Permissions(), "commandLineInsert", true, true);
        System.out.println("Successfully stored document under UID " + docUri);
    }

    private static void insertXSLT(String[] args, Range range, SchemaManager manager, DatabaseConnectionPool ocpds) {
        Connection readConn;
        try {
            readConn = ocpds.getConnection();
        }
        catch (Exception e) {
            System.out.println("Problem in creating database connection: ");
            System.out.println(e.toString());
            System.out.println("Problem in creating database connection. Check Oracle system and archiveConfig.properties.");
            return;
        }
        File file = new File(args[1]);
        if (file.isDirectory()) {
            File[] allFiles = file.listFiles();
            for (int i = 0; i < allFiles.length; ++i) {
                if (!allFiles[i].getName().endsWith(".xslt") && !allFiles[i].getName().endsWith(".xsl")) continue;
                FileInserter.insertSingleXSLT(allFiles[i], readConn, range, manager);
            }
        } else {
            FileInserter.insertSingleXSLT(file, readConn, range, manager);
        }
        try {
            ocpds.close(readConn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertSingleXSLT(File file, Connection conn, Range range, SchemaManager manager) {
        URI schemaURI;
        URI docUri;
        String filename = file.getName();
        if (filename.indexOf(45) == -1 || filename.indexOf(45) == filename.lastIndexOf(45)) {
            System.out.println("ERROR: file " + filename + " does not follow filename convention for XSLTs. Not inserted. See help text for archiveInsert.");
            return;
        }
        String schemaname = filename.substring(0, filename.indexOf(45));
        String versionFrom = filename.substring(filename.indexOf(45) + 1, filename.lastIndexOf(45));
        String versionTo = filename.substring(filename.lastIndexOf(45) + 1, filename.indexOf(46));
        OraclePreparedStatement pstmt = null;
        try {
            docUri = range.next();
            schemaURI = manager.getSchemaURI(schemaname);
        }
        catch (Exception e) {
            System.out.println("Problems in initializing Archive: " + e.toString());
            return;
        }
        String sql = "INSERT INTO xml_stylesheets (archive_uid, timestamp, xml, schemaname, schemauid, version_from, version_to) values('" + docUri + "', ?, ?, '" + schemaname + "', '" + schemaURI + "', '" + versionFrom + "', '" + versionTo + "')";
        try {
            pstmt = (OraclePreparedStatement)conn.prepareStatement(sql);
            pstmt.setTimestamp(1, new ArchiveTimeStamp().getTimestamp());
            XMLType xmlInsert = XMLType.createXML((Connection)conn, (String)DatabaseHelper.readFile(file.getAbsolutePath()));
            pstmt.setObject(2, (Object)xmlInsert);
            pstmt.executeUpdate();
            pstmt.close();
        }
        catch (Exception e) {
            System.out.print("Problem in executing SQL: " + e.toString());
            System.out.println("SQL statement was: " + sql);
            System.out.println("ERROR: File " + filename + " not inserted.");
            System.out.println("");
            return;
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception exception) {}
        }
        System.out.println("Inserted xslt file " + filename + ", specifying transformation of schema: " + schemaname + " from version " + versionFrom + " to " + versionTo);
    }

    public static void printHelp() {
        System.out.println("USAGE: ");
        System.out.println("Inserts XML documents with (newly retrieved) UID into Oracle. (Always");
        System.out.println("latest version of a schema will be used.) Special case, if command line");
        System.out.println("switch \"-xslt\" is given as first argument: Then the document is inserted");
        System.out.println("as an XML stylesheet, with some additional information.");
        System.out.println("These stylesheets are used for schema migration.");
        System.out.println("");
        System.out.println("archiveInsert xmlFile schema");
        System.out.println("");
        System.out.println("Special case -xslt: archiveInsert -xslt xsltLocation");
        System.out.println("If xsltLocation is a directory, all xslt files from there will be inserted.");
        System.out.println("Mandatory syntax for XSLT filenames: schemaname-versionFrom-versionTo.xslt, eg.:");
        System.out.println("ObsProposal-9-10.xslt");
    }
}

