/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import jsky.coords.SiteDesc;
import jsky.coords.WorldCoords;
import jsky.plot.ElevationPlotUtil;
import jsky.util.CalendarUtil;

public class SkyCalc {
    private static final int XFORM_FROMSTD = 1;
    private static final int XFORM_TOSTDEP = -1;
    private static final int XFORM_JUSTPRE = 1;
    private static final int XFORM_DOAPPAR = 0;
    private static final double TWOPI = 6.28318530717959;
    private static final double PI_OVER_2 = 1.5707963267949;
    private static final double ARCSEC_IN_RADIAN = 206264.8062471;
    private static final double DEG_IN_RADIAN = 57.2957795130823;
    private static final double HRS_IN_RADIAN = 3.819718634205;
    private static final double KMS_AUDAY = 1731.45683633;
    private static final double SPEED_OF_LIGHT = 299792.458;
    private static final double J2000 = 2451545.0;
    private static final double SEC_IN_DAY = 86400.0;
    private static final double FLATTEN = 0.003352813;
    private static final double EQUAT_RAD = 6378137.0;
    private static final double ASTRO_UNIT = 1.4959787066E11;
    private static final double EARTH_DIFF = 0.05;
    static final double[] DELTS = new double[]{-2.72, 3.86, 10.46, 17.2, 21.16, 23.62, 24.02, 23.93, 24.33, 26.77, 29.15, 31.07, 33.15, 35.73, 40.18, 45.48, 50.54, 54.34, 56.86, 60.78, 62.97};
    public static final TimeZone UT = TimeZone.getTimeZone("UT");
    private double _hoursLongitude;
    private double _degreesLatitude;
    private double _altitude;
    private double _azimuth;
    private double _parallacticAngle;
    private double _airmass;

    public SkyCalc(SiteDesc site) {
        this._hoursLongitude = -site.getLongitude() / 15.0;
        this._degreesLatitude = site.getLatitude();
    }

    public void calculate(WorldCoords obj, Date date) {
        DateTime dateTime = new DateTime(date);
        DoubleRef jdut = new DoubleRef();
        DoubleRef sid = new DoubleRef();
        DoubleRef curepoch = new DoubleRef();
        SkyCalc.setup_time_place(dateTime, this._hoursLongitude, jdut, sid, curepoch);
        double objra = obj.getRaDeg() / 15.0;
        double objdec = obj.getDecDeg();
        double objepoch = 2000.0;
        this.getCircumstances(objra, objdec, objepoch, curepoch.d, sid.d, this._degreesLatitude);
    }

    public Date getLst(Date date) {
        DateTime dateTime = new DateTime(date);
        double jd = SkyCalc.date_to_jd(dateTime);
        double lstHours = SkyCalc.lst(jd, this._hoursLongitude);
        return this._getLst(lstHours, date);
    }

    private Date _getLst(double lstHours, Date date) {
        Calendar cal = Calendar.getInstance(UT);
        cal.setTime(date);
        int h = cal.get(11);
        boolean nextDay = lstHours < (double)h;
        CalendarUtil.setHours(cal, lstHours, nextDay);
        return cal.getTime();
    }

    public static double getAirmass(double alt) {
        double secz = SkyCalc.secant_z(alt);
        if (secz >= 0.0) {
            if (secz < 12.0) {
                return SkyCalc.true_airmass(secz);
            }
            if (secz <= 99.0) {
                return secz;
            }
        }
        return 0.0;
    }

    private static short setup_time_place(DateTime date, double longit, DoubleRef jdut, DoubleRef sid, DoubleRef curepoch) {
        double jd = SkyCalc.date_to_jd(date);
        sid.d = SkyCalc.lst(jd, longit);
        jdut.d = jd;
        curepoch.d = 2000.0 + (jd - 2451545.0) / 365.25;
        return 0;
    }

    private void getCircumstances(double objra, double objdec, double objepoch, double curep, double sid, double lat) {
        DoubleRef az = new DoubleRef();
        DoubleRef par = new DoubleRef();
        DoubleRef curra = new DoubleRef();
        DoubleRef curdec = new DoubleRef();
        SkyCalc.cooxform(objra, objdec, objepoch, curep, curra, curdec, 1, 1);
        double ha = SkyCalc.adj_time(sid - curra.d);
        double alt = SkyCalc.altit(curdec.d, ha, lat, az, par);
        this._airmass = SkyCalc.getAirmass(alt);
        this._altitude = alt;
        this._azimuth = az.d;
        this._parallacticAngle = par.d;
    }

    private static void cooxform(double rin, double din, double std_epoch, double date_epoch, DoubleRef rout, DoubleRef dout, int just_precess, int from_std) {
        int j;
        int i;
        double[][] p = new double[4][4];
        double[][] n = new double[4][4];
        double[][] r = new double[4][4];
        double[][] t = new double[4][4];
        DoubleRef del_psi = new DoubleRef();
        DoubleRef del_eps = new DoubleRef();
        double[] orig = new double[4];
        double[] fin = new double[4];
        double ti = (std_epoch - 2000.0) / 100.0;
        double tf = (date_epoch - 2000.0 - 100.0 * ti) / 100.0;
        double zeta = (2306.2181 + 1.39656 * ti + 1.39E-4 * ti * ti) * tf + (0.30188 - 3.44E-4 * ti) * tf * tf + 0.017998 * tf * tf * tf;
        double z = zeta + (0.7928 + 4.1E-4 * ti) * tf * tf + 2.05E-4 * tf * tf * tf;
        double theta = (2004.3109 - 0.8533 * ti - 2.17E-4 * ti * ti) * tf - (0.42665 + 2.17E-4 * ti) * tf * tf - 0.041833 * tf * tf * tf;
        double cosz = Math.cos(z /= 206264.8062471);
        double coszeta = Math.cos(zeta /= 206264.8062471);
        double costheta = Math.cos(theta /= 206264.8062471);
        double sinz = Math.sin(z);
        double sinzeta = Math.sin(zeta);
        double sintheta = Math.sin(theta);
        p[1][1] = coszeta * cosz * costheta - sinzeta * sinz;
        p[1][2] = -1.0 * sinzeta * cosz * costheta - coszeta * sinz;
        p[1][3] = -1.0 * cosz * sintheta;
        p[2][1] = coszeta * sinz * costheta + sinzeta * cosz;
        p[2][2] = -1.0 * sinzeta * sinz * costheta + coszeta * cosz;
        p[2][3] = -1.0 * sinz * sintheta;
        p[3][1] = coszeta * sintheta;
        p[3][2] = -1.0 * sinzeta * sintheta;
        p[3][3] = costheta;
        if (just_precess == 0) {
            SkyCalc.nutation_params(date_epoch, del_psi, del_eps);
            double eps = 0.409105;
            n[1][1] = 1.0;
            n[2][2] = 1.0;
            n[3][3] = 1.0;
            n[1][2] = -1.0 * del_psi.d * Math.cos(eps);
            n[1][3] = -1.0 * del_psi.d * Math.sin(eps);
            n[2][1] = -1.0 * n[1][2];
            n[2][3] = -1.0 * del_eps.d;
            n[3][1] = -1.0 * n[1][3];
            n[3][2] = -1.0 * n[2][3];
            for (i = 1; i <= 3; ++i) {
                for (j = 1; j <= 3; ++j) {
                    r[i][j] = 0.0;
                    for (int k = 1; k <= 3; ++k) {
                        double[] dArray = r[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + p[i][k] * n[k][j];
                    }
                }
            }
        } else {
            for (i = 1; i <= 3; ++i) {
                for (j = 1; j <= 3; ++j) {
                    r[i][j] = p[i][j];
                }
            }
        }
        if (from_std == -1) {
            for (i = 1; i <= 3; ++i) {
                for (j = 1; j <= 3; ++j) {
                    t[i][j] = r[j][i];
                }
            }
            for (i = 1; i <= 3; ++i) {
                for (j = 1; j <= 3; ++j) {
                    r[i][j] = t[i][j];
                }
            }
        }
        double radian_ra = rin / 3.819718634205;
        double radian_dec = din / 57.2957795130823;
        orig[1] = Math.cos(radian_dec) * Math.cos(radian_ra);
        orig[2] = Math.cos(radian_dec) * Math.sin(radian_ra);
        orig[3] = Math.sin(radian_dec);
        if (from_std == -1 && just_precess == 0) {
            SkyCalc.aberrate(date_epoch, orig, from_std);
        }
        for (i = 1; i <= 3; ++i) {
            fin[i] = 0.0;
            for (j = 1; j <= 3; ++j) {
                int n3 = i;
                fin[n3] = fin[n3] + r[i][j] * orig[j];
            }
        }
        if (from_std == 1 && just_precess == 0) {
            SkyCalc.aberrate(date_epoch, fin, from_std);
        }
        SkyCalc.xyz_cel(fin[1], fin[2], fin[3], rout, dout);
    }

    private static void nutation_params(double date_epoch, DoubleRef del_psi, DoubleRef del_ep) {
        double jd = (date_epoch - 2000.0) * 365.25 + 2451545.0;
        double T = (jd - 2415020.0) / 36525.0;
        double L = 279.6967 + (36000.7689 + 3.03E-4 * T) * T;
        double Lprime = 270.4342 + (481267.8831 - 0.001133 * T) * T;
        double M = 358.4758 + (35999.0498 - 1.5E-4 * T) * T;
        double Mprime = 296.1046 + (477198.8491 + 0.009192 * T) * T;
        double Omega = 259.1833 - (1934.142 - 0.002078 * T) * T;
        del_psi.d = -1.0 * (17.2327 + 0.01737 * T) * Math.sin(Omega /= 57.2957795130823) - (1.2729 + 1.3E-4 * T) * Math.sin(2.0 * (L /= 57.2957795130823)) + 0.2088 * Math.sin(2.0 * Omega) - 0.2037 * Math.sin(2.0 * (Lprime /= 57.2957795130823)) + (0.1261 - 3.1E-4 * T) * Math.sin(M /= 57.2957795130823) + 0.0675 * Math.sin(Mprime /= 57.2957795130823) - (0.0497 - 1.2E-4 * T) * Math.sin(2.0 * L + M) - 0.0342 * Math.sin(2.0 * Lprime - Omega) - 0.0261 * Math.sin(2.0 * Lprime + Mprime) + 0.0214 * Math.sin(2.0 * L - M) - 0.0149 * Math.sin(2.0 * L - 2.0 * Lprime + Mprime) + 0.0124 * Math.sin(2.0 * L - Omega) + 0.0114 * Math.sin(2.0 * Lprime - Mprime);
        del_ep.d = (9.21 + 9.1E-4 * T) * Math.cos(Omega) + (0.5522 - 2.9E-4 * T) * Math.cos(2.0 * L) - 0.0904 * Math.cos(2.0 * Omega) + 0.0884 * Math.cos(2.0 * Lprime) + 0.0216 * Math.cos(2.0 * L + M) + 0.0183 * Math.cos(2.0 * Lprime - Omega) + 0.0113 * Math.cos(2.0 * Lprime + Mprime) - 0.0093 * Math.cos(2.0 * L - M) - 0.0066 * Math.cos(2.0 * L - Omega);
        del_psi.d = del_psi.d / 206264.8062471;
        del_ep.d = del_ep.d / 206264.8062471;
    }

    private static void xyz_cel(double x, double y, double z, DoubleRef ra, DoubleRef dec) {
        DoubleRef doubleRef;
        double mod = Math.sqrt(x * x + y * y + z * z);
        if (mod > 0.0) {
            z /= mod;
        } else {
            System.out.println("Bad data in xyz_cel .... zero modulus position vector.\n");
            ra.d = 0.0;
            dec.d = 0.0;
            return;
        }
        double xy = Math.sqrt((x /= mod) * x + (y /= mod) * y);
        if (xy < 1.0E-11) {
            ra.d = 0.0;
            dec.d = 1.5707963267949;
            if (z < 0.0) {
                doubleRef = dec;
                doubleRef.d = doubleRef.d * -1.0;
            }
        } else {
            dec.d = Math.asin(z);
            ra.d = SkyCalc.atan_circ(x, y);
        }
        doubleRef = ra;
        doubleRef.d = doubleRef.d * 3.819718634205;
        doubleRef = dec;
        doubleRef.d = doubleRef.d * 57.2957795130823;
    }

    private static void aberrate(double epoch, double[] vec, int from_std) {
        DoubleRef ras = new DoubleRef();
        DoubleRef decs = new DoubleRef();
        DoubleRef dists = new DoubleRef();
        DoubleRef topora = new DoubleRef();
        DoubleRef topodec = new DoubleRef();
        DoubleRef x = new DoubleRef();
        DoubleRef y = new DoubleRef();
        DoubleRef z = new DoubleRef();
        DoubleRef x1 = new DoubleRef();
        DoubleRef y1 = new DoubleRef();
        DoubleRef z1 = new DoubleRef();
        DoubleRef x2 = new DoubleRef();
        DoubleRef y2 = new DoubleRef();
        DoubleRef z2 = new DoubleRef();
        double jd = 2451545.0 + (epoch - 2000.0) * 365.25;
        double jd1 = jd - 0.05;
        double jd2 = jd + 0.05;
        SkyCalc.accusun(jd1, 0.0, 0.0, ras, decs, dists, topora, topodec, x1, y1, z1);
        SkyCalc.accusun(jd2, 0.0, 0.0, ras, decs, dists, topora, topodec, x2, y2, z2);
        SkyCalc.accusun(jd, 0.0, 0.0, ras, decs, dists, topora, topodec, x, y, z);
        double Xdot = 1731.45683633 * (x2.d - x1.d) / 29979.2458;
        double Ydot = 1731.45683633 * (y2.d - y1.d) / 29979.2458;
        double Zdot = 1731.45683633 * (z2.d - z1.d) / 29979.2458;
        vec[1] = vec[1] + (double)from_std * Xdot;
        vec[2] = vec[2] + (double)from_std * Ydot;
        vec[3] = vec[3] + (double)from_std * Zdot;
        double norm = Math.pow(vec[1] * vec[1] + vec[2] * vec[2] + vec[3] * vec[3], 0.5);
        vec[1] = vec[1] / norm;
        vec[2] = vec[2] / norm;
        vec[3] = vec[3] / norm;
    }

    private static double atan_circ(double x, double y) {
        double theta;
        if (x == 0.0 && y == 0.0) {
            return 0.0;
        }
        for (theta = Math.atan2(y, x); theta < 0.0; theta += 6.28318530717959) {
        }
        return theta;
    }

    private static void accusun(double jd, double lst, double geolat, DoubleRef ra, DoubleRef dec, DoubleRef dist, DoubleRef topora, DoubleRef topodec, DoubleRef x, DoubleRef y, DoubleRef z) {
        DoubleRef xgeo = new DoubleRef();
        DoubleRef ygeo = new DoubleRef();
        DoubleRef zgeo = new DoubleRef();
        jd += SkyCalc.etcorr(jd) / 86400.0;
        double T = (jd - 2415020.0) / 36525.0;
        double Tsq = T * T;
        double Tcb = T * Tsq;
        double L = 279.69668 + 36000.76892 * T + 3.025E-4 * Tsq;
        double M = 358.47583 + 35999.04975 * T - 1.5E-4 * Tsq - 3.3E-6 * Tcb;
        double e = 0.01675104 - 4.18E-5 * T - 1.26E-7 * Tsq;
        L = SkyCalc.circulo(L);
        M = SkyCalc.circulo(M);
        double A = 153.23 + 22518.7541 * T;
        double B = 216.57 + 45037.5082 * T;
        double C = 312.69 + 32964.3577 * T;
        double D = 350.74 + 445267.1142 * T - 0.00144 * Tsq;
        double E = 231.19 + 20.2 * T;
        double H = 353.4 + 65928.7155 * T;
        A = SkyCalc.circulo(A) / 57.2957795130823;
        B = SkyCalc.circulo(B) / 57.2957795130823;
        C = SkyCalc.circulo(C) / 57.2957795130823;
        D = SkyCalc.circulo(D) / 57.2957795130823;
        E = SkyCalc.circulo(E) / 57.2957795130823;
        H = SkyCalc.circulo(H) / 57.2957795130823;
        L = L + 0.00134 * Math.cos(A) + 0.00154 * Math.cos(B) + 0.002 * Math.cos(C) + 0.00179 * Math.sin(D) + 0.00178 * Math.sin(E);
        double Mrad = M / 57.2957795130823;
        double Cent = (1.91946 - 0.004789 * T - 1.4E-5 * Tsq) * Math.sin(Mrad) + (0.020094 - 1.0E-4 * T) * Math.sin(2.0 * Mrad) + 2.93E-4 * Math.sin(3.0 * Mrad);
        double sunlong = L + Cent;
        double nu = M + Cent;
        double nurad = nu / 57.2957795130823;
        double R = 1.0000002 * (1.0 - e * e) / (1.0 + e * Math.cos(nurad));
        R = R + 5.43E-6 * Math.sin(A) + 1.575E-5 * Math.sin(B) + 1.627E-5 * Math.sin(C) + 3.076E-5 * Math.cos(D) + 9.27E-6 * Math.sin(H);
        dist.d = R;
        x.d = Math.cos(sunlong /= 57.2957795130823);
        y.d = Math.sin(sunlong);
        z.d = 0.0;
        SkyCalc.eclrot(jd, y, z);
        SkyCalc.geocent(lst, geolat, 0.0, xgeo, ygeo, zgeo);
        double xtop = x.d - xgeo.d * 6378137.0 / 1.4959787066E11;
        double ytop = y.d - ygeo.d * 6378137.0 / 1.4959787066E11;
        double ztop = z.d - zgeo.d * 6378137.0 / 1.4959787066E11;
        double topodist = Math.sqrt(xtop * xtop + ytop * ytop + ztop * ztop);
        double l = xtop / topodist;
        double m = ytop / topodist;
        double n = ztop / topodist;
        topora.d = SkyCalc.atan_circ(l, m) * 3.819718634205;
        topodec.d = Math.asin(n) * 57.2957795130823;
        ra.d = SkyCalc.atan_circ(x.d, y.d) * 3.819718634205;
        dec.d = Math.asin(z.d) * 57.2957795130823;
        x.d = x.d * R * -1.0;
        y.d = y.d * R * -1.0;
        z.d = z.d * R * -1.0;
    }

    private static double etcorr(double jd) {
        int i;
        double[] dates = new double[22];
        double delt = 0.0;
        for (i = 0; i <= 19; ++i) {
            dates[i] = 1900.0 + (double)i * 5.0;
        }
        dates[20] = 1998.0;
        double year = 1900.0 + (jd - 2415019.5) / 365.25;
        if (year < 1998.0 && year >= 1900.0) {
            i = (int)(year - 1900.0) / 5;
            delt = DELTS[i] + (DELTS[i + 1] - DELTS[i]) / (dates[i + 1] - dates[i]) * (year - dates[i]);
        } else if (year >= 1998.0 && year < 2100.0) {
            delt = 33.15 + 0.002164 * (jd - 2436935.4);
        } else if (year < 1900.0) {
            System.out.println("etcorr ... no ephemeris time data for < 1900.\n");
            delt = 0.0;
        } else if (year >= 2100.0) {
            System.out.println("etcorr .. very long extrapolation in delta T - inaccurate.\n");
            delt = 180.0;
        }
        return delt;
    }

    private static double circulo(double x) {
        int n = (int)(x / 360.0);
        return x - 360.0 * (double)n;
    }

    private static void eclrot(double jd, DoubleRef y, DoubleRef z) {
        double T = (jd - 2451545.0) / 36525.0;
        double incl = (23.439291 + T * (-0.0130042 - 1.6E-7 * T)) / 57.2957795130823;
        double ypr = Math.cos(incl) * y.d - Math.sin(incl) * z.d;
        double zpr = Math.sin(incl) * y.d + Math.cos(incl) * z.d;
        y.d = ypr;
        z.d = zpr;
    }

    private static void geocent(double geolong, double geolat, double height, DoubleRef x_geo, DoubleRef y_geo, DoubleRef z_geo) {
        double denom = 0.996647187 * Math.sin(geolat /= 57.2957795130823);
        denom = Math.cos(geolat) * Math.cos(geolat) + denom * denom;
        double C_geo = 1.0 / Math.sqrt(denom);
        double S_geo = 0.9933056153550129 * C_geo;
        x_geo.d = (C_geo += height / 6378137.0) * Math.cos(geolat) * Math.cos(geolong /= 3.819718634205);
        y_geo.d = C_geo * Math.cos(geolat) * Math.sin(geolong);
        z_geo.d = (S_geo += height / 6378137.0) * Math.sin(geolat);
    }

    private static double adj_time(double x) {
        if (Math.abs(x) < 100000.0) {
            while (x > 12.0) {
                x -= 24.0;
            }
            while (x < -12.0) {
                x += 24.0;
            }
        } else {
            System.out.println("Out of bounds in adj_time!\n");
        }
        return x;
    }

    private static double altit(double dec, double ha, double lat, DoubleRef az, DoubleRef parang) {
        double cosdec = Math.cos(dec /= 57.2957795130823);
        double sindec = Math.sin(dec);
        double cosha = Math.cos(ha /= 3.819718634205);
        double sinha = Math.sin(ha);
        double coslat = Math.cos(lat /= 57.2957795130823);
        double sinlat = Math.sin(lat);
        double x = 57.2957795130823 * Math.asin(cosdec * cosha * coslat + sindec * sinlat);
        double y = sindec * coslat - cosdec * cosha * sinlat;
        double z = -1.0 * cosdec * sinha;
        az.d = Math.atan2(z, y);
        if (cosdec != 0.0) {
            double sinp = -1.0 * Math.sin(az.d) * coslat / cosdec;
            double cosp = -1.0 * Math.cos(az.d) * cosha - Math.sin(az.d) * sinha * sinlat;
            parang.d = Math.atan2(sinp, cosp) * 57.2957795130823;
        } else if (lat >= 0.0) {
            parang.d = 180.0;
        } else {
            parang.d = 0.0;
        }
        DoubleRef doubleRef = az;
        doubleRef.d = doubleRef.d * 57.2957795130823;
        while (az.d < 0.0) {
            doubleRef = az;
            doubleRef.d = doubleRef.d + 360.0;
        }
        while (az.d >= 360.0) {
            doubleRef = az;
            doubleRef.d = doubleRef.d - 360.0;
        }
        return x;
    }

    private static double secant_z(double alt) {
        double secz = alt != 0.0 ? 1.0 / Math.sin(alt / 57.2957795130823) : 100.0;
        if (secz > 100.0) {
            secz = 100.0;
        }
        if (secz < -100.0) {
            secz = -100.0;
        }
        return secz;
    }

    private static double true_airmass(double secz) {
        int ord = 4;
        double[] coef = new double[5];
        double result = 0.0;
        coef[1] = 0.002879465;
        coef[2] = 0.003033104;
        coef[3] = 0.001351167;
        coef[4] = -4.716679E-5;
        if (secz < 0.0) {
            return -1.0;
        }
        if (secz > 12.0) {
            return secz - 1.5;
        }
        double seczmin1 = secz - 1.0;
        for (int i = ord; i > 0; --i) {
            result = (result + coef[i]) * seczmin1;
        }
        result = secz - result;
        return result;
    }

    private static double date_to_jd(DateTime date) {
        int m;
        int y;
        if (date.mo <= 2) {
            y = date.y - 1;
            m = date.mo + 12;
        } else {
            y = date.y;
            m = date.mo;
        }
        long A = (long)((double)y / 100.0);
        long B = 2L - A + (long)((double)A / 4.0);
        double jd = (double)((long)(365.25 * (double)y) + (long)(30.6001 * (double)(m + 1)) + (long)date.d) + 1720994.5;
        jd += (double)date.h / 24.0 + (double)date.mn / 1440.0 + date.s / 86400.0;
        if (date.y > 1583) {
            return jd + (double)B;
        }
        return jd;
    }

    private static double lst(double jd, double longit) {
        double ut;
        double jdmid;
        long jdin = (long)jd;
        double jdint = jdin;
        double jdfrac = jd - jdint;
        if (jdfrac < 0.5) {
            jdmid = jdint - 0.5;
            ut = jdfrac + 0.5;
        } else {
            jdmid = jdint + 0.5;
            ut = jdfrac - 0.5;
        }
        double t = (jdmid - 2451545.0) / 36525.0;
        double sid_g = (24110.54841 + 8640184.812866 * t + 0.093104 * t * t - 6.2E-6 * t * t * t) / 86400.0;
        long sid_int = (long)sid_g;
        sid_g -= (double)sid_int;
        sid_g = sid_g + 1.0027379093 * ut - longit / 24.0;
        sid_int = (long)sid_g;
        sid_g = (sid_g - (double)sid_int) * 24.0;
        return sid_g;
    }

    public double getAltitude() {
        return this._altitude;
    }

    public double getAzimuth() {
        return this._azimuth;
    }

    public double getParallacticAngle() {
        return this._parallacticAngle;
    }

    public double getAirmass() {
        return this._airmass;
    }

    public static void main(String[] args) {
        SiteDesc site = ElevationPlotUtil.MAUNA_KEA;
        Calendar cal = Calendar.getInstance(UT);
        cal.set(2005, 2, 9, 11, 0, 0);
        Date date = cal.getTime();
        WorldCoords obj = new WorldCoords("10 00 00", "+19 49 26");
        SkyCalc skyCalc = new SkyCalc(site);
        skyCalc.calculate(obj, date);
        System.out.println("For Site = Mauna Kea, date = 2005-03-09, obj = " + obj + ":");
        System.out.println("   Altitude = " + skyCalc.getAltitude());
        System.out.println("   Azimuth = " + skyCalc.getAzimuth());
        System.out.println("   Airmass = " + skyCalc.getAirmass());
        System.out.println("   Parallactic Angle = " + skyCalc.getParallacticAngle());
    }

    private static class DateTime {
        short y;
        short mo;
        short d;
        short h;
        short mn;
        double s;

        private DateTime(Date date) {
            Calendar cal = Calendar.getInstance(UT);
            cal.setTime(date);
            this.y = (short)cal.get(1);
            this.mo = (short)(cal.get(2) + 1);
            this.d = (short)cal.get(5);
            this.h = (short)cal.get(11);
            this.mn = (short)cal.get(12);
            this.s = (double)cal.get(13) + (double)cal.get(14) / 1000.0;
        }
    }

    private static class DoubleRef {
        private double d = 0.0;

        private DoubleRef() {
        }
    }
}

