/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CalendarUtil {
    public static void setHours(Calendar cal, double hours, boolean nextDay) {
        int h = (int)hours;
        double md = (hours - (double)h) * 60.0;
        int min = (int)md;
        double sd = (md - (double)min) * 60.0;
        int sec = (int)sd;
        int ms = (int)((sd - (double)sec) * 1000.0);
        cal.set(11, h);
        cal.set(12, min);
        cal.set(13, sec);
        cal.set(14, ms);
        if (nextDay) {
            cal.add(11, 24);
        }
    }

    public static String toString(Calendar cal) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
        dateFormat.setTimeZone(cal.getTimeZone());
        return dateFormat.format(cal.getTime());
    }

    public static String toString(Date date, String timezoneName) {
        TimeZone tz = TimeZone.getTimeZone(timezoneName);
        Calendar cal = Calendar.getInstance(tz);
        cal.setTime(date);
        return CalendarUtil.toString(cal);
    }

    public static String toString(long time, String timezoneName) {
        return CalendarUtil.toString(new Date(time), timezoneName);
    }

    public static void main(String[] args) {
        Calendar cal = Calendar.getInstance();
        CalendarUtil.setHours(cal, 23.750001, false);
        System.out.println(CalendarUtil.toString(cal));
    }
}

