/*
 * Decompiled with CFR 0.152.
 */
package jsky.plot;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.coords.SiteDesc;
import jsky.coords.TargetDesc;
import jsky.coords.WorldCoords;
import jsky.plot.ElevationPanel;
import jsky.plot.ElevationPlotMenuBar;
import jsky.plot.ElevationPlotModel;
import jsky.plot.ElevationPlotUtil;
import jsky.plot.ObservationPanel;
import jsky.plot.TablePanel;
import jsky.plot.TargetListFrame;
import jsky.plot.TargetListPanel;
import jsky.util.I18N;
import jsky.util.Preferences;
import jsky.util.PrintableWithDialog;
import jsky.util.Resources;
import jsky.util.SaveableWithDialog;
import jsky.util.gui.BasicWindowMonitor;
import jsky.util.gui.DateChooserDialog;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.GridBagUtil;
import jsky.util.gui.SwingUtil;

public class ElevationPlotPanel
extends JPanel
implements ChangeListener {
    private static final I18N _I18N = I18N.getInstance(ElevationPlotPanel.class);
    private static SiteDesc[] _availableSites = new SiteDesc[]{ElevationPlotUtil.MAUNA_KEA, ElevationPlotUtil.CERRO_PANCHON};
    private static String[] _availableTimeZoneIds = new String[]{"UT", "LST", "Site Time"};
    private static String[] _availableTimeZoneDisplayNames = new String[]{"UT", _I18N.getString("SiderealTime"), _I18N.getString("SiteTime")};
    private static final String ALTITUDE = _I18N.getString("Altitude");
    private static final String PA = _I18N.getString("ParallacticAngle");
    private static final String _altitudePlotVisiblePrefName = ElevationPanel.class.getName() + ".altitudePlotVisible";
    private static final String _paPlotVisiblePrefName = ElevationPanel.class.getName() + ".paPlotVisible";
    private ElevationPanel _elevationPanel;
    private ObservationPanel _observationPanel;
    private TablePanel _tablePanel;
    private JTabbedPane _mainTabbedPane;
    private DateChooserDialog _dateChooserDialog;
    private ElevationPlotModel _model;
    private JFrame _targetListFrame;
    private TargetListPanel _targetListPanel;
    private boolean _isMainWindow = false;
    private JRadioButton[] _siteButtons;
    private JRadioButton[] _timeZoneButtons;
    private JPanel _plotTypePanel;
    private JCheckBox[] _plotTypeButtons;
    private boolean _ignoreEvents = false;
    private AbstractAction _printAction = new AbstractAction(_I18N.getString("print")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ElevationPlotPanel.this.print();
        }
    };
    private AbstractAction _saveAsAction = new AbstractAction(_I18N.getString("saveAs")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ElevationPlotPanel.this.saveAs();
        }
    };
    private AbstractAction _closeAction = new AbstractAction(_I18N.getString("close")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ElevationPlotPanel.this.close();
        }
    };
    private AbstractAction _dateAction = new AbstractAction(_I18N.getString("date")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ElevationPlotPanel.this.selectDate();
        }
    };
    private AbstractAction _targetsAction = new AbstractAction(_I18N.getString("targets")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ElevationPlotPanel.this.selectTargets();
        }
    };

    public ElevationPlotPanel() {
        Preferences.manageSize((JComponent)this, (Dimension)new Dimension(800, 400), (String)(this.getClass().getName() + ".size"));
        this._elevationPanel = new ElevationPanel();
        this._observationPanel = new ObservationPanel();
        this._tablePanel = new TablePanel();
        this._mainTabbedPane = new JTabbedPane();
        this._mainTabbedPane.add((Component)this._elevationPanel, "Elevation Plot");
        this._mainTabbedPane.add((Component)this._observationPanel, "Observation Chart");
        this._mainTabbedPane.add((Component)this._tablePanel, "Tables");
        this._mainTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ElevationPlotPanel.this.updatePlotOptions();
            }
        });
        GridBagUtil layout = new GridBagUtil((Container)this);
        layout.add((Component)this._mainTabbedPane, 0, 0, 1, 1, 1.0, 1.0, 1, 10, new Insets(0, 0, 0, 0));
        layout.add((Component)this._makeButtonPanel(), 0, 1, 1, 1, 1.0, 0.0, 2, 15, new Insets(6, 11, 6, 11));
    }

    public static SiteDesc[] getAvailableSites() {
        return _availableSites;
    }

    public static void setAvailableSites(SiteDesc[] sites) {
        _availableSites = sites;
    }

    public void setModel(ElevationPlotModel model) {
        this._model = model;
        this._elevationPanel.setModel(model);
        this._observationPanel.setModel(model);
        this._tablePanel.setModel(model);
        this._update();
        this._model.removeChangeListener(this);
        this._model.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this._update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _update() {
        try {
            this._ignoreEvents = true;
            String siteName = this._model.getSite().getName();
            for (int i = 0; i < _availableSites.length; ++i) {
                if (!siteName.equals(_availableSites[i].getName())) continue;
                if (this._siteButtons[i].isSelected()) break;
                this._siteButtons[i].setSelected(true);
                break;
            }
            String id = this._model.getTimeZoneId();
            for (int i = 0; i < _availableTimeZoneIds.length; ++i) {
                if (!id.equals(_availableTimeZoneIds[i])) continue;
                if (!this._timeZoneButtons[i].isSelected()) {
                    this._timeZoneButtons[i].setSelected(true);
                }
                break;
            }
        }
        finally {
            this._ignoreEvents = false;
        }
    }

    public ElevationPlotModel getModel() {
        return this._model;
    }

    private JPanel _makeButtonPanel() {
        JPanel panel = new JPanel();
        GridBagUtil layout = new GridBagUtil((Container)panel);
        layout.add((Component)this._makeSitePanel(), 0, 0, 1, 1, 1.0, 0.0, 0, 17, new Insets(0, 0, 0, 0));
        layout.add((Component)this._makePlotTypePanel(), 1, 0, 1, 1, 1.0, 0.0, 0, 10, new Insets(0, 0, 0, 0));
        layout.add((Component)this._makeTimePanel(), 2, 0, 1, 1, 1.0, 0.0, 0, 13, new Insets(0, 0, 0, 0));
        return panel;
    }

    private JPanel _makeSitePanel() {
        JPanel panel = new JPanel();
        SiteDesc[] sites = ElevationPlotPanel.getAvailableSites();
        ButtonGroup group = new ButtonGroup();
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JRadioButton rb = (JRadioButton)e.getSource();
                if (!ElevationPlotPanel.this._ignoreEvents && rb.isSelected()) {
                    ElevationPlotPanel.this.setSite(rb.getText());
                }
            }
        };
        JLabel label = new JLabel("Site:");
        GridBagUtil layout = new GridBagUtil((Container)panel);
        layout.add((Component)label, 0, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 0, 0, 0));
        this._siteButtons = new JRadioButton[sites.length];
        for (int i = 0; i < sites.length; ++i) {
            this._siteButtons[i] = new JRadioButton(sites[i].getName(), i == 0);
            layout.add((Component)this._siteButtons[i], i + 1, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 3, 0, 0));
            group.add(this._siteButtons[i]);
            this._siteButtons[i].addItemListener(itemListener);
        }
        return panel;
    }

    private JPanel _makePlotTypePanel() {
        this._plotTypePanel = new JPanel();
        String[] types = new String[]{ALTITUDE, PA};
        boolean[] selected = new boolean[]{Preferences.get((String)_altitudePlotVisiblePrefName, (boolean)true), Preferences.get((String)_paPlotVisiblePrefName, (boolean)false)};
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBox cb = (JCheckBox)e.getSource();
                if (!ElevationPlotPanel.this._ignoreEvents) {
                    ElevationPlotPanel.this.setPlotVisible(cb.getText(), cb.isSelected());
                }
            }
        };
        JLabel label = new JLabel("Plot:");
        GridBagUtil layout = new GridBagUtil((Container)this._plotTypePanel);
        layout.add((Component)label, 0, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 0, 0, 0));
        this._plotTypeButtons = new JCheckBox[types.length];
        for (int i = 0; i < types.length; ++i) {
            this._plotTypeButtons[i] = new JCheckBox(types[i], selected[i]);
            layout.add((Component)this._plotTypeButtons[i], i + 1, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 3, 0, 0));
            this._plotTypeButtons[i].addItemListener(itemListener);
            this.setPlotVisible(types[i], selected[i]);
        }
        return this._plotTypePanel;
    }

    private JPanel _makeTimePanel() {
        JPanel panel = new JPanel();
        this._timeZoneButtons = new JRadioButton[_availableTimeZoneDisplayNames.length];
        ButtonGroup group = new ButtonGroup();
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JRadioButton rb = (JRadioButton)e.getSource();
                if (!ElevationPlotPanel.this._ignoreEvents && rb.isSelected()) {
                    String s = rb.getText();
                    for (int i = 0; i < _availableTimeZoneDisplayNames.length; ++i) {
                        if (!_availableTimeZoneDisplayNames[i].equals(s)) continue;
                        ElevationPlotPanel.this.setTimeZone(_availableTimeZoneDisplayNames[i], _availableTimeZoneIds[i]);
                        break;
                    }
                }
            }
        };
        JLabel label = new JLabel("Time:");
        GridBagUtil layout = new GridBagUtil((Container)panel);
        layout.add((Component)label, 0, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 0, 0, 0));
        for (int i = 0; i < _availableTimeZoneDisplayNames.length; ++i) {
            this._timeZoneButtons[i] = new JRadioButton(_availableTimeZoneDisplayNames[i], i == 0);
            layout.add((Component)this._timeZoneButtons[i], i + 1, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 3, 0, 0));
            group.add(this._timeZoneButtons[i]);
            this._timeZoneButtons[i].addItemListener(itemListener);
        }
        return panel;
    }

    public void setTimeZone(String timeZoneDisplayName, String timeZoneId) {
        this._model.setTimeZone(timeZoneDisplayName, timeZoneId);
    }

    public void setSite(String name) {
        for (SiteDesc site : _availableSites) {
            if (!site.getName().equals(name)) continue;
            this._model.setSite(site);
            break;
        }
    }

    public void setPlotVisible(String name, boolean visible) {
        if (name.equals(ALTITUDE)) {
            this._elevationPanel.setAltitudePlotVisible(visible);
            Preferences.set((String)_altitudePlotVisiblePrefName, (boolean)visible);
        } else if (name.equals(PA)) {
            this._elevationPanel.setPaPlotVisible(visible);
            Preferences.set((String)_paPlotVisiblePrefName, (boolean)visible);
            this._elevationPanel.setY2AxisLabel(ElevationPanel.Y2_AXIS_PA);
            if (visible) {
                this._elevationPanel.setY2AxisLabel(ElevationPanel.Y2_AXIS_PA);
            } else {
                this._elevationPanel.setY2AxisLabel(ElevationPanel.Y2_AXIS_AIRMASS);
            }
        }
    }

    private DateChooserDialog getDateChooserDialog(Calendar cal, boolean controlPane) {
        if (this._dateChooserDialog == null) {
            this._dateChooserDialog = new DateChooserDialog((Frame)SwingUtil.getFrame((Component)this), cal, controlPane);
        }
        return this._dateChooserDialog;
    }

    public void print() {
        Component c = this._mainTabbedPane.getSelectedComponent();
        if (c instanceof PrintableWithDialog) {
            try {
                ((PrintableWithDialog)c).print();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    }

    public void saveAs() {
        Component c = this._mainTabbedPane.getSelectedComponent();
        if (c instanceof SaveableWithDialog) {
            try {
                ((SaveableWithDialog)c).saveAs();
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
            }
        }
    }

    public boolean isMainWindow() {
        return this._isMainWindow;
    }

    public void setIsMainWindow(boolean b) {
        this._isMainWindow = b;
    }

    public void close() {
        if (this.isMainWindow()) {
            System.exit(0);
        } else {
            JFrame parent = SwingUtil.getFrame((Component)this);
            if (parent != null) {
                parent.setVisible(false);
            }
        }
    }

    public void dispose() {
        JFrame parent = SwingUtil.getFrame((Component)this);
        if (parent != null) {
            parent.dispose();
        }
    }

    public void selectDate() {
        Calendar cal = Calendar.getInstance(this._model.getTimeZone());
        cal.setTime(this._model.getDate());
        DateChooserDialog dialog = this.getDateChooserDialog(cal, true);
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            Date date = dialog.getDate();
            this._model.setDate(date);
        }
    }

    public void selectTargets() {
        if (this._targetListFrame != null) {
            SwingUtil.showFrame((JFrame)this._targetListFrame);
        } else {
            this._targetListFrame = new TargetListFrame();
            this._targetListPanel = ((TargetListFrame)this._targetListFrame).getTargetListPanel();
            this._targetListPanel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ElevationPlotPanel.this._elevationPanel.setLegendItems(null);
                    ElevationPlotPanel.this._model.setTargets(ElevationPlotPanel.this._targetListPanel.getTargets());
                }
            });
        }
        this._targetListPanel.setTargets(this._model.getTargets());
    }

    public AbstractAction getPrintAction() {
        return this._printAction;
    }

    public AbstractAction getSaveAsAction() {
        return this._saveAsAction;
    }

    public AbstractAction getCloseAction() {
        return this._closeAction;
    }

    public AbstractAction getDateAction() {
        return this._dateAction;
    }

    public AbstractAction getTargetsAction() {
        return this._targetsAction;
    }

    public ElevationPanel getElevationPanel() {
        return this._elevationPanel;
    }

    public ObservationPanel getObservationPanel() {
        return this._observationPanel;
    }

    public void setShowLegend(boolean show) {
        this._elevationPanel.setShowLegend(show);
        this._observationPanel.setShowLegend(show);
    }

    public void updatePlotOptions() {
        if (this._plotTypeButtons != null) {
            this._plotTypePanel.setVisible(this._mainTabbedPane.getSelectedComponent() == this._elevationPanel);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Elevation Plot");
        frame.setIconImage(new ImageIcon(Resources.getResource((String)"images/Plot24.gif")).getImage());
        ElevationPlotPanel panel = new ElevationPlotPanel();
        frame.setJMenuBar(new ElevationPlotMenuBar(panel));
        panel.setIsMainWindow(true);
        SiteDesc site = ElevationPlotUtil.MAUNA_KEA;
        Date date = new Date();
        TargetDesc[] targets = new TargetDesc[]{new TargetDesc("m101", new WorldCoords("14:03:12.579", "+54:20:52.95"), "Test target 1", "High", "B2"), new TargetDesc("m51", new WorldCoords("13:29:52.452", "+47:11:39.83"), "Test target 2", "Low", "B2"), new TargetDesc("ngc1259", new WorldCoords("03:17:17.172", "+41:23:07.22"), "Test target 3", "Medium", "B2")};
        panel.setModel(new ElevationPlotModel(site, date, targets));
        frame.getContentPane().add((Component)panel, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener((WindowListener)new BasicWindowMonitor());
    }
}

