/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.vo;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import jsky.catalog.Catalog;
import jsky.catalog.FieldDesc;
import jsky.catalog.MemoryCatalog;
import jsky.catalog.RowCoordinates;
import jsky.catalog.vo.UcdSupport;
import jsky.catalog.vo.VoFieldDesc;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.util.DataSource;

public class VoTable
extends MemoryCatalog {
    private static final long serialVersionUID = 1L;
    private static final int MAX_ROWS = 10000;
    public static final String GENERATED_ID_DESC = "JSky Id column (generated)";
    private static StarTableFactory _starTableFactory;
    private transient StarTable _starTable;

    private static StarTableFactory _getStarTableFactory() {
        if (_starTableFactory == null) {
            _starTableFactory = new StarTableFactory();
        }
        return _starTableFactory;
    }

    public static VoTable createVoTable(String fileName) throws IOException {
        return VoTable.createVoTable(new File(fileName).toURI().toURL(), null, null);
    }

    public static VoTable createVoTable(URL url, String id, String name) throws IOException {
        return VoTable.createVoTable(url, id, name, null);
    }

    public static VoTable createVoTable(URL url, String id, String name, Catalog catalog) throws IOException {
        return VoTable.createVoTable(url, id, name, catalog, null);
    }

    public static VoTable createVoTable(URL url, String id, String name, Catalog catalog, String inputDataFormat) throws IOException {
        StarTableFactory factory = VoTable._getStarTableFactory();
        StarTable starTable = factory.makeStarTable(url, inputDataFormat);
        VoTable voTable = VoTable.createVoTable(starTable, catalog, 10000);
        if (name == null) {
            name = starTable.getName();
        }
        if (name == null) {
            name = id;
        }
        if (name == null) {
            name = "Unknown";
        }
        voTable.setName(name);
        voTable.setId(id);
        return voTable;
    }

    public static VoTable createVoTable(DataSource datsrc, String id, String name) throws IOException {
        StarTableFactory factory = VoTable._getStarTableFactory();
        StarTable starTable = factory.makeStarTable(datsrc);
        VoTable voTable = VoTable.createVoTable(starTable, null, 10000);
        if (name == null) {
            name = starTable.getName();
        }
        if (name == null) {
            name = id;
        }
        if (name == null) {
            name = "Unknown";
        }
        voTable.setName(name);
        voTable.setId(id);
        return voTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VoTable createVoTable(StarTable starTable, Catalog catalog, int maxRows) throws IOException {
        ColumnInfo colInfo;
        int i;
        FieldDesc[] fields;
        int numCols = starTable.getColumnCount();
        boolean hasIdColumn = VoTable._hasIdColumn(starTable);
        boolean hasRaDecColumn = VoTable._hasRaDecColumn(starTable);
        if (!hasIdColumn && hasRaDecColumn) {
            fields = new VoFieldDesc[numCols + 1];
            fields[0] = new VoFieldDesc(new ColumnInfo("Id"));
            fields[0].setIsId(true);
            fields[0].setDescription(GENERATED_ID_DESC);
            for (i = 0; i < numCols; ++i) {
                colInfo = starTable.getColumnInfo(i);
                fields[i + 1] = new VoFieldDesc(colInfo);
            }
        } else {
            fields = new VoFieldDesc[numCols];
            for (i = 0; i < numCols; ++i) {
                colInfo = starTable.getColumnInfo(i);
                fields[i] = new VoFieldDesc(colInfo);
            }
        }
        RowSequence rseq = starTable.getRowSequence();
        Vector dataVector = new Vector();
        int rowCount = 0;
        try {
            while (rseq.next()) {
                if (++rowCount > maxRows) {
                    break;
                }
                Object[] rowData = rseq.getRow();
                Vector<Object> row = new Vector<Object>(fields.length);
                ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(rowData));
                if (fields.length > numCols) {
                    list.add(0, rowCount);
                }
                row.addAll(list);
                dataVector.add(row);
            }
        }
        finally {
            rseq.close();
        }
        return new VoTable(starTable, catalog, fields, dataVector, hasRaDecColumn);
    }

    private static boolean _hasIdColumn(StarTable starTable) {
        int n = starTable.getColumnCount();
        for (int i = 0; i < n; ++i) {
            ColumnInfo colInfo = starTable.getColumnInfo(i);
            String name = colInfo.getName();
            if (!new UcdSupport(colInfo.getUCD()).isId() && !"id".equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean _hasRaDecColumn(StarTable starTable) {
        int n = starTable.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String ucd = starTable.getColumnInfo(i).getUCD();
            UcdSupport ucdSup = new UcdSupport(ucd);
            if (ucdSup.isRa() || ucdSup.isDec()) {
                return true;
            }
            String name = starTable.getColumnInfo(i).getName();
            if (!"ra".equalsIgnoreCase(name) && !"dec".equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public VoTable(StarTable starTable, Catalog catalog, FieldDesc[] fields, Vector dataVector, boolean hasRaDecColumn) {
        super(fields, dataVector);
        this._starTable = starTable;
        this.setName(starTable.getName());
        this.setId(starTable.getName());
        if (catalog != null) {
            this.setCatalog(catalog);
            this.setTitle("Query Results from: " + catalog.getTitle());
        } else {
            this.setCatalog(this);
            this.setTitle("Query Results");
        }
        if (hasRaDecColumn) {
            this._initRowCoordinates(fields);
        }
    }

    private void _initRowCoordinates(FieldDesc[] fields) {
        int raCol = -1;
        int decCol = -1;
        int i = 0;
        for (FieldDesc fd : fields) {
            if (fd.isRaMain()) {
                raCol = i;
            } else if (fd.isDecMain()) {
                decCol = i;
            }
            ++i;
        }
        if (raCol != -1 && decCol != -1) {
            this.setRowCoordinates(new RowCoordinates(raCol, decCol, 2000));
        }
    }

    @Override
    public StarTable getStarTable() {
        if (this._starTable != null && this._starTable.getRowCount() == (long)this.getRowCount()) {
            return this._starTable;
        }
        return super.getStarTable();
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        return this.getColumnDesc(columnIndex).getFieldClass();
    }
}

