/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.vo;

import java.net.MalformedURLException;
import java.net.URL;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.TableQueryResult;
import jsky.catalog.URLQueryResult;
import jsky.catalog.vo.UcdSupport;
import uk.ac.starlink.table.ColumnInfo;

public class VoFieldDesc
extends FieldDescAdapter {
    private static final long serialVersionUID = 1L;

    public VoFieldDesc(ColumnInfo colInfo) {
        super(colInfo.getName());
        this.setFieldClass(colInfo.getContentClass());
        this.setDescription(colInfo.getDescription());
        this.setUnits(colInfo.getUnitString());
        String ucd = colInfo.getUCD();
        this.setUCD(ucd);
        UcdSupport ucdSup = new UcdSupport(ucd);
        this.setIsRAMain(ucdSup.isRaMain() || "ra".equalsIgnoreCase(this.getName()));
        this.setIsDecMain(ucdSup.isDecMain() || "dec".equalsIgnoreCase(this.getName()));
        this.setIsRA(this.isRaMain() || ucdSup.isRa());
        this.setIsDec(this.isDecMain() || ucdSup.isDec());
    }

    @Override
    public String getLinkText(TableQueryResult tableQueryResult, Object value, int row, int column) {
        String format = this.getLinkFormat(tableQueryResult, row);
        if (format != null) {
            if (format.startsWith("image/")) {
                return "Display Image";
            }
            if ("text/html".equals(format)) {
                return "Show in Browser";
            }
            if (format.startsWith("spectrum/")) {
                return "Display Spectrum";
            }
        }
        return "Display";
    }

    @Override
    public String getLinkFormat(TableQueryResult tableQueryResult, int row) {
        int numCols = tableQueryResult.getColumnCount();
        for (int col = 0; col < numCols; ++col) {
            VoFieldDesc fd = (VoFieldDesc)tableQueryResult.getColumnDesc(col);
            if (!"format".equalsIgnoreCase(tableQueryResult.getColumnName(col)) && !new UcdSupport(fd.getUCD()).isFormat()) continue;
            return (String)tableQueryResult.getValueAt(row, col);
        }
        return null;
    }

    @Override
    public URLQueryResult getLinkValue(TableQueryResult tableQueryResult, Object value, int row) throws MalformedURLException {
        try {
            URLQueryResult result = new URLQueryResult(new URL(value.toString()));
            result.setFormat(this.getLinkFormat(tableQueryResult, row));
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean hasLink() {
        return new UcdSupport(this.getUCD()).isLink();
    }
}

