/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import jsky.catalog.AbstractSearchCondition;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.util.StringUtil;

public class ValueSearchCondition
extends AbstractSearchCondition {
    private Comparable _val;

    public ValueSearchCondition(FieldDesc fieldDesc, Comparable val) {
        super(fieldDesc);
        this._val = val;
    }

    public ValueSearchCondition(FieldDesc fieldDesc, double val) {
        this(fieldDesc, new Double(val));
    }

    public ValueSearchCondition(FieldDesc fieldDesc, String val) {
        this(fieldDesc, (Comparable)((Object)val.trim()));
    }

    public Comparable getVal() {
        return this._val;
    }

    @Override
    public boolean isTrueFor(Comparable val) {
        if (this._val instanceof String && val instanceof String) {
            return StringUtil.match((String)((String)((Object)this._val)), (String)((String)((Object)val)));
        }
        return this._val.compareTo(val) == 0;
    }

    @Override
    public boolean isTrueFor(double val) {
        return this.isTrueFor(new Double(val));
    }

    @Override
    public String getValueAsString() {
        return this._val.toString();
    }

    @Override
    public boolean isRegionArg() {
        FieldDesc fd = this.getFieldDesc();
        return fd != null && (fd.isRA() || fd.isDec() || fd.getName().equalsIgnoreCase("equinox"));
    }

    public static void main(String[] args) {
        ValueSearchCondition s = new ValueSearchCondition((FieldDesc)new FieldDescAdapter("X"), 22.0);
        if (!s.isTrueFor(22.0)) {
            throw new RuntimeException("test failed for 22.: " + s);
        }
        if (s.isTrueFor(23.0)) {
            throw new RuntimeException("test failed for 23.: " + s);
        }
        s = new ValueSearchCondition((FieldDesc)new FieldDescAdapter("S"), "aaa");
        if (!s.isTrueFor((Comparable)((Object)"aaa"))) {
            throw new RuntimeException("test failed for \"aaa\": " + s);
        }
        if (s.isTrueFor((Comparable)((Object)"mmm"))) {
            throw new RuntimeException("test failed for \"mmm\": " + s);
        }
        System.out.println("All tests passed");
    }
}

