/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.PlotableCatalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.RowCoordinates;
import jsky.catalog.SearchCondition;
import jsky.catalog.StarTableAdapter;
import jsky.catalog.TablePlotSymbol;
import jsky.catalog.TableQueryResult;
import jsky.coords.CoordinateRadius;
import jsky.coords.Coordinates;
import jsky.coords.WorldCoordinates;
import jsky.util.Saveable;
import jsky.util.SaveableAsHTML;
import jsky.util.StringTokenizerUtil;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.votable.FitsPlusTableWriter;
import uk.ac.starlink.votable.VOTableWriter;

public class MemoryCatalog
extends DefaultTableModel
implements TableQueryResult,
Saveable,
SaveableAsHTML {
    public static final String EQUINOX = "equinox";
    public static final String SYMBOL = "symbol";
    public static final String ID_COL = "id_col";
    public static final String RA_COL = "ra_col";
    public static final String DEC_COL = "dec_col";
    public static final String X_COL = "x_col";
    public static final String Y_COL = "y_col";
    private Catalog _catalog;
    private String _name;
    private String _id;
    private String _title;
    private String _description;
    private URL _docURL;
    private RowCoordinates _rowCoordinates;
    private FieldDesc[] _fields;
    private boolean _more = false;
    private boolean _readOnly = true;
    private Properties _properties = new Properties();
    private String _columnSeparator = "\t";
    private List<Class> _columnClasses;
    private String _filename;
    private QueryArgs _queryArgs;

    public MemoryCatalog(FieldDesc[] fields, Vector dataVector) {
        this._fields = fields;
        this.dataVector = dataVector;
        if (this._fields == null) {
            throw new RuntimeException("No columns defined for MemoryCatalog");
        }
        this.columnIdentifiers = this.makeColumnIdentifiers(this._fields);
    }

    public MemoryCatalog(Catalog catalog, InputStream in, int maxRows) throws IOException {
        this._catalog = catalog;
        this._init(in, maxRows);
        if (this._catalog != null) {
            this.setId(catalog.getId());
            this.setTitle("Query Results from: " + this._catalog.getTitle());
        }
    }

    public MemoryCatalog(Catalog catalog, InputStream in) throws IOException {
        this(catalog, in, -1);
    }

    public MemoryCatalog(Catalog catalog, InputStream in, QueryArgs queryArgs) throws IOException {
        this(catalog, in, queryArgs.getMaxRows());
        this._queryArgs = queryArgs;
    }

    public MemoryCatalog(Catalog catalog, String filename) throws IOException {
        this(catalog, new FileInputStream(filename));
        this._filename = filename;
        String name = new File(filename).getName();
        this.setName(name);
        this.setId(name);
        this.setTitle(name);
    }

    public MemoryCatalog(String filename) throws IOException {
        this(null, filename);
    }

    public MemoryCatalog(MemoryCatalog table, FieldDesc[] fields, Vector dataRows) {
        this(fields, dataRows);
        this.setName(table.getName());
        this.setId(table.getId());
        this.setTitle("Query Results from: " + table.getTitle());
        this._initColumnClasses();
    }

    protected MemoryCatalog() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void setCatalog(Catalog cat) {
        this._catalog = cat;
    }

    @Override
    public Catalog getCatalog() {
        return this._catalog;
    }

    protected void _init(InputStream in, int maxRows) throws IOException {
        Vector columnIdentifiers;
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String prevLine = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("***")) {
                throw new RuntimeException(line.substring(3));
            }
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            if (line.charAt(0) == '-') {
                if (prevLine == null) {
                    throw new IOException("Can't parse tab table header");
                }
                this.setColumnIdentifiers(this._parseHeading(prevLine));
                this._initFields();
                break;
            }
            prevLine = line;
            this._parseProperty(line);
        }
        if ((columnIdentifiers = this.getColumnIdentifiers()) == null) {
            this.setColumnIdentifiers(new Vector());
            this.dataVector = new Vector();
            return;
        }
        int n = columnIdentifiers.size();
        this._columnClasses = new ArrayList<Class>(n);
        for (int i = 0; i < n; ++i) {
            this._columnClasses.add(null);
        }
        this.dataVector = new Vector(1024, 256);
        int nrows = 1;
        while ((line = reader.readLine()) != null && !line.equals("[EOD]")) {
            this.dataVector.add(this._parseRow(line));
            if (maxRows <= 0 || nrows++ < maxRows) continue;
            break;
        }
    }

    protected void _parseProperty(String s) {
        int i = s.indexOf(58);
        if (i != -1) {
            String key = s.substring(0, i).trim();
            String value = s.substring(i + 1).trim();
            this._properties.setProperty(key, value);
        }
    }

    protected Vector _parseHeading(String s) {
        StringTokenizerUtil st = new StringTokenizerUtil(s, this._columnSeparator);
        Vector<String> v = new Vector<String>(st.countTokens(), 1);
        while (st.hasMoreTokens()) {
            v.add(st.nextToken().trim());
        }
        return v;
    }

    protected void _initFields() {
        int n = this.getColumnIdentifiers().size();
        FieldDesc[] fields = new FieldDescAdapter[n];
        for (int i = 0; i < n; ++i) {
            fields[i] = new FieldDescAdapter((String)this.getColumnIdentifiers().get(i));
        }
        RowCoordinates rowCoordinates = this.getRowCoordinates();
        if (rowCoordinates != null && rowCoordinates.isWCS()) {
            int decCol;
            int raCol = rowCoordinates.getRaCol();
            if (raCol >= 0 && raCol < n) {
                ((FieldDescAdapter)fields[raCol]).setIsRA(true);
            }
            if ((decCol = rowCoordinates.getDecCol()) >= 0 && decCol < n) {
                ((FieldDescAdapter)fields[decCol]).setIsDec(true);
            }
        }
        this.setFields(fields);
    }

    protected Vector<Object> _parseRow(String lineStr) {
        StringTokenizerUtil st = new StringTokenizerUtil(lineStr, this._columnSeparator);
        int numCols = this.columnIdentifiers.size();
        int i = 0;
        Vector<Object> row = new Vector<Object>(numCols, 1);
        while (st.hasMoreTokens() && i++ < numCols) {
            String s = st.nextToken().trim();
            if (s.length() != 0) {
                Object o = this._parseItem(s);
                this._checkColumnClass(i - 1, o);
                row.add(o);
                continue;
            }
            row.add(null);
        }
        while (i++ < numCols) {
            row.add(null);
        }
        return row;
    }

    protected Object _parseItem(String s) {
        try {
            return new Double(s);
        }
        catch (NumberFormatException numberFormatException) {
            return s;
        }
    }

    protected void _checkColumnClass(int col, Object o) {
        Class t = this._columnClasses.get(col);
        Class<?> c = o.getClass();
        if (t == null) {
            this._columnClasses.set(col, c);
        } else if (!c.equals(t)) {
            this._columnClasses.set(col, Object.class);
        }
    }

    @Override
    public Vector getColumnIdentifiers() {
        return this.columnIdentifiers;
    }

    protected Vector makeColumnIdentifiers(FieldDesc[] fields) {
        Vector<String> v = new Vector<String>(fields.length, 1);
        for (FieldDesc field : fields) {
            String label = field.getName();
            if (label == null) {
                label = "";
            }
            v.add(label);
        }
        return v;
    }

    @Override
    public String getName() {
        if (this._name != null) {
            return this._name;
        }
        if (this._id != null) {
            return this._id;
        }
        if (this._filename != null) {
            return new File(this._filename).getName();
        }
        return "unknown";
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    public String getFilename() {
        return this._filename;
    }

    public void setFilename(String filename) {
        this._filename = filename;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setId(String id) {
        this._id = id;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    public URL getDocURL() {
        return this._docURL;
    }

    public void setDocURL(URL docURL) {
        this._docURL = docURL;
    }

    @Override
    public int getNumParams() {
        return this._fields.length;
    }

    @Override
    public FieldDesc getParamDesc(int i) {
        return this._fields[i];
    }

    @Override
    public FieldDesc getParamDesc(String name) {
        for (FieldDesc field : this._fields) {
            if (field == null || !field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public int getNumColumns() {
        return this._fields.length;
    }

    @Override
    public FieldDesc getColumnDesc(int i) {
        return this._fields[i];
    }

    @Override
    public void setRegionArgs(QueryArgs queryArgs, CoordinateRadius region) {
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isImageServer() {
        return false;
    }

    @Override
    public String getType() {
        return "local";
    }

    @Override
    public void setParent(CatalogDirectory catDir) {
    }

    @Override
    public CatalogDirectory getParent() {
        return null;
    }

    @Override
    public Catalog[] getPath() {
        return null;
    }

    @Override
    public QueryResult query(QueryArgs queryArgs) throws IOException {
        int maxRows = queryArgs.getMaxRows();
        String objectId = queryArgs.getId();
        Vector<Vector> dataRows = new Vector<Vector>(Math.min(maxRows, 1024), Math.min(maxRows, 256));
        CoordinateRadius region = queryArgs.getRegion();
        SearchCondition[] conditions = queryArgs.getConditions();
        int[] searchCols = null;
        if (conditions != null) {
            searchCols = new int[conditions.length];
            for (int i = 0; i < conditions.length; ++i) {
                searchCols[i] = this.getColumnIndex(conditions[i].getName());
            }
        }
        int n = 0;
        int numRows = this.dataVector.size();
        for (int i = 0; i < numRows; ++i) {
            Vector row = (Vector)this.dataVector.get(i);
            if (!this.compareRow(row, objectId, region, conditions, searchCols)) continue;
            dataRows.add(row);
            if (maxRows != 0 && ++n >= maxRows + 1) break;
        }
        MemoryCatalog result = this.makeQueryResult(this._fields, dataRows);
        result.setName(this._name);
        result.setTitle(this._title);
        result.setDescription(this._description);
        result.setDocURL(this._docURL);
        result.setRowCoordinates(this._rowCoordinates);
        if (maxRows != 0 && n > maxRows) {
            result.setMore(true);
            result.setNumRows(maxRows);
        } else {
            result.setMore(false);
        }
        return result;
    }

    protected MemoryCatalog makeQueryResult(FieldDesc[] fields, Vector dataRows) {
        MemoryCatalog table = new MemoryCatalog(this, fields, dataRows);
        table.setProperties(this.getProperties());
        return table;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.getName();
    }

    protected boolean compareRow(Vector row, String objectId, CoordinateRadius region, SearchCondition[] conditions, int[] searchCols) {
        if (this._rowCoordinates != null) {
            Comparable tableValue;
            Coordinates pos;
            if (!(region == null || (pos = this._rowCoordinates.getCoordinates(row)) != null && region.contains(pos))) {
                return false;
            }
            int idCol = this._rowCoordinates.getIdCol();
            if (!(objectId == null || idCol < 0 || (tableValue = (Comparable)row.get(idCol)) != null && tableValue.equals(objectId))) {
                return false;
            }
        }
        if (conditions == null) {
            return true;
        }
        int n = conditions.length;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Comparable tableValue;
                int col;
                if (conditions[i].isRegionArg() || (col = searchCols[i]) == -1 || (tableValue = (Comparable)row.get(col)) != null && conditions[i].isTrueFor(tableValue)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isMore() {
        return this._more;
    }

    public void setMore(boolean more) {
        this._more = more;
    }

    public void setColumnIdentifiers(Vector columnIdentifiers) {
        this.columnIdentifiers = columnIdentifiers;
    }

    public boolean hasCol(String name) {
        return this.getColumnIndex(name) >= 0;
    }

    public Object getValueAt(int row, String name) {
        return this.getValueAt(row, this.getColumnIndex(name));
    }

    @Override
    public int getColumnIndex(String name) {
        int numCols = this.columnIdentifiers.size();
        for (int i = 0; i < numCols; ++i) {
            if (!name.equalsIgnoreCase((String)this.columnIdentifiers.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getColumnName(int index) {
        return (String)this.columnIdentifiers.get(index);
    }

    public Class getColumnClass(int columnIndex) {
        Class o = this._columnClasses.get(columnIndex);
        if (o != null && o instanceof Class) {
            return o;
        }
        return String.class;
    }

    public void setColumnClasses(List<Class> l) {
        this._columnClasses = l;
    }

    public void setColumnClasses(Class[] ar) {
        this._columnClasses = new ArrayList<Class>(ar.length);
        this._columnClasses.addAll(Arrays.asList(ar));
    }

    public FieldDesc[] getFields() {
        return this._fields;
    }

    public void setFields(FieldDesc[] fields) {
        this._fields = fields;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this._fields[columnIndex].hasLink() || !this._readOnly;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public void setReadOnly(boolean b) {
        this._readOnly = b;
    }

    @Override
    public boolean hasCoordinates() {
        return this._rowCoordinates != null;
    }

    @Override
    public Coordinates getCoordinates(int rowIndex) {
        if (this._rowCoordinates != null) {
            Vector row = (Vector)this.dataVector.get(rowIndex);
            return this._rowCoordinates.getCoordinates(row);
        }
        return null;
    }

    public void print() {
        int i;
        System.out.println("table: " + this.getTitle());
        int numCols = this.getColumnCount();
        int numRows = this.getRowCount();
        for (i = 0; i < numCols; ++i) {
            System.out.println("col(" + i + ") = " + this.getColumnName(i));
        }
        for (i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                System.out.println("table(" + i + "," + j + ") = " + this.getValueAt(i, j));
            }
        }
    }

    public void saveAs(String filename) throws IOException {
        FileOutputStream os = new FileOutputStream(filename);
        if (filename.endsWith(".vot") || filename.endsWith(".xml")) {
            this.saveAsVOTable(os);
        } else if (filename.endsWith(".fit") || filename.endsWith(".fts") || filename.endsWith(".fits")) {
            this.saveAsFitsTable(os);
        } else {
            this.saveAsSkycatTable(os);
        }
    }

    public void saveAsFitsTable(OutputStream os) throws IOException {
        new FitsPlusTableWriter().writeStarTable(this.getStarTable(), os);
    }

    public void saveAsVOTable(OutputStream os) throws IOException {
        new VOTableWriter().writeStarTable(this.getStarTable(), os);
    }

    public void saveAsSkycatTable(OutputStream os) {
        int col;
        int numCols = this.getColumnIdentifiers().size();
        int numRows = this.dataVector.size();
        int n = numCols - 1;
        if (numCols == 0) {
            return;
        }
        for (int col2 = 0; col2 < numCols; ++col2) {
            Class c = this.getColumnClass(col2);
            if (!c.isArray()) continue;
            throw new UnsupportedOperationException("Tables containing array data are not supported in this format. Please save to VOTABLE or FITS format.");
        }
        PrintStream out = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
        String newline = System.getProperty("line.separator");
        this._saveHeader(out);
        for (col = 0; col < numCols; ++col) {
            out.print(this.getColumnIdentifiers().get(col));
            if (col >= n) continue;
            out.print(this._columnSeparator);
        }
        out.print(newline);
        for (col = 0; col < numCols; ++col) {
            int l = ((String)this.getColumnIdentifiers().get(col)).length();
            for (int i = 0; i < l; ++i) {
                out.print("-");
            }
            if (col >= n) continue;
            out.print(this._columnSeparator);
        }
        out.print(newline);
        for (int row = 0; row < numRows; ++row) {
            Vector rowVec = (Vector)this.dataVector.get(row);
            for (int col3 = 0; col3 < numCols; ++col3) {
                out.print(rowVec.get(col3));
                if (col3 >= n) continue;
                out.print(this._columnSeparator);
            }
            out.print(newline);
        }
    }

    protected void _saveHeader(PrintStream out) {
        TablePlotSymbol[] symbols;
        String symbolInfo;
        Catalog cat;
        if (this._title != null) {
            out.println(this._title);
        } else {
            out.println("Table");
        }
        out.println("");
        RowCoordinates rowCoordinates = this.getRowCoordinates();
        if (rowCoordinates != null) {
            int decCol;
            int raCol;
            int idCol = rowCoordinates.getIdCol();
            if (idCol != 0) {
                this.setProperty(ID_COL, String.valueOf(idCol));
            }
            if ((raCol = rowCoordinates.getRaCol()) != 1) {
                this.setProperty(RA_COL, String.valueOf(raCol));
            }
            if ((decCol = rowCoordinates.getDecCol()) != 2) {
                this.setProperty(DEC_COL, String.valueOf(decCol));
            }
        }
        if ((cat = this.getCatalog()) instanceof PlotableCatalog && (symbolInfo = TablePlotSymbol.getPlotSymbolInfo(symbols = ((PlotableCatalog)cat).getSymbols())) != null) {
            this.setProperty(SYMBOL, symbolInfo);
        }
        if (this._properties.size() > 0) {
            this._saveProperties(out);
        }
    }

    protected void _saveProperties(PrintStream out) {
        out.println("# Begin properties");
        Enumeration<?> e = this._properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            out.println(key + ": " + this._properties.getProperty(key));
        }
        out.println("# End properties");
        out.println("");
    }

    public void saveAsHTML(String filename) throws IOException {
        FileOutputStream os = new FileOutputStream(filename);
        int numCols = this.getColumnIdentifiers().size();
        int numRows = this.dataVector.size();
        if (numCols == 0) {
            return;
        }
        PrintStream out = new PrintStream(os);
        out.println("<html>");
        out.println("<body>");
        out.println("<table BORDER COLS=" + numCols + " WIDTH=\"100%\" NOSAVE>");
        out.println("<caption>" + this.getTitle() + "</caption>");
        out.println("<tr>");
        for (int col = 0; col < numCols; ++col) {
            out.println("<th>" + this.getColumnIdentifiers().get(col) + "</th>");
        }
        out.println("</tr>");
        for (int row = 0; row < numRows; ++row) {
            Vector rowVec = (Vector)this.dataVector.get(row);
            out.println("<tr>");
            for (int col = 0; col < numCols; ++col) {
                out.println("<td>" + rowVec.get(col) + "</td>");
            }
            out.println("</tr>");
        }
        out.println("</table>");
        out.println("</body>");
        out.println("</html>");
    }

    @Override
    public QueryArgs getQueryArgs() {
        return this._queryArgs;
    }

    @Override
    public void setQueryArgs(QueryArgs queryArgs) {
        this._queryArgs = queryArgs;
    }

    @Override
    public RowCoordinates getRowCoordinates() {
        PlotableCatalog cat;
        if (this._rowCoordinates != null) {
            return this._rowCoordinates;
        }
        if (this._catalog instanceof PlotableCatalog && (cat = (PlotableCatalog)this._catalog).getNumSymbols() != 0) {
            TablePlotSymbol plotSym = cat.getSymbolDesc(0);
            this._rowCoordinates = plotSym.getRowCoordinates();
        }
        return this._rowCoordinates;
    }

    public void setRowCoordinates(RowCoordinates rowCoordinates) {
        this._rowCoordinates = rowCoordinates;
    }

    @Override
    public WorldCoordinates getWCSCenter() {
        Vector<Vector> dataVec;
        Vector rowVec;
        Coordinates pos;
        RowCoordinates rowCoordinates;
        Coordinates pos2;
        if (this._queryArgs != null && this._queryArgs.getRegion() != null && (pos2 = this._queryArgs.getRegion().getCenterPosition()) instanceof WorldCoordinates) {
            return (WorldCoordinates)pos2;
        }
        int nrows = this.getRowCount();
        if (nrows != 0 && (rowCoordinates = this.getRowCoordinates()) != null && rowCoordinates.isWCS() && (pos = rowCoordinates.getCoordinates(rowVec = (dataVec = this.getDataVector()).get(0))) instanceof WorldCoordinates) {
            return (WorldCoordinates)pos;
        }
        return null;
    }

    protected void _initColumnClasses() {
        int numCols = this.getColumnIdentifiers().size();
        int numRows = this.dataVector.size();
        this._columnClasses = new ArrayList<Class>(numCols);
        for (int col = 0; col < numCols; ++col) {
            this._columnClasses.add(null);
        }
        for (int row = 0; row < numRows; ++row) {
            Vector rowVec = (Vector)this.dataVector.get(row);
            int n = rowVec.size();
            for (int col = 0; col < n; ++col) {
                Object o = rowVec.get(col);
                if (o == null) continue;
                this._checkColumnClass(col, o);
            }
        }
    }

    public Properties getProperties() {
        return this._properties;
    }

    public void setProperties(Properties p) {
        this._properties = p;
    }

    public String getProperty(String key) {
        return this._properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this._properties.setProperty(key, value);
    }

    @Override
    public List<Object> getRowData(int row) {
        return new ArrayList<Object>((List)this.dataVector.get(row));
    }

    @Override
    public StarTable getStarTable() {
        return new StarTableAdapter(this);
    }

    @Override
    public Catalog reload() {
        return this;
    }

    public static void main(String[] args) {
        int i;
        int j;
        int numRows = 6;
        int numCols = 4;
        FieldDesc[] columns = new FieldDescAdapter[numCols];
        for (int i2 = 0; i2 < numCols; ++i2) {
            columns[i2] = new FieldDescAdapter("Col-" + i2);
        }
        Vector rows = new Vector(numRows, 1);
        for (int i3 = 0; i3 < numRows; ++i3) {
            Vector<String> cols = new Vector<String>(numCols, 1);
            for (j = 0; j < numCols; ++j) {
                cols.add("item-" + i3 + "," + j);
            }
            rows.add(cols);
        }
        MemoryCatalog cat = new MemoryCatalog(columns, rows);
        cat.setName("test cat");
        System.out.println("test row,col access:");
        for (i = 0; i < numCols; ++i) {
            System.out.println("col(" + i + ") = " + cat.getColumnName(i));
        }
        for (i = 0; i < numRows; ++i) {
            for (j = 0; j < numCols; ++j) {
                System.out.println("table(" + i + "," + j + ") = " + cat.getValueAt(i, j));
            }
        }
        try {
            int i4;
            System.out.println("test query:");
            BasicQueryArgs queryArgs = new BasicQueryArgs(cat);
            queryArgs.setParamValue("Col-2", (Object)"item-2,2");
            TableQueryResult result = (TableQueryResult)cat.query(queryArgs);
            System.out.println("result rows: " + result.getRowCount());
            for (i4 = 0; i4 < result.getColumnCount(); ++i4) {
                System.out.println("col(" + i4 + ") = " + result.getColumnName(i4));
            }
            for (i4 = 0; i4 < result.getRowCount(); ++i4) {
                for (int j2 = 0; j2 < result.getColumnCount(); ++j2) {
                    System.out.println("table(" + i4 + "," + j2 + ") = " + result.getValueAt(i4, j2));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

