/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.checkers;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.CapturesArgumensFromInvocation;
import org.mockito.internal.invocation.InvocationMarker;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.reporting.Discrepancy;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonGreedyNumberOfInvocationsInOrderChecker {
    private final InvocationsFinder finder;
    private final Reporter reporter;
    private final InvocationMarker marker;

    public NonGreedyNumberOfInvocationsInOrderChecker() {
        this(new InvocationsFinder(), new Reporter(), new InvocationMarker());
    }

    NonGreedyNumberOfInvocationsInOrderChecker(InvocationsFinder finder, Reporter reporter, InvocationMarker marker) {
        this.finder = finder;
        this.reporter = reporter;
        this.marker = marker;
    }

    public void check(List<Invocation> invocations, InvocationMatcher wanted, int wantedCount, InOrderContext context) {
        Location lastLocation = null;
        for (int actualCount = 0; actualCount < wantedCount; ++actualCount) {
            Invocation next = this.finder.findFirstMatchingUnverifiedInvocation(invocations, wanted, context);
            if (next == null) {
                this.reporter.tooLittleActualInvocationsInOrder(new Discrepancy(wantedCount, actualCount), wanted, lastLocation);
            }
            this.marker.markVerified(next, (CapturesArgumensFromInvocation)wanted);
            context.markVerified(next);
            lastLocation = next.getLocation();
        }
    }
}

