/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.mockito.internal.matchers.ArrayEquals;
import org.mockito.internal.matchers.Equals;
import org.mockito.internal.util.collections.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentsProcessor {
    public static Object[] expandVarArgs(boolean isVarArgs, Object[] args) {
        if (!isVarArgs || new ArrayUtils().isEmpty(args) || args[args.length - 1] != null && !args[args.length - 1].getClass().isArray()) {
            return args == null ? new Object[]{} : args;
        }
        int nonVarArgsCount = args.length - 1;
        Object[] varArgs = args[nonVarArgsCount] == null ? new Object[]{null} : ArrayEquals.createObjectArray(args[nonVarArgsCount]);
        int varArgsCount = varArgs.length;
        Object[] newArgs = new Object[nonVarArgsCount + varArgsCount];
        System.arraycopy(args, 0, newArgs, 0, nonVarArgsCount);
        System.arraycopy(varArgs, 0, newArgs, nonVarArgsCount, varArgsCount);
        return newArgs;
    }

    public static List<Matcher> argumentsToMatchers(Object[] arguments) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>(arguments.length);
        for (Object arg : arguments) {
            if (arg != null && arg.getClass().isArray()) {
                matchers.add((Matcher)new ArrayEquals(arg));
                continue;
            }
            matchers.add((Matcher)new Equals(arg));
        }
        return matchers;
    }
}

