/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.reflection.FieldInitializationReport;
import org.mockito.internal.util.reflection.FieldInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpyAnnotationEngine
implements AnnotationEngine {
    @Override
    public Object createMockFor(Annotation annotation, Field field) {
        return null;
    }

    @Override
    public void process(Class<?> context, Object testInstance) {
        Field[] fields;
        for (Field field : fields = context.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Spy.class) || field.isAnnotationPresent(InjectMocks.class)) continue;
            this.assertNoIncompatibleAnnotations(Spy.class, field, Mock.class, MockitoAnnotations.Mock.class, Captor.class);
            Object instance = null;
            try {
                FieldInitializationReport report = new FieldInitializer(testInstance, field).initialize();
                instance = report.fieldInstance();
            }
            catch (MockitoException e) {
                new Reporter().cannotInitializeForSpyAnnotation(field.getName(), e);
            }
            try {
                if (new MockUtil().isMock(instance)) {
                    Mockito.reset(instance);
                    continue;
                }
                field.setAccessible(true);
                field.set(testInstance, Mockito.mock(instance.getClass(), Mockito.withSettings().spiedInstance(instance).defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field.getName())));
            }
            catch (IllegalAccessException e) {
                throw new MockitoException("Problems initiating spied field " + field.getName(), e);
            }
        }
    }

    void assertNoIncompatibleAnnotations(Class annotation, Field field, Class ... undesiredAnnotations) {
        for (Class u : undesiredAnnotations) {
            if (!field.isAnnotationPresent(u)) continue;
            new Reporter().unsupportedCombinationOfAnnotations(annotation.getSimpleName(), annotation.getClass().getSimpleName());
        }
    }
}

