/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.connect;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.connect.AuthKey;
import uk.ac.starlink.connect.Branch;
import uk.ac.starlink.connect.Connector;

public abstract class Connection {
    private final Map keys_;
    private final Connector connector_;
    private boolean tidy_;
    private LogoutThread shutdownHook_;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.connect");

    protected Connection() {
        this(null, new HashMap());
    }

    protected Connection(Connector connector, Map keys) {
        this.connector_ = connector;
        this.keys_ = keys == null ? new HashMap() : new HashMap(keys);
    }

    public Object getAuthValue(AuthKey key) {
        return (String)this.keys_.get(key);
    }

    public Connector getConnector() {
        return this.connector_;
    }

    public abstract boolean isConnected();

    public abstract void logOut() throws IOException;

    public abstract Branch getRoot();

    public synchronized void setLogoutOnExit(boolean tidy) {
        if (tidy && this.shutdownHook_ == null) {
            this.shutdownHook_ = new LogoutThread();
            Runtime.getRuntime().addShutdownHook(this.shutdownHook_);
        } else if (!tidy && this.shutdownHook_ != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook_);
            this.shutdownHook_ = null;
        }
    }

    public String toString() {
        return this.connector_ == null ? super.toString() : this.connector_.getName() + " connection";
    }

    private class LogoutThread
    extends Thread {
        LogoutThread() {
            super("Logout from " + Connection.this.toString());
        }

        public void run() {
            if (Connection.this.isConnected()) {
                logger_.info("Logging out from " + Connection.this.toString());
                try {
                    Connection.this.logOut();
                }
                catch (IOException e) {
                    logger_.warning("Logout error: " + e.getMessage());
                }
            }
        }
    }
}

