/*
 * Decompiled with CFR 0.152.
 */
package alma.hla.datamodel.enumerations.workflow;

import alma.hla.datamodel.enumerations.util.AlmaModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.lib.AbstractWorkflowComponent;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;

public class EnumerationWorkflowInitializer
extends AbstractWorkflowComponent {
    private String enumerationsFile;
    private String cvsRevision;
    private String cvsBranch;
    private String lastModifiedDate;

    public void invoke(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        AlmaModel.setCvsRevision(this.cvsRevision);
        AlmaModel.setCvsBranch(this.cvsBranch);
        AlmaModel.setModelFile(this.enumerationsFile);
        AlmaModel.setLastModifiedDate(this.lastModifiedDate);
    }

    public void setEnumerationsFile(String cf) {
        BufferedReader rdr;
        this.enumerationsFile = cf;
        File f = new File(cf);
        File entries = new File(f.getParent() + File.separator + "CVS" + File.separator + "Entries");
        String modelName = f.getName();
        try {
            rdr = new BufferedReader(new FileReader(entries));
        }
        catch (FileNotFoundException e) {
            this.cvsRevision = "-1";
            this.cvsBranch = "";
            System.out.println("CVS Entries file not found");
            return;
        }
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                if (!line.contains(modelName)) continue;
                String[] fields = line.split("/");
                this.cvsRevision = fields[2];
                this.lastModifiedDate = fields[3];
                System.out.println("Enumerations CVS revision is: " + this.cvsRevision);
                if (fields.length > 5) {
                    this.cvsBranch = fields[5];
                    System.out.println(this.cvsBranch);
                    if (this.cvsBranch.charAt(0) == 'T') {
                        this.cvsBranch = this.cvsBranch.substring(1);
                        System.out.println("ASDM CVS branch is:" + this.cvsBranch);
                    } else {
                        this.cvsBranch = "";
                        System.out.println("Tag information does not represent a branch");
                    }
                } else {
                    this.cvsBranch = "HEAD";
                }
                return;
            }
            this.cvsRevision = "-1";
            System.out.println("Couldn't find filename " + modelName + " in CVS/Entries");
            return;
        }
        catch (IOException e) {
            this.cvsRevision = "-1";
            System.out.println("Error in readLine from CVS/Entries");
            return;
        }
    }

    public void checkConfiguration(Issues issues) {
    }
}

