/*
 * Decompiled with CFR 0.152.
 */
package alma.common.calibratorCatalogue.calQueryParameters;

import alma.common.calibratorCatalogue.calQueryParameters.types.CalibrationUseType;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Date;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class CalQueryParameters
implements Serializable {
    private double rightAscension = 0.0;
    private boolean _hasrightAscension;
    private double declination = 0.0;
    private boolean _hasdeclination;
    private double radius = 0.0;
    private boolean _hasradius;
    private double minFrequency = 0.0;
    private boolean _hasminFrequency;
    private double maxFrequency = 0.0;
    private boolean _hasmaxFrequency;
    private double minFlux = 0.0;
    private boolean _hasminFlux;
    private double maxFlux = 0.0;
    private boolean _hasmaxFlux;
    private Date earliestObservation;
    private Date latestObservation;
    private CalibrationUseType calibrationUse = CalibrationUseType.valueOf("UNDEFINED");

    public CalQueryParameters() {
        this.setCalibrationUse(CalibrationUseType.valueOf("UNDEFINED"));
    }

    public void deleteDeclination() {
        this._hasdeclination = false;
    }

    public void deleteMaxFlux() {
        this._hasmaxFlux = false;
    }

    public void deleteMaxFrequency() {
        this._hasmaxFrequency = false;
    }

    public void deleteMinFlux() {
        this._hasminFlux = false;
    }

    public void deleteMinFrequency() {
        this._hasminFrequency = false;
    }

    public void deleteRadius() {
        this._hasradius = false;
    }

    public void deleteRightAscension() {
        this._hasrightAscension = false;
    }

    public CalibrationUseType getCalibrationUse() {
        return this.calibrationUse;
    }

    public double getDeclination() {
        return this.declination;
    }

    public Date getEarliestObservation() {
        return this.earliestObservation;
    }

    public Date getLatestObservation() {
        return this.latestObservation;
    }

    public double getMaxFlux() {
        return this.maxFlux;
    }

    public double getMaxFrequency() {
        return this.maxFrequency;
    }

    public double getMinFlux() {
        return this.minFlux;
    }

    public double getMinFrequency() {
        return this.minFrequency;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getRightAscension() {
        return this.rightAscension;
    }

    public boolean hasDeclination() {
        return this._hasdeclination;
    }

    public boolean hasMaxFlux() {
        return this._hasmaxFlux;
    }

    public boolean hasMaxFrequency() {
        return this._hasmaxFrequency;
    }

    public boolean hasMinFlux() {
        return this._hasminFlux;
    }

    public boolean hasMinFrequency() {
        return this._hasminFrequency;
    }

    public boolean hasRadius() {
        return this._hasradius;
    }

    public boolean hasRightAscension() {
        return this._hasrightAscension;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void setCalibrationUse(CalibrationUseType calibrationUse) {
        this.calibrationUse = calibrationUse;
    }

    public void setDeclination(double declination) {
        this.declination = declination;
        this._hasdeclination = true;
    }

    public void setEarliestObservation(Date earliestObservation) {
        this.earliestObservation = earliestObservation;
    }

    public void setLatestObservation(Date latestObservation) {
        this.latestObservation = latestObservation;
    }

    public void setMaxFlux(double maxFlux) {
        this.maxFlux = maxFlux;
        this._hasmaxFlux = true;
    }

    public void setMaxFrequency(double maxFrequency) {
        this.maxFrequency = maxFrequency;
        this._hasmaxFrequency = true;
    }

    public void setMinFlux(double minFlux) {
        this.minFlux = minFlux;
        this._hasminFlux = true;
    }

    public void setMinFrequency(double minFrequency) {
        this.minFrequency = minFrequency;
        this._hasminFrequency = true;
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this._hasradius = true;
    }

    public void setRightAscension(double rightAscension) {
        this.rightAscension = rightAscension;
        this._hasrightAscension = true;
    }

    public static CalQueryParameters unmarshalCalQueryParameters(Reader reader) throws MarshalException, ValidationException {
        return (CalQueryParameters)Unmarshaller.unmarshal(CalQueryParameters.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

