/*
 * Decompiled with CFR 0.152.
 */
package alma.acacorrelator.ACACorrConfigValidator;

import alma.Correlator.CorrelatorConfiguration;
import alma.acacorrelator.ACACorrConfigValidator.ACA_XMLUnmarshaller;
import alma.correlatorSrc.CorrConfigValidator.SBConversionException;
import alma.correlatorSrc.CorrConfigValidator.XMLParserBase;
import alma.correlatorSrc.CorrConfigValidator.XMLUnmarshaller;
import alma.entity.xmlbinding.schedblock.SpectralSpecT;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.SerializationUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class ACA_XMLParser
extends XMLParserBase {
    static final Logger logger = Logger.getLogger(ACA_XMLParser.class.getName());

    public CorrelatorConfiguration getOneCorrelatorConfiguration(SpectralSpecT spectralSpec) throws SBConversionException {
        XMLUnmarshalUtil.validate(spectralSpec);
        spectralSpec = (SpectralSpecT)SerializationUtils.clone((Serializable)spectralSpec);
        XMLUnmarshalUtil.sortSpectralWindowsInPlace(spectralSpec);
        return ACA_XMLUnmarshaller.convert(spectralSpec);
    }

    static class XMLUnmarshalUtil
    extends XMLUnmarshaller {
        XMLUnmarshalUtil() {
        }

        static int getSwNumberFromSwName(String swName) {
            return XMLUnmarshalUtil.swNumberFromSwName((String)swName);
        }

        static void sortSpectralWindowsInPlace(SpectralSpecT spectralSpec) {
            XMLUnmarshalUtil.sortSpectralWindows((SpectralSpecT)spectralSpec);
        }

        static void validate(SpectralSpecT spectralSpec) throws SBConversionException {
            String errMsg = "XML Validation error";
            try {
                spectralSpec.validate();
                try (StringWriter sw = new StringWriter();){
                    spectralSpec.marshal((Writer)sw);
                }
                String xml = sw.toString();
                XMLUnmarshalUtil.unmarshalSpectralSpecFromString((String)xml);
            }
            catch (MarshalException e) {
                logger.log(Level.FINE, "XML Validation error", e);
                throw new SBConversionException("XML Validation error", (Throwable)e);
            }
            catch (ValidationException e) {
                logger.log(Level.FINE, "XML Validation error", e);
                throw new SBConversionException("XML Validation error", (Throwable)e);
            }
            catch (JAXBException e) {
                logger.log(Level.FINE, "XML Validation error", e);
                throw new SBConversionException("XML Validation error", (Throwable)e);
            }
            catch (IOException e) {
                logger.log(Level.FINE, "XML Validation error", e);
                throw new SBConversionException("XML Validation error", (Throwable)e);
            }
            catch (XMLUnmarshaller.UnmarshalException e) {
                logger.log(Level.FINE, "XML Validation error", e);
                throw new SBConversionException("XML Validation error", (Throwable)e);
            }
        }
    }
}

