/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.votable.FieldElement;
import uk.ac.starlink.votable.FieldRefElement;
import uk.ac.starlink.votable.GroupElement;
import uk.ac.starlink.votable.LinkElement;
import uk.ac.starlink.votable.ParamElement;
import uk.ac.starlink.votable.ParamRefElement;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.ValuesElement;
import uk.ac.starlink.votable.dom.DelegatingAttr;
import uk.ac.starlink.votable.dom.DelegatingDocument;
import uk.ac.starlink.votable.dom.DelegatingElement;
import uk.ac.starlink.votable.dom.DelegatingNode;

public class VODocument
extends DelegatingDocument {
    private final String systemId_;
    private final Map idMap_ = new HashMap();
    private StoragePolicy storagePolicy_ = StoragePolicy.PREFER_MEMORY;
    private boolean strict_;

    VODocument(Document base, String systemId, boolean strict) {
        super(base, systemId);
        this.systemId_ = systemId;
        this.strict_ = strict;
    }

    public VODocument(String systemId, boolean strict) {
        super(systemId);
        this.systemId_ = systemId;
        this.strict_ = strict;
    }

    public VODocument() {
        this((String)null, VOElementFactory.isStrictByDefault());
    }

    public String getSystemId() {
        return this.systemId_;
    }

    public StoragePolicy getStoragePolicy() {
        return this.storagePolicy_;
    }

    public void setStoragePolicy(StoragePolicy policy) {
        this.storagePolicy_ = policy;
    }

    public void setElementId(Element el, String id) {
        this.idMap_.put(id, el);
    }

    public Element getElementById(String elementId) {
        return (Element)this.idMap_.get(elementId);
    }

    public DelegatingNode getDelegator(Node base) {
        return super.getDelegator(base);
    }

    protected DelegatingElement createDelegatingElement(Element node) {
        String tagName = node.getTagName();
        if ("FIELD".equals(tagName)) {
            return new FieldElement(node, this);
        }
        if ("LINK".equals(tagName)) {
            return new LinkElement(node, this);
        }
        if ("PARAM".equals(tagName)) {
            return new ParamElement(node, this);
        }
        if ("TABLE".equals(tagName)) {
            return new TableElement(node, this);
        }
        if ("VALUES".equals(tagName)) {
            return new ValuesElement(node, this);
        }
        if ("GROUP".equals(tagName)) {
            return new GroupElement(node, this);
        }
        if ("FIELDref".equals(tagName)) {
            return new FieldRefElement(node, this);
        }
        if ("PARAMref".equals(tagName)) {
            return new ParamRefElement(node, this);
        }
        return new VOElement(node, this);
    }

    protected DelegatingAttr createDelegatingAttr(Attr baseNode) {
        return "ID".equals(baseNode.getName()) ? super.createDelegatingAttr(baseNode, true) : super.createDelegatingAttr(baseNode);
    }

    boolean isStrict() {
        return this.strict_;
    }
}

